/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.wizard.steps;

import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.attach.wizard.WizardContext;
import org.netbeans.modules.profiler.attach.wizard.functors.ConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.functors.TrueConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.screen.NullWizardScreen;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.NullWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStepVisitor;

public class ProxyWizardStep
implements WizardStep {
    private ConditionalFunctor condition;
    private WizardContext context;
    private WizardStep nullStep;
    private WizardStep proxiedStep;

    public ProxyWizardStep(WizardContext context, String title) {
        this(context, title, new TrueConditionalFunctor());
    }

    public ProxyWizardStep(WizardContext context, String title, ConditionalFunctor condition) {
        this.proxiedStep = this.nullStep = new NullWizardStep(title);
        this.context = context;
        this.condition = condition;
    }

    @Override
    public WizardScreen getAttachedScreen() {
        if (this.canHandle()) {
            return this.proxiedStep.getAttachedScreen();
        }
        return new NullWizardScreen();
    }

    @Override
    public boolean isBegin() {
        return !this.canHandle() || this.proxiedStep.isBegin();
    }

    @Override
    public void setCurrent() {
        if (this.canHandle()) {
            this.proxiedStep.setCurrent();
        }
    }

    @Override
    public boolean isCurrent() {
        return this.canHandle() && this.proxiedStep.isCurrent();
    }

    @Override
    public boolean isEnd() {
        return !this.canHandle() || this.proxiedStep.isEnd();
    }

    @Override
    public void setFirst() {
        if (this.canHandle()) {
            this.proxiedStep.setFirst();
        }
    }

    @Override
    public boolean isFirst() {
        return this.canHandle() && this.proxiedStep.isFirst();
    }

    @Override
    public void setLast() {
        if (this.canHandle()) {
            this.proxiedStep.setLast();
        }
    }

    @Override
    public boolean isLast() {
        return this.canHandle() && this.proxiedStep.isLast();
    }

    @Override
    public void setNext() {
        if (this.canHandle()) {
            this.proxiedStep.setNext();
        }
    }

    @Override
    public void setPrevious() {
        if (this.canHandle()) {
            this.proxiedStep.setPrevious();
        }
    }

    @Override
    public int getStepIndex() {
        if (this.canHandle()) {
            return this.proxiedStep.getStepIndex();
        }
        return 0;
    }

    @Override
    public String getTitle() {
        if (this.canHandle()) {
            return this.proxiedStep.getTitle();
        }
        return "";
    }

    @Override
    public void setWizardContext(WizardContext context) {
        this.context = context;
        this.proxiedStep.setWizardContext(context);
    }

    public void setWizardStep(WizardStep proxiedStep) {
        this.proxiedStep = proxiedStep;
        this.proxiedStep.setWizardContext(this.context);
    }

    @Override
    public void accept(WizardStepVisitor visitor, WizardContext context, int level) {
        if (this.canHandle()) {
            visitor.visit(this.proxiedStep, context, level);
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.proxiedStep.addChangeListener(listener);
    }

    @Override
    public boolean canBack() {
        return this.canHandle() && this.proxiedStep.canBack();
    }

    @Override
    public boolean canFinish() {
        return this.canHandle() && this.proxiedStep.canFinish();
    }

    @Override
    public boolean canHandle() {
        return this.condition.evaluate(this.context) && this.proxiedStep.canHandle();
    }

    @Override
    public boolean canNext() {
        return this.canHandle() && this.proxiedStep.canNext();
    }

    @Override
    public boolean onCancel() {
        return this.proxiedStep.onCancel();
    }

    @Override
    public void onFinish() {
        this.proxiedStep.onFinish();
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.proxiedStep.removeChangeListener(listener);
    }

    public void reset() {
        this.proxiedStep = this.nullStep;
    }
}

