/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.db.h2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.util.Exceptions;

final class RcFile {
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    private final File file;

    synchronized String get(String section, String key, String defaultValue) {
        Section sect = this.sections.get(section);
        return sect == null ? defaultValue : sect.get(key, defaultValue);
    }

    String get(String section, String key) {
        return this.get(section, key, null);
    }

    void put(String sectionName, String key, String value) throws IOException {
        Section section = this.sections.get(sectionName);
        if (section == null) {
            section = new Section(sectionName);
        }
        section.put(key, value);
        this.sections.put(sectionName, section);
    }

    boolean containsKey(String section, String key) {
        Section sect = this.sections.get(section);
        return sect == null ? false : sect.containsKey(key);
    }

    synchronized Collection<String> getSections() {
        ArrayList<String> result = new ArrayList<String>();
        for (Section section : this.sections.values()) {
            result.add(section.name);
        }
        return result;
    }

    synchronized Collection<String> getKeys(String section) {
        Section sect = this.sections.get(section);
        return sect == null ? Collections.emptyList() : sect.getKeys();
    }

    RcFile(File file) throws IOException, FormatException {
        this.file = file;
        this.read();
    }

    private void read() throws IOException, FormatException {
        String str;
        if (!this.file.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        Pattern commentPattern = Pattern.compile("(#.*)|([ \t]*)");
        Pattern sectionPattern = Pattern.compile("\\[(.*)\\] *");
        Pattern valuePattern = Pattern.compile("([^=]+)=(.*)");
        Pattern justKeyPattern = Pattern.compile("[^=]+");
        Section currSection = new Section("");
        while ((str = reader.readLine()) != null) {
            String value;
            String key;
            if (commentPattern.matcher(str).matches()) continue;
            if (sectionPattern.matcher(str).matches()) {
                str = str.trim();
                String name = str.substring(1, str.length() - 1);
                currSection = new Section(name);
                this.sections.put(name, currSection);
                continue;
            }
            Matcher m = valuePattern.matcher(str);
            if (m.matches()) {
                key = m.group(1).trim();
                value = m.group(2).trim();
                currSection.put(key, value);
                continue;
            }
            if (justKeyPattern.matcher(str).matches()) {
                key = str.trim();
                value = null;
                currSection.put(key, value);
                continue;
            }
            throw new FormatException(str);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.file.getAbsolutePath();
    }

    synchronized void dump() {
        this.dump(System.out);
    }

    synchronized void dump(PrintStream ps) {
        for (Section section : this.sections.values()) {
            ps.printf("[%s]\n", section.name);
            for (String key : section.getKeys()) {
                String value = section.get(key, null);
                ps.printf("%s=%s\n", key, value);
            }
        }
    }

    synchronized void save() {
        try {
            this.dump(new PrintStream(this.file));
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private class Section {
        public final String name;
        private final Map<String, String> map = new TreeMap<String, String>();

        public Section(String name) throws IOException {
            this.name = name;
        }

        public synchronized String get(String key, String defaultValue) {
            if (this.map.containsKey(key)) {
                return this.map.get(key);
            }
            return defaultValue;
        }

        public synchronized Collection<String> getKeys() {
            return new ArrayList<String>(this.map.keySet());
        }

        public synchronized boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        synchronized void put(String key, String value) {
            this.map.put(key, value);
        }
    }

    static class FormatException
    extends Exception {
        public FormatException(String message) {
            super(message);
        }
    }
}

