/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.ui.KenaiComboModel;
import org.netbeans.modules.kenai.ui.KenaiSearchPanel;
import org.netbeans.modules.kenai.ui.nodes.AddInstanceAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SearchField
extends JPanel
implements ActionListener {
    private Kenai selected;
    private static final String KENAI = "kenai";
    static final String SEARCH = "search";
    private JTextComponent command = this.createCommandField();
    private JLabel leftIcon;
    private JPanel panel;
    private JScrollPane scrollPane;
    private JSeparator separator;

    public SearchField() {
        this.initComponents();
    }

    public SearchField(Kenai kenai) {
        this.selected = kenai;
        this.initComponents();
        this.setTooltip();
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.leftIcon = new JLabel();
        this.scrollPane = new JScrollPane();
        this.separator = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.panel.setBackground(SearchField.getTextBackground());
        this.panel.setBorder(BorderFactory.createLineBorder(SearchField.getComboBorderColor()));
        this.panel.setLayout(new GridBagLayout());
        this.leftIcon.setIcon(this.selected != null ? this.selected.getIcon() : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/kenai-small.png", (boolean)true));
        this.leftIcon.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.leftIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SearchField.this.leftIconMousePressed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 2, 1, 1);
        this.panel.add((Component)this.leftIcon, gridBagConstraints);
        this.scrollPane.setBorder(null);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setViewportBorder(null);
        this.scrollPane.setMinimumSize(new Dimension(2, 18));
        this.scrollPane.setViewportView(this.command);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.panel.add((Component)this.scrollPane, gridBagConstraints);
        this.separator.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.panel.add((Component)this.separator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panel, gridBagConstraints);
    }

    public String getText() {
        return this.command.getText();
    }

    public void setText(String text) {
        this.command.setText(text);
    }

    private void leftIconMousePressed(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    protected JTextComponent createCommandField() {
        JTextArea res = new JTextArea();
        res.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchLabel.text"));
        res.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchLabel.AccessibleContext.accessibleDescription"));
        res.setRows(1);
        res.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        for (InputMap curIm = res.getInputMap(0); curIm != null; curIm = curIm.getParent()) {
            curIm.remove(KeyStroke.getKeyStroke(79, 192));
        }
        res.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SearchField.this.actionPerformed(new ActionEvent(e.getSource(), e.getID(), SearchField.SEARCH, e.getWhen(), e.getModifiers()));
                    e.consume();
                }
            }
        });
        return res;
    }

    private static Color getTextBackground() {
        Color textB = UIManager.getColor("TextPane.background");
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            textB = UIManager.getColor("NbExplorerView.background");
        }
        return textB != null ? textB : Color.WHITE;
    }

    private static Color getComboBorderColor() {
        Color shadow = UIManager.getColor(Utilities.isWindows() ? "Nb.ScrollPane.Border.color" : "TextField.shadow");
        return shadow != null ? shadow : SearchField.getPopupBorderColor();
    }

    private static Color getPopupBorderColor() {
        Color shadow = UIManager.getColor("controlShadow");
        return shadow != null ? shadow : Color.GRAY;
    }

    protected void maybeShowPopup(MouseEvent evt) {
        if (evt != null && !SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        JPopupMenu pm = new JPopupMenu();
        for (Kenai kenai : KenaiManager.getDefault().getKenais()) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(SearchField.getKenaiDisplayName(kenai));
            item.setIcon(kenai.getIcon());
            item.setSelected(kenai == this.getSelectedKenai());
            item.putClientProperty(KENAI, kenai);
            item.addActionListener(this);
            pm.add(item);
        }
        JMenuItem item = new JMenuItem(NbBundle.getMessage(KenaiComboModel.class, (String)"CTL_AddNew"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddInstanceAction addInstanceAction = new AddInstanceAction();
                addInstanceAction.actionPerformed(e);
                Kenai last = addInstanceAction.getLastKenai();
                if (last != null) {
                    SearchField.this.selected = last;
                    SearchField.this.setTooltip();
                }
                SearchField.this.actionPerformed(e);
            }
        });
        pm.add(item);
        pm.show(this.panel, 0, this.panel.getHeight() - 1);
    }

    private void setTooltip() {
        this.leftIcon.setToolTipText(SearchField.getKenaiDisplayName(this.selected));
    }

    private static String getKenaiDisplayName(Kenai kenai) {
        if (kenai == null) {
            return "";
        }
        return "<html><b>" + kenai.getName() + "</b> (" + kenai.getUrl().getProtocol() + "://" + kenai.getUrl().getHost() + ")</html>";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        Object k = source.getClientProperty(KENAI);
        if (k != null) {
            this.selected = (Kenai)k;
            this.setTooltip();
            this.leftIcon.setIcon(this.selected.getIcon());
        }
        for (ActionListener l : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            l.actionPerformed(e);
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public Kenai getSelectedKenai() {
        return this.selected;
    }
}

