/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.ui.DeleteProjectAction;
import org.netbeans.modules.kenai.ui.NewKenaiProjectAction;
import org.netbeans.modules.kenai.ui.OpenKenaiProjectAction;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.RemoveProjectAction;
import org.netbeans.modules.kenai.ui.URLDisplayerAction;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.project.DetailsAction;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.LoginHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.mercurial.api.Mercurial;
import org.netbeans.modules.subversion.api.Subversion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class ProjectAccessorImpl
extends ProjectAccessor {
    @Override
    public List<ProjectHandle> getMemberProjects(Kenai kenai, LoginHandle login, boolean force) {
        try {
            LinkedList<ProjectHandle> l = new LinkedList<ProjectHandle>();
            for (KenaiProject prj : kenai.getMyProjects(force)) {
                l.add(new ProjectHandleImpl(prj));
                for (KenaiFeature feature : prj.getFeatures(KenaiService.Type.SOURCE)) {
                    if ("subversion".equals(feature.getService())) {
                        try {
                            Subversion.addRecentUrl((String)feature.getLocation());
                        }
                        catch (MalformedURLException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        continue;
                    }
                    if (!"mercurial".equals(feature.getService())) continue;
                    try {
                        Mercurial.addRecentUrl((String)feature.getLocation());
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return l;
        }
        catch (KenaiException ex) {
            Logger.getLogger(ProjectAccessorImpl.class.getName()).log(Level.INFO, "getMyProject() failed", ex);
            return null;
        }
    }

    @Override
    public ProjectHandle getNonMemberProject(Kenai kenai, String projectId, boolean force) {
        try {
            return new ProjectHandleImpl(kenai.getProject(projectId, force));
        }
        catch (KenaiException ex) {
            Logger.getLogger(ProjectAccessorImpl.class.getName()).log(Level.INFO, "getProject() " + projectId + " failed", ex);
            return null;
        }
    }

    @Override
    public Action getOpenNonMemberProjectAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OpenKenaiProjectAction(DashboardImpl.getInstance().getKenai()).actionPerformed(null);
            }
        };
    }

    @Override
    public Action getDetailsAction(ProjectHandle project) {
        return DetailsAction.forProject(project);
    }

    private Action getOpenAction(final ProjectHandle project) {
        return new AbstractAction(NbBundle.getMessage(ProjectAccessorImpl.class, (String)"CTL_OpenProject")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dashboard.getDefault().addProject(project, false, true);
            }
        };
    }

    @Override
    public Action getDefaultAction(ProjectHandle project, boolean opened) {
        return opened ? this.getDetailsAction(project) : this.getOpenAction(project);
    }

    @Override
    public Action[] getPopupActions(ProjectHandle project, boolean opened) {
        PasswordAuthentication pa = project.getKenaiProject().getKenai().getPasswordAuthentication();
        if (!opened) {
            try {
                if (pa != null && pa.getUserName().equals(project.getKenaiProject().getOwner().getUserName())) {
                    return new Action[]{this.getOpenAction(project), new RefreshAction(project), this.getDetailsAction(project), new DeleteProjectAction(project)};
                }
                return new Action[]{this.getOpenAction(project), new RefreshAction(project), this.getDetailsAction(project)};
            }
            catch (KenaiException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new Action[]{this.getOpenAction(project), new RefreshAction(project), this.getDetailsAction(project)};
            }
        }
        try {
            if (pa != null && pa.getUserName().equals(project.getKenaiProject().getOwner().getUserName())) {
                return new Action[]{new RemoveProjectAction(project), new RefreshAction(project), this.getDetailsAction(project), new DeleteProjectAction(project)};
            }
            return new Action[]{new RemoveProjectAction(project), new RefreshAction(project), this.getDetailsAction(project)};
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new Action[]{new RemoveProjectAction(project), new RefreshAction(project), this.getDetailsAction(project)};
        }
    }

    @Override
    public Action getOpenWikiAction(ProjectHandle project) {
        try {
            KenaiFeature[] wiki = ((ProjectHandleImpl)project).getKenaiProject().getFeatures(KenaiService.Type.WIKI);
            if (wiki.length == 1) {
                return new URLDisplayerAction(wiki[0].getDisplayName(), wiki[0].getWebLocation());
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        return null;
    }

    @Override
    public Action getOpenDownloadsAction(ProjectHandle project) {
        try {
            KenaiFeature[] wiki = ((ProjectHandleImpl)project).getKenaiProject().getFeatures(KenaiService.Type.DOWNLOADS);
            if (wiki.length == 1) {
                return new URLDisplayerAction(wiki[0].getDisplayName(), wiki[0].getWebLocation());
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        return null;
    }

    @Override
    public Action getBookmarkAction(final ProjectHandle project) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Kenai kenai = project.getKenaiProject().getKenai();
                try {
                    if (kenai.getStatus() == Kenai.Status.OFFLINE) {
                        UIUtils.showLogin(kenai);
                        return;
                    }
                    if (kenai.getMyProjects().contains(project.getKenaiProject()) && 0 != JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(ProjectAccessorImpl.class, (String)"LBL_ReallyLeave"), NbBundle.getMessage(ProjectAccessorImpl.class, (String)"LBL_ReallyLeaveTitle"), 0)) {
                        return;
                    }
                }
                catch (KenaiException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                DashboardImpl.getInstance().bookmarkingStarted();
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                KenaiProject prj = project.getKenaiProject();
                                if (prj.getKenai().getMyProjects().contains(prj)) {
                                    ProjectAccessorImpl.this.unbookmark(prj);
                                    break block5;
                                }
                                ProjectAccessorImpl.this.bookmark(prj);
                            }
                            catch (KenaiException ex) {
                                try {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                catch (Throwable throwable) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            DashboardImpl.getInstance().bookmarkingFinished();
                                        }
                                    });
                                    throw throwable;
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
            }
        };
    }

    private void unbookmark(KenaiProject prj) throws KenaiException {
        String fullName = prj.getKenai().getPasswordAuthentication().getUserName() + "@" + prj.getKenai().getUrl().getHost();
        KenaiUser user = KenaiUser.forName((String)fullName);
        prj.deleteMember(user);
    }

    private void bookmark(KenaiProject prj) throws KenaiException {
        String fullName = prj.getKenai().getPasswordAuthentication().getUserName() + "@" + prj.getKenai().getUrl().getHost();
        KenaiUser user = KenaiUser.forName((String)fullName);
        prj.addMember(user, KenaiProjectMember.Role.OBSERVER);
    }

    @Override
    public Action getNewKenaiProjectAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new NewKenaiProjectAction(DashboardImpl.getInstance().getKenai()).actionPerformed(null);
            }
        };
    }

    private static class RefreshAction
    extends AbstractAction {
        private final ProjectHandle project;

        public RefreshAction(ProjectHandle project) {
            super(NbBundle.getMessage(ProjectAccessorImpl.class, (String)"CTL_RefreshProject"));
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        RefreshAction.this.project.getKenaiProject().getKenai().getProject(RefreshAction.this.project.getId(), true);
                    }
                    catch (KenaiException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }
}

