/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import javax.swing.Icon;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ContactListItem;
import org.netbeans.modules.kenai.collab.chat.FakeRosterEntry;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;

public class UserListItem
implements ContactListItem {
    private FakeRosterEntry entry;

    public UserListItem(FakeRosterEntry entry) {
        this.entry = entry;
    }

    public String toString() {
        return this.entry.getUser();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserListItem other = (UserListItem)obj;
        return this.entry == other.entry || this.entry != null && this.entry.equals(other.entry);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.entry != null ? this.entry.hashCode() : 0);
        return hash;
    }

    @Override
    public void openChat() {
        KenaiUserUI user = new KenaiUserUI(this.entry.getJid());
        user.startChat();
    }

    @Override
    public Icon getIcon() {
        return new KenaiUserUI(this.entry.getJid()).getIcon();
    }

    @Override
    public boolean hasMessages() {
        return ChatNotifications.getDefault().hasNewPrivateMessages(this.entry.getJid());
    }

    @Override
    public String getKenaiName() {
        return KenaiConnection.getKenai(this.entry.getJid()).getName();
    }
}

