/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.Collections;
import java.util.Set;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstPath;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlGSFParser;
import org.openide.filesystems.FileObject;

public class HtmlElementHandle
implements ElementHandle {
    private AstNode node;
    private FileObject fo;

    HtmlElementHandle(AstNode node, FileObject fo) {
        this.node = node;
        this.fo = fo;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public String getMimeType() {
        return "text/html";
    }

    public String getName() {
        return this.node.name();
    }

    public String getIn() {
        return null;
    }

    public ElementKind getKind() {
        return ElementKind.TAG;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean signatureEquals(ElementHandle handle) {
        if (!(handle instanceof HtmlElementHandle)) {
            return false;
        }
        AstNode foreignNode = ((HtmlElementHandle)handle).node();
        if (this.node == foreignNode) {
            return true;
        }
        AstPath fnPath = foreignNode.path();
        AstPath path = this.node.path();
        return path.equals((Object)fnPath);
    }

    AstNode node() {
        return this.node;
    }

    public int from() {
        return this.node().getLogicalRange()[0];
    }

    public int to() {
        return this.node().getLogicalRange()[1];
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        ElementHandle object = HtmlGSFParser.resolveHandle(result, this);
        if (object instanceof HtmlElementHandle) {
            HtmlElementHandle heh = (HtmlElementHandle)object;
            return new OffsetRange(result.getSnapshot().getOriginalOffset(heh.from()), result.getSnapshot().getOriginalOffset(heh.to()));
        }
        throw new IllegalArgumentException("Foreign element: " + object + " of type " + (object != null ? object.getClass().getName() : "null"));
    }
}

