/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.ant;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import net.sourceforge.cobertura.util.StringUtil;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public abstract class CommonMatchingTask
extends MatchingTask {
    final String className;
    final List fileSets = new LinkedList();
    private Java java = null;
    private String maxMemory = null;
    private int forkedJVMDebugPort;

    public CommonMatchingTask(String className) {
        this.className = className;
    }

    private String getClassName() {
        return this.className;
    }

    protected Java getJava() {
        if (this.java == null) {
            this.java = (Java)this.getProject().createTask("java");
            this.java.setTaskName(this.getTaskName());
            this.java.setClassname(this.getClassName());
            this.java.setFork(true);
            this.java.setDir(this.getProject().getBaseDir());
            if (this.maxMemory != null) {
                this.java.setJvmargs("-Xmx" + this.maxMemory);
            }
            if (this.forkedJVMDebugPort > 0) {
                this.java.setJvmargs("-Xdebug");
                this.java.setJvmargs("-Xrunjdwp:transport=dt_socket,address=" + this.forkedJVMDebugPort + ",server=y,suspend=y");
            }
            if (((Object)((Object)this)).getClass().getClassLoader() instanceof AntClassLoader) {
                String classpath = ((AntClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getClasspath();
                this.createClasspath().setPath(StringUtil.replaceAll(classpath, "%20", " "));
            } else if (((Object)((Object)this)).getClass().getClassLoader() instanceof URLClassLoader) {
                URL[] earls = ((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getURLs();
                for (int i = 0; i < earls.length; ++i) {
                    String classpath = new File(earls[i].getFile()).getAbsolutePath();
                    this.createClasspath().setPath(StringUtil.replaceAll(classpath, "%20", " "));
                }
            }
        }
        return this.java;
    }

    protected void createArgumentsForFilesets(CommandLineBuilder builder) throws IOException {
        Iterator iter = this.fileSets.iterator();
        boolean filesetFound = false;
        while (iter.hasNext()) {
            AbstractFileSet fileSet = (AbstractFileSet)iter.next();
            if (fileSet instanceof FileSet) {
                filesetFound = true;
                builder.addArg("--basedir", this.baseDir(fileSet));
                this.createArgumentsForFilenames(builder, this.getFilenames(fileSet));
                continue;
            }
            if (filesetFound) {
                throw new BuildException("Dirsets have to come before filesets");
            }
            this.createArgumentsForFilenames(builder, this.getDirectoryScanner(fileSet).getIncludedDirectories());
        }
    }

    private void createArgumentsForFilenames(CommandLineBuilder builder, String[] filenames) throws IOException {
        for (int i = 0; i < filenames.length; ++i) {
            this.getProject().log("Adding " + filenames[i] + " to list", 3);
            builder.addArg(filenames[i]);
        }
    }

    public Path createClasspath() {
        return this.getJava().createClasspath().createPath();
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    DirectoryScanner getDirectoryScanner(AbstractFileSet fileSet) {
        return fileSet.getDirectoryScanner(this.getProject());
    }

    String[] getIncludedFiles(AbstractFileSet fileSet) {
        return this.getDirectoryScanner(fileSet).getIncludedFiles();
    }

    String[] getExcludedFiles(FileSet fileSet) {
        return this.getDirectoryScanner((AbstractFileSet)fileSet).getExcludedFiles();
    }

    String[] getFilenames(AbstractFileSet fileSet) {
        String[] filesToReturn = this.getIncludedFiles(fileSet);
        return filesToReturn;
    }

    String baseDir(AbstractFileSet fileSet) {
        return fileSet.getDirectoryScanner(this.getProject()).getBasedir().toString();
    }

    public void addDirSet(DirSet dirSet) {
        this.fileSets.add(dirSet);
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory != null ? maxMemory.trim() : null;
    }

    public void setForkedJVMDebugPort(int forkedJVMDebugPort) {
        this.forkedJVMDebugPort = forkedJVMDebugPort;
    }
}

