/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.DataImporter;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.j2ee.DBTableDrop;
import org.netbeans.modules.form.j2ee.J2EEUtils;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JPADataImporter
extends JPanel
implements DataImporter {
    private JComboBox connectionCombo;
    private JLabel connectionLabel;
    private JLabel importerLabel;
    private JComboBox tableCombo;
    private JLabel tableLabel;

    private void initComponents() {
        this.importerLabel = new JLabel();
        this.connectionLabel = new JLabel();
        this.tableLabel = new JLabel();
        this.tableCombo = new JComboBox();
        this.connectionCombo = new JComboBox();
        this.importerLabel.setText(NbBundle.getMessage(JPADataImporter.class, (String)"MSG_ImportData"));
        this.connectionLabel.setText(NbBundle.getMessage(JPADataImporter.class, (String)"LBL_ImportDBConnection"));
        this.tableLabel.setText(NbBundle.getMessage(JPADataImporter.class, (String)"LBL_ImportDBTable"));
        this.tableCombo.setEnabled(false);
        this.tableCombo.setRenderer(J2EEUtils.DBColumnInfo.getRenderer());
        this.connectionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPADataImporter.this.connectionComboActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.importerLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.connectionLabel).add((Component)this.tableLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.tableCombo, 0, 238, Short.MAX_VALUE).add((Component)this.connectionCombo, 0, 238, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.importerLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.connectionLabel).add((Component)this.connectionCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tableLabel).add((Component)this.tableCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void connectionComboActionPerformed(ActionEvent actionEvent) {
        Object object = this.connectionCombo.getSelectedItem();
        if (object instanceof DatabaseConnection) {
            DatabaseConnection databaseConnection = (DatabaseConnection)object;
            Connection connection = J2EEUtils.establishConnection(databaseConnection);
            if (connection == null) {
                return;
            }
            this.fillTableCombo(databaseConnection);
        } else assert (object == null);
    }

    private void fillTableCombo(DatabaseConnection databaseConnection) {
        DefaultComboBoxModel<J2EEUtils.DBColumnInfo> defaultComboBoxModel = new DefaultComboBoxModel<J2EEUtils.DBColumnInfo>();
        for (J2EEUtils.DBColumnInfo dBColumnInfo : J2EEUtils.tableNamesForConnection(databaseConnection)) {
            defaultComboBoxModel.addElement(dBColumnInfo);
        }
        this.tableCombo.setModel(defaultComboBoxModel);
        this.tableCombo.setEnabled(this.tableCombo.getModel().getSize() != 0);
        this.tableCombo.setSelectedItem(this.tableCombo.getSelectedItem());
    }

    public Future<RADComponent> importData(final FormModel formModel) {
        this.removeAll();
        if (FormJavaSource.isInDefaultPackage((FormModel)formModel)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"MSG_ImportToDefaultPackage")));
            return null;
        }
        this.initComponents();
        DatabaseExplorerUIs.connect((JComboBox)this.connectionCombo, (ConnectionManager)ConnectionManager.getDefault());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"TITLE_ImportData"), true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return null;
        }
        FutureTask<RADComponent> futureTask = new FutureTask<RADComponent>(new Callable<RADComponent>(){

            @Override
            public RADComponent call() throws Exception {
                final RADComponent[] rADComponentArray = new RADComponent[1];
                try {
                    J2EEUtils.DBColumnInfo dBColumnInfo = (J2EEUtils.DBColumnInfo)JPADataImporter.this.tableCombo.getSelectedItem();
                    if (dBColumnInfo == null || !dBColumnInfo.isValid()) {
                        return null;
                    }
                    String string = dBColumnInfo.getName();
                    DatabaseConnection databaseConnection = (DatabaseConnection)JPADataImporter.this.connectionCombo.getSelectedItem();
                    FileObject fileObject = FormEditor.getFormDataObject((FormModel)formModel).getFormFile();
                    Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                    FileObject fileObject2 = J2EEUtils.getPersistenceXML(project, true);
                    PersistenceUnit persistenceUnit = J2EEUtils.initPersistenceUnit(fileObject2, databaseConnection);
                    JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(databaseConnection.getDriverClass());
                    J2EEUtils.updateProjectForUnit(fileObject, persistenceUnit, jDBCDriverArray[0]);
                    PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)fileObject);
                    MetadataModel metadataModel = persistenceScope.getEntityMappingsModel(persistenceUnit.getName());
                    String[] stringArray = J2EEUtils.findEntity((MetadataModel<EntityMappingsMetadata>)metadataModel, string);
                    if (stringArray == null) {
                        J2EEUtils.createEntity(fileObject.getParent(), persistenceScope, persistenceUnit, databaseConnection, string, null);
                        metadataModel = persistenceScope.getEntityMappingsModel(persistenceUnit.getName());
                        stringArray = J2EEUtils.findEntity((MetadataModel<EntityMappingsMetadata>)metadataModel, string);
                    } else {
                        J2EEUtils.addEntityToUnit(stringArray[1], persistenceUnit, project);
                    }
                    J2EEUtils.makeEntityObservable(fileObject, stringArray, (MetadataModel<EntityMappingsMetadata>)metadataModel);
                    final String string2 = persistenceUnit.getName();
                    final String[] stringArray2 = stringArray;
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RADComponent rADComponent = J2EEUtils.findEntityManager(formModel, string2);
                                if (rADComponent == null) {
                                    rADComponent = J2EEUtils.createEntityManager(formModel, string2);
                                }
                                RADComponent rADComponent2 = DBTableDrop.createQueryBean(formModel, rADComponent, stringArray2[0]);
                                rADComponentArray[0] = DBTableDrop.createResultListBean(formModel, rADComponent2, stringArray2);
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
                return rADComponentArray[0];
            }
        });
        RequestProcessor.getDefault().post(futureTask);
        return futureTask;
    }
}

