/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.awt.Image;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

public class FileSystemNode
extends AbstractNode {
    private final ExecutionEnvironment env;
    private final FileObject fileObject;

    public FileSystemNode(ExecutionEnvironment env, FileObject fileObject) {
        super(FileSystemNode.createChildren(env, fileObject), Lookups.fixed((Object[])new Object[]{env, fileObject}));
        this.env = env;
        this.fileObject = fileObject;
    }

    private static Children createChildren(ExecutionEnvironment env, FileObject rootFileObject) {
        return Children.create((ChildFactory)new FileSystemChildren(env, rootFileObject), (boolean)true);
    }

    public String getDisplayName() {
        String path = this.fileObject.getPath();
        if (path == null || path.length() == 0) {
            return "/";
        }
        return path;
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/remote/ui/fs_open.gif");
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/remote/ui/fs.gif");
    }

    private static class FileSystemChildren
    extends ChildFactory<FileObject> {
        private final ExecutionEnvironment env;
        private final FileObject rootFileObject;

        public FileSystemChildren(ExecutionEnvironment env, FileObject rootFileObject) {
            this.env = env;
            this.rootFileObject = rootFileObject;
        }

        protected boolean createKeys(List<FileObject> toPopulate) {
            if (ConnectionManager.getInstance().isConnectedTo(this.env)) {
                FileObject[] children = this.rootFileObject.getChildren();
                Collections.addAll(toPopulate, children);
                return true;
            }
            toPopulate.add(this.rootFileObject);
            return true;
        }

        protected Node createNodeForKey(FileObject key) {
            try {
                DataObject dao = DataObject.find((FileObject)key);
                Node node = dao.getNodeDelegate();
                return node;
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

