/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ExpressionList;

abstract class BooleanExpressionList
implements ExpressionList {
    protected List _expressions;

    BooleanExpressionList() {
    }

    @Override
    public Expression findExpression(String table1, String column1, String table2, String column2) {
        if (this._expressions != null) {
            for (int index = 0; index < this._expressions.size(); ++index) {
                Expression cond = (Expression)this._expressions.get(index);
                if ((cond = cond.findExpression(table1, column1, table2, column2)) == null) continue;
                return cond;
            }
        }
        return null;
    }

    @Override
    public void getReferencedColumns(Collection comlumns) {
        if (this._expressions != null) {
            for (int index = 0; index < this._expressions.size(); ++index) {
                Expression expr = (Expression)this._expressions.get(index);
                expr.getReferencedColumns(comlumns);
            }
        }
    }

    @Override
    public int size() {
        if (this._expressions != null) {
            return this._expressions.size();
        }
        return 0;
    }

    @Override
    public Expression getExpression(int i) {
        return (Expression)this._expressions.get(i);
    }

    @Override
    public void addExpression(Expression expression) {
        this._expressions.add(expression);
    }

    @Override
    public void addExpression(int index, Expression expression) {
        this._expressions.add(index, expression);
    }

    @Override
    public void replaceExpression(int index, Expression expression) {
        this._expressions.remove(index);
        this._expressions.add(index, expression);
    }

    @Override
    public void removeExpression(int index) {
        this._expressions.remove(index);
    }

    @Override
    public void removeTable(String tableSpec) {
        int size = this._expressions.size();
        block0: for (int i = size - 1; i >= 0; --i) {
            Expression expr = (Expression)this._expressions.get(i);
            if (expr instanceof ExpressionList) {
                ExpressionList list = (ExpressionList)expr;
                list.removeTable(tableSpec);
                if (list.size() != 0) continue;
                this._expressions.remove(i);
                continue;
            }
            ArrayList column = new ArrayList();
            expr.getReferencedColumns(column);
            for (int j = 0; j < column.size(); ++j) {
                Column col = (Column)column.get(j);
                if (!col.matches(tableSpec)) continue;
                this._expressions.remove(i);
                continue block0;
            }
        }
    }

    @Override
    public boolean isParameterized() {
        if (this._expressions != null) {
            for (int index = 0; index < this._expressions.size(); ++index) {
                Expression expr = (Expression)this._expressions.get(index);
                if (!expr.isParameterized()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void renameTableSpec(String oldTableSpec, String corrName) {
        if (this._expressions != null) {
            for (int index = 0; index < this._expressions.size(); ++index) {
                Expression expr = (Expression)this._expressions.get(index);
                expr.renameTableSpec(oldTableSpec, corrName);
            }
        }
    }

    protected static void flattenExpression(List expressionsToFlatten, Class typeToLookFor, List expressions) {
        int size = expressionsToFlatten.size();
        for (int i = 0; i < size; ++i) {
            Object expr = expressionsToFlatten.get(i);
            if (expr.getClass() == typeToLookFor) {
                BooleanExpressionList.flattenExpression(((BooleanExpressionList)expr)._expressions, typeToLookFor, expressions);
                continue;
            }
            expressions.add(expr);
        }
    }
}

