/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jline.Terminal;

public class WindowsTerminal
extends Terminal {
    private static final int ENABLE_LINE_INPUT = 2;
    private static final int ENABLE_ECHO_INPUT = 4;
    private static final int ENABLE_PROCESSED_INPUT = 1;
    private static final int ENABLE_WINDOW_INPUT = 8;
    private static final int ENABLE_MOUSE_INPUT = 16;
    private static final int ENABLE_PROCESSED_OUTPUT = 1;
    private static final int ENABLE_WRAP_AT_EOL_OUTPUT = 2;
    public static final int SPECIAL_KEY_INDICATOR = 224;
    public static final int NUMPAD_KEY_INDICATOR = 0;
    public static final int LEFT_ARROW_KEY = 75;
    public static final int RIGHT_ARROW_KEY = 77;
    public static final int UP_ARROW_KEY = 72;
    public static final int DOWN_ARROW_KEY = 80;
    public static final int DELETE_KEY = 83;
    public static final int HOME_KEY = 71;
    public static final char END_KEY = 'O';
    public static final char PAGE_UP_KEY = 'I';
    public static final char PAGE_DOWN_KEY = 'Q';
    public static final char INSERT_KEY = 'R';
    public static final char ESCAPE_KEY = '\u0000';
    private Boolean directConsole;
    private boolean echoEnabled;

    public WindowsTerminal() {
        String dir = System.getProperty("jline.WindowsTerminal.directConsole");
        if ("true".equals(dir)) {
            this.directConsole = Boolean.TRUE;
        } else if ("false".equals(dir)) {
            this.directConsole = Boolean.FALSE;
        }
    }

    private native int getConsoleMode();

    private native void setConsoleMode(int var1);

    private native int readByte();

    private native int getWindowsTerminalWidth();

    private native int getWindowsTerminalHeight();

    public int readCharacter(InputStream in) throws IOException {
        if (this.directConsole == Boolean.FALSE) {
            return super.readCharacter(in);
        }
        if (this.directConsole == Boolean.TRUE || in == System.in || in instanceof FileInputStream && ((FileInputStream)in).getFD() == FileDescriptor.in) {
            return this.readByte();
        }
        return super.readCharacter(in);
    }

    public void initializeTerminal() throws Exception {
        this.loadLibrary("jline");
        final int originalMode = this.getConsoleMode();
        this.setConsoleMode(originalMode & 0xFFFFFFFB);
        int newMode = originalMode & 0xFFFFFFF0;
        this.echoEnabled = false;
        this.setConsoleMode(newMode);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void start() {
                    WindowsTerminal.this.setConsoleMode(originalMode);
                }
            });
        }
        catch (AbstractMethodError ame) {
            this.consumeException(ame);
        }
    }

    private void loadLibrary(String name2) throws IOException {
        File f;
        block5: {
            String version = this.getClass().getPackage().getImplementationVersion();
            if (version == null) {
                version = "";
            }
            version = version.replace('.', '_');
            f = new File(System.getProperty("java.io.tmpdir"), name2 + "_" + version + ".dll");
            boolean exists = f.isFile();
            int bits = 32;
            if (System.getProperty("os.arch").indexOf("64") != -1) {
                bits = 64;
            }
            BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(name2 + bits + ".dll"));
            try {
                BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(f));
                byte[] bytes2 = new byte[10240];
                int n = 0;
                while (n != -1) {
                    ((OutputStream)fout).write(bytes2, 0, n);
                    n = ((InputStream)in).read(bytes2);
                }
                ((OutputStream)fout).close();
            }
            catch (IOException ioe) {
                if (exists) break block5;
                throw ioe;
            }
        }
        f.deleteOnExit();
        System.load(f.getAbsolutePath());
    }

    public int readVirtualKey(InputStream in) throws IOException {
        int indicator = this.readCharacter(in);
        if (indicator == 224 || indicator == 0) {
            int key2 = this.readCharacter(in);
            switch (key2) {
                case 72: {
                    return 16;
                }
                case 75: {
                    return 2;
                }
                case 77: {
                    return 6;
                }
                case 80: {
                    return 14;
                }
                case 83: {
                    return 127;
                }
                case 71: {
                    return 1;
                }
                case 79: {
                    return 5;
                }
                case 73: {
                    return 11;
                }
                case 81: {
                    return 12;
                }
                case 0: {
                    return 27;
                }
                case 82: {
                    return 3;
                }
            }
            return 0;
        }
        return indicator;
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isANSISupported() {
        return false;
    }

    public boolean getEcho() {
        return false;
    }

    public int getTerminalWidth() {
        return this.getWindowsTerminalWidth();
    }

    public int getTerminalHeight() {
        return this.getWindowsTerminalHeight();
    }

    private void consumeException(Throwable e) {
    }

    public void setDirectConsole(Boolean directConsole) {
        this.directConsole = directConsole;
    }

    public Boolean getDirectConsole() {
        return this.directConsole;
    }

    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void enableEcho() {
        this.setConsoleMode(this.getConsoleMode() | 4 | 2 | 1 | 8);
        this.echoEnabled = true;
    }

    public synchronized void disableEcho() {
        this.setConsoleMode(this.getConsoleMode() & 0xFFFFFFF0);
        this.echoEnabled = true;
    }

    public InputStream getDefaultBindings() {
        return this.getClass().getResourceAsStream("windowsbindings.properties");
    }
}

