/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.openide.util.NbBundle;

class RailsInstallationValidator {
    private static final String RAILS_GEM_NAME = "rails";
    private static final String RAILS_COMMAND_NAME = "rails";

    RailsInstallationValidator() {
    }

    static RailsInstallationInfo getRailsInstallation(RubyPlatform platform) {
        GemManager gemManager = platform.getGemManager();
        if (gemManager == null) {
            return new RailsInstallationInfo(null, false, NbBundle.getMessage(RailsInstallationValidator.class, (String)"GemProblem"));
        }
        if (!platform.isValid(false)) {
            return new RailsInstallationInfo(null, false, NbBundle.getMessage(RailsInstallationValidator.class, (String)"NoRuby"));
        }
        boolean valid = false;
        String message = null;
        String version = gemManager.getLatestVersion("rails");
        if (version == null) {
            message = NbBundle.getMessage(RailsInstallationValidator.class, (String)"NoRails");
        } else {
            valid = platform.getRails() != null;
            message = valid ? NbBundle.getMessage(RailsInstallationValidator.class, (String)"RailsOk") : NbBundle.getMessage(RailsInstallationValidator.class, (String)"NotFound", (Object)"rails");
        }
        return new RailsInstallationInfo(version, valid, message);
    }

    static class RailsInstallationInfo {
        private final String version;
        private final boolean valid;
        private final String message;

        public RailsInstallationInfo(String version, boolean valid, String message) {
            if (valid && version == null) {
                throw new IllegalArgumentException("A valid Rails installation must have a version");
            }
            this.version = version;
            this.valid = valid;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

