/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.java.editor.semantic.SemanticHighlighter;
import org.netbeans.spi.editor.highlighting.HighlightAttributeValue;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class UnusedTooltipResolver
implements HighlightAttributeValue<String> {
    UnusedTooltipResolver() {
    }

    public String getValue(JTextComponent jTextComponent, Document document, Object object, int n, final int n2) {
        try {
            JavaSource javaSource = JavaSource.forDocument((Document)document);
            if (javaSource == null) {
                return null;
            }
            final String[] stringArray = new String[1];
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    Object object;
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = compilationController.getTreeUtilities().pathFor(n2);
                    if (treePath == null) {
                        return;
                    }
                    boolean bl = false;
                    block15: for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
                        object = treePath2.getLeaf();
                        switch (object.getKind()) {
                            case IMPORT: {
                                bl = true;
                                break block15;
                            }
                            case CLASS: 
                            case METHOD: 
                            case BLOCK: {
                                bl = false;
                                break block15;
                            }
                            default: {
                                continue block15;
                            }
                        }
                    }
                    if (bl) {
                        stringArray[0] = NbBundle.getMessage(SemanticHighlighter.class, (String)"LBL_UnusedImport");
                        return;
                    }
                    object = compilationController.getTrees().getElement(treePath);
                    if (object == null) {
                        return;
                    }
                    String string = null;
                    String string2 = null;
                    switch (object.getKind()) {
                        case LOCAL_VARIABLE: 
                        case EXCEPTION_PARAMETER: {
                            string2 = "LBL_UnusedVariable";
                            string = object.getSimpleName().toString();
                            break;
                        }
                        case PARAMETER: {
                            string2 = "LBL_UnusedParameter";
                            string = object.getSimpleName().toString();
                            break;
                        }
                        case FIELD: {
                            string2 = "LBL_UnusedField";
                            string = object.getSimpleName().toString();
                            break;
                        }
                        case METHOD: {
                            string2 = "LBL_UnusedMethod";
                            string = ElementHeaders.getHeader((Element)object, (CompilationInfo)compilationController, (String)"%name%%parameters%");
                            break;
                        }
                        case CONSTRUCTOR: {
                            string2 = "LBL_UnusedConstructor";
                            string = object.getEnclosingElement().getSimpleName().toString() + ElementHeaders.getHeader((Element)object, (CompilationInfo)compilationController, (String)"%parameters%");
                            break;
                        }
                        case CLASS: {
                            string2 = "LBL_UnusedClass";
                            string = object.getSimpleName().toString();
                            break;
                        }
                        case INTERFACE: {
                            string2 = "LBL_UnusedInterface";
                            string = object.getSimpleName().toString();
                            break;
                        }
                        case ANNOTATION_TYPE: {
                            string2 = "LBL_UnusedAnnotationType";
                            string = object.getSimpleName().toString();
                            break;
                        }
                        case ENUM: {
                            string2 = "LBL_UnusedEnum";
                            string = object.getSimpleName().toString();
                        }
                    }
                    if (string != null) {
                        stringArray[0] = NbBundle.getMessage(UnusedTooltipResolver.class, (String)string2, (Object)string);
                    }
                }
            }, true);
            return stringArray[0];
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }
}

