/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import com.sun.source.tree.CompilationUnitTree;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenVisitor;
import org.openide.util.Utilities;

public class ComputeOverriding {
    static final Logger LOG = Logger.getLogger(ComputeOverriding.class.getName());
    private final AtomicBoolean cancel;
    private static final Map<Reference<Elements>, DataHolder> CACHE = new HashMap<Reference<Elements>, DataHolder>();

    public ComputeOverriding(AtomicBoolean atomicBoolean) {
        this.cancel = atomicBoolean;
    }

    public static AnnotationType detectOverrides(CompilationInfo compilationInfo, TypeElement typeElement, ExecutableElement executableElement, List<ElementDescription> list) {
        Map<ElementHandle<ExecutableElement>, List<ElementDescription>> map = ComputeOverriding.compute(compilationInfo, (ElementHandle<TypeElement>)ElementHandle.create((Element)typeElement), new AtomicBoolean());
        List<ElementDescription> list2 = map.get(ElementHandle.create((Element)executableElement));
        if (list2 != null) {
            list.addAll(list2);
        }
        if (!list.isEmpty()) {
            for (ElementDescription elementDescription : list) {
                if (elementDescription.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                return AnnotationType.OVERRIDES;
            }
            return AnnotationType.IMPLEMENTS;
        }
        return null;
    }

    public Map<ElementHandle<? extends Element>, List<ElementDescription>> process(CompilationInfo compilationInfo) {
        IsOverriddenVisitor isOverriddenVisitor = new IsOverriddenVisitor(compilationInfo, this.cancel);
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        long l = System.currentTimeMillis();
        isOverriddenVisitor.scan(compilationUnitTree, null);
        long l2 = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Overridden Scanner", new Object[]{compilationInfo.getFileObject(), l2 - l});
        HashMap<ElementHandle<? extends Element>, List<ElementDescription>> hashMap = new HashMap<ElementHandle<? extends Element>, List<ElementDescription>>();
        for (ElementHandle<TypeElement> elementHandle : isOverriddenVisitor.type2Declaration.keySet()) {
            if (this.isCanceled()) {
                return null;
            }
            Map<ElementHandle<ExecutableElement>, List<ElementDescription>> map = ComputeOverriding.compute(compilationInfo, elementHandle, this.cancel);
            if (map == null) continue;
            hashMap.putAll(map);
        }
        if (this.isCanceled()) {
            return null;
        }
        return hashMap;
    }

    private synchronized boolean isCanceled() {
        return this.cancel.get();
    }

    private static void sortOutMethods(CompilationInfo compilationInfo, Map<Name, List<ExecutableElement>> map, Element element, boolean bl) {
        if (bl) {
            List<ExecutableElement> list;
            HashMap hashMap = new HashMap();
            block0: for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
                ArrayList<ExecutableElement> arrayList;
                list = executableElement.getSimpleName();
                List<ExecutableElement> list2 = map.get(list);
                if (list2 != null) {
                    arrayList = list2.iterator();
                    while (arrayList.hasNext()) {
                        ExecutableElement executableElement2 = (ExecutableElement)arrayList.next();
                        if (!compilationInfo.getElements().overrides(executableElement2, executableElement, (TypeElement)executableElement2.getEnclosingElement())) continue;
                        continue block0;
                    }
                }
                if ((arrayList = (List)hashMap.get(list)) == null) {
                    arrayList = new ArrayList<ExecutableElement>();
                    hashMap.put(list, arrayList);
                }
                arrayList.add(executableElement);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                list = map.get(entry.getKey());
                if (list == null) {
                    map.put((Name)entry.getKey(), (List<ExecutableElement>)entry.getValue());
                    continue;
                }
                list.addAll((Collection)entry.getValue());
            }
        }
        for (TypeMirror typeMirror : compilationInfo.getTypes().directSupertypes(element.asType())) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            ComputeOverriding.sortOutMethods(compilationInfo, map, ((DeclaredType)typeMirror).asElement(), true);
        }
    }

    private static Map<ElementHandle<ExecutableElement>, List<ElementDescription>> compute(CompilationInfo compilationInfo, ElementHandle<TypeElement> elementHandle, AtomicBoolean atomicBoolean) {
        DataHolder dataHolder = ComputeOverriding.getDataFromCache(compilationInfo);
        HashMap<ElementHandle<ExecutableElement>, List<ElementDescription>> hashMap = (HashMap<ElementHandle<ExecutableElement>, List<ElementDescription>>)dataHolder.data.get(elementHandle);
        if (hashMap == null) {
            hashMap = new HashMap<ElementHandle<ExecutableElement>, List<ElementDescription>>();
            dataHolder.data.put(elementHandle, hashMap);
            if (atomicBoolean.get()) {
                return null;
            }
            LOG.log(Level.FINE, "type: {0}", elementHandle.getQualifiedName());
            HashMap<Name, List<ExecutableElement>> hashMap2 = new HashMap<Name, List<ExecutableElement>>();
            TypeElement typeElement = (TypeElement)elementHandle.resolve(compilationInfo);
            if (typeElement == null) {
                return hashMap;
            }
            ComputeOverriding.sortOutMethods(compilationInfo, hashMap2, typeElement, false);
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                List list;
                if (atomicBoolean.get()) {
                    return null;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "method: {0}", executableElement.toString());
                }
                if ((list = (List)hashMap2.get(executableElement.getSimpleName())) == null || list.isEmpty()) continue;
                HashSet<ExecutableElement> hashSet = new HashSet<ExecutableElement>();
                LinkedList<ElementDescription> linkedList = new LinkedList<ElementDescription>();
                for (ExecutableElement executableElement2 : list) {
                    if (!compilationInfo.getElements().overrides(executableElement, executableElement2, SourceUtils.getEnclosingTypeElement((Element)executableElement)) || !hashSet.add(executableElement2)) continue;
                    linkedList.add(new ElementDescription(compilationInfo, executableElement2, false));
                }
                if (linkedList.isEmpty()) continue;
                hashMap.put((ElementHandle<ExecutableElement>)ElementHandle.create((Element)executableElement), linkedList);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataHolder getDataFromCache(CompilationInfo compilationInfo) {
        Elements elements = compilationInfo.getElements();
        Map<Reference<Elements>, DataHolder> map = CACHE;
        synchronized (map) {
            Object object = CACHE.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<Reference<Elements>, DataHolder> entry = object.next();
                if (entry.getKey().get() == elements) {
                    return entry.getValue();
                }
                object.remove();
            }
            object = new DataHolder();
            CACHE.put(new CleaningWR(compilationInfo.getElements()), new DataHolder());
            return object;
        }
    }

    private static final class CleaningWR
    extends WeakReference<Elements>
    implements Runnable {
        public CleaningWR(Elements elements) {
            super(elements, Utilities.activeReferenceQueue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = CACHE;
            synchronized (map) {
                CACHE.remove(this);
            }
        }
    }

    private static final class DataHolder {
        private final Map<ElementHandle<TypeElement>, Map<ElementHandle<ExecutableElement>, List<ElementDescription>>> data = new HashMap<ElementHandle<TypeElement>, Map<ElementHandle<ExecutableElement>, List<ElementDescription>>>();
    }
}

