/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateResults;
import org.netbeans.modules.versioning.util.VersioningOutputManager;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class UpdateExecutor
extends ExecutorSupport {
    private Set<File> refreshedFiles = Collections.synchronizedSet(new HashSet());
    private boolean rwUpdate;
    private boolean mergeUpdate;
    private final String contextDisplayName;
    private long updateStartTimestamp;

    public static UpdateExecutor[] splitCommand(UpdateCommand cmd, CvsVersioningSystem cvs, GlobalOptions options, String contextDisplayName) {
        Command[] cmds = new Command[]{};
        if (cmd.getDisplayName() == null) {
            cmd.setDisplayName(NbBundle.getMessage(UpdateExecutor.class, (String)"MSG_UpdateExecutor_CmdDisplayName"));
        }
        try {
            cmds = UpdateExecutor.prepareBasicCommand((BasicCommand)cmd);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        UpdateExecutor[] executors = new UpdateExecutor[cmds.length];
        for (int i = 0; i < cmds.length; ++i) {
            Command command = cmds[i];
            executors[i] = new UpdateExecutor(cvs, (UpdateCommand)command, options, contextDisplayName);
        }
        return executors;
    }

    private UpdateExecutor(CvsVersioningSystem cvs, UpdateCommand cmd, GlobalOptions options, String contextDisplayName) {
        super(cvs, (Command)cmd, options);
        this.contextDisplayName = contextDisplayName;
        this.rwUpdate = options == null || !options.isDoNoChanges();
        this.mergeUpdate = cmd.getMergeRevision1() != null;
    }

    @Override
    protected void setup() {
        super.setup();
        this.updateStartTimestamp = System.currentTimeMillis();
    }

    @Override
    public void fileInfoGenerated(FileInfoEvent e) {
        super.fileInfoGenerated(e);
    }

    @Override
    protected void commandFinished(ClientRuntime.Result result) {
        UpdateCommand ucmd = (UpdateCommand)this.cmd;
        if (ucmd.getGlobalOptions() == null) {
            if (!this.cmd.hasFailed()) {
                Logger.getLogger("org.netbeans.modules.versioning.system.cvss").log(Level.INFO, "Warning: Update command did not fail but global options are null.");
            }
            return;
        }
        this.cvs.setParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING, Boolean.TRUE);
        File[] files = ucmd.getFiles();
        for (int i = 0; i < files.length; ++i) {
            this.cache.clearVirtualDirectoryContents(files[i], ucmd.isRecursive(), ucmd.getGlobalOptions().getExclusions());
        }
        if (this.rwUpdate && this.contextDisplayName != null) {
            this.openOutputResults();
        }
        HashSet filesystems = new HashSet(2);
        boolean hasConflict = false;
        for (DefaultFileInfoContainer info : this.toRefresh) {
            File file = info.getFile();
            if (this.refreshedFiles.contains(file)) continue;
            int c = info.getType().charAt(0);
            if (c == 80) {
                c = 85;
            }
            if (this.rwUpdate) {
                if (c == 85) {
                    c = this.mergeUpdate ? 77 : 65536;
                }
                if (c == 71) {
                    c = 77;
                }
                if (c == 67) {
                    hasConflict = true;
                }
            }
            this.cache.refreshNow(file, c, true);
            this.refreshedFiles.add(file);
        }
        for (int i = 0; i < files.length; ++i) {
            if (ucmd.isRecursive()) {
                this.refreshRecursively(files[i]);
            } else {
                this.refreshFlat(files[i]);
            }
            if (!files[i].isFile()) continue;
            this.cache.refreshCached(files[i].getParentFile(), 0);
        }
        this.cvs.setParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING, null);
        if (hasConflict) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(UpdateExecutor.class, (String)"MSG_UpdateGeneratedConflicts_Prompt"), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            });
        }
        if (ucmd.getUpdateByRevision() != null || ucmd.isResetStickyOnes()) {
            CvsVersioningSystem.getInstance().refreshAllAnnotations();
        }
    }

    private void openOutputResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateResults results = new UpdateResults(UpdateExecutor.this.toRefresh, UpdateExecutor.this.cmd.getGlobalOptions().getCVSRoot(), UpdateExecutor.this.contextDisplayName);
                VersioningOutputManager vom = VersioningOutputManager.getInstance();
                vom.addComponent(UpdateExecutor.this.cmd.getGlobalOptions().getCVSRoot() + "-UpdateExecutor", (JComponent)results);
            }
        });
    }

    private void refreshRecursively(File file) {
        try {
            if (this.cvs.isIgnoredFilename(file)) {
                return;
            }
            if (this.cmd.getGlobalOptions().isExcluded(file)) {
                return;
            }
            if (file.isDirectory()) {
                if (this.cache.getStatus(file).getStatus() == 2) {
                    return;
                }
                File[] files = file.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        this.refreshRecursively(files[i]);
                    }
                }
                if (!this.refreshedFiles.contains(file)) {
                    this.cache.refreshCached(file, 0);
                }
            } else if (!this.refreshedFiles.contains(file)) {
                this.refreshFile(file);
            }
        }
        catch (Throwable e) {
            ErrorManager.getDefault().notify(e);
        }
    }

    private void refreshFlat(File file) {
        if (this.cvs.isIgnoredFilename(file)) {
            return;
        }
        if (this.cmd.getGlobalOptions().isExcluded(file)) {
            return;
        }
        if (this.refreshedFiles.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (this.cvs.isIgnoredFilename(files[i])) {
                        return;
                    }
                    if (this.refreshedFiles.contains(files[i])) {
                        return;
                    }
                    if (files[i].isDirectory()) continue;
                    this.refreshFile(files[i]);
                }
            }
            this.cache.refreshCached(file, 0);
        } else {
            this.refreshFile(file);
        }
    }

    private void refreshFile(File file) {
        long lastModified = file.lastModified();
        if (!this.cmd.hasFailed() && this.cache.getStatus(file.getParentFile()).getStatus() == 8 && lastModified > 0L && lastModified < this.updateStartTimestamp) {
            this.cache.refreshCached(file, 65536);
        } else {
            this.cache.refreshCached(file, 0);
        }
    }
}

