/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class DeleteLocalAction
extends AbstractSystemAction {
    public static final int LOCALLY_DELETABLE_MASK = 4100;

    @Override
    public void performCvsAction(Node[] nodes) {
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Prompt"));
        descriptor.setTitle(NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Title"));
        descriptor.setMessageType(2);
        descriptor.setOptionType(0);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (res != NotifyDescriptor.YES_OPTION) {
            return;
        }
        final File[] files = this.getContext(nodes).getFiles();
        CvsVersioningSystem.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                DeleteLocalAction.this.async(files);
            }
        });
    }

    @Override
    protected int getFileEnabledStatus() {
        return 4100;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "Delete";
    }

    protected boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void async(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            StandardAdminHandler entries = new StandardAdminHandler();
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            FileLock lock = null;
            try {
                lock = fo.lock();
                entries.removeEntry(file);
                fo.delete(lock);
                continue;
            }
            catch (IOException e) {
                ErrorManager err = ErrorManager.getDefault();
                err.annotate((Throwable)e, NbBundle.getMessage(DeleteLocalAction.class, (String)"BK0001", (Object)file.getAbsolutePath()));
                err.notify((Throwable)e);
                continue;
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }
}

