/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.api.customization.model.EnableAsyncMapping;
import org.netbeans.modules.websvc.api.customization.model.EnableMIMEContent;
import org.netbeans.modules.websvc.api.customization.model.EnableWrapperStyle;
import org.netbeans.modules.websvc.api.customization.model.JavaPackage;
import org.netbeans.modules.websvc.customization.multiview.JavaUtilities;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class DefinitionsPanel
extends SaveableSectionInnerPanel {
    private Definitions definitions;
    private WSDLModel model;
    private Node node;
    private boolean wsdlDirty;
    private DefinitionsActionListener listener;
    private DefaultItemListener defaultListener;
    private JCheckBox defaultPackageCB;
    private ButtonGroup eamButtonGroup;
    private ButtonGroup emcButtonGroup;
    private JCheckBox enableAsyncMappingCB;
    private JCheckBox enableMIMEContentCB;
    private JCheckBox enableWrapperStyleCB;
    private ButtonGroup ewsButtonGroup;
    private JLabel packageLabel;
    private JTextField packageNameText;

    public DefinitionsPanel(SectionView sectionView, Definitions definitions, Node node) {
        super(sectionView);
        this.definitions = definitions;
        this.model = this.definitions.getModel();
        this.node = node;
        this.initComponents();
        this.disableEnterKey();
        if (!this.isClient(node)) {
            this.enableAsyncMappingCB.setVisible(false);
        }
        this.enableAsyncMappingCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_ASYNC"));
        this.enableWrapperStyleCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_WRAPPER"));
        this.enableMIMEContentCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_MIME"));
        this.packageNameText.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_PACKAGE"));
        this.wsdlDirty = false;
        this.sync();
        this.defaultListener = new DefaultItemListener();
        ItemListener itemListener = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.defaultListener, (Object)this.defaultPackageCB);
        this.defaultPackageCB.addItemListener(itemListener);
        this.addValidatee(this.packageNameText);
        this.listener = new DefinitionsActionListener();
        this.addModifier(this.packageNameText);
        this.addModifier(this.defaultPackageCB);
        ActionListener actionListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableAsyncMappingCB);
        this.enableAsyncMappingCB.addActionListener(actionListener);
        ActionListener actionListener2 = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableMIMEContentCB);
        this.enableMIMEContentCB.addActionListener(actionListener2);
        ActionListener actionListener3 = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableWrapperStyleCB);
        this.enableWrapperStyleCB.addActionListener(actionListener3);
    }

    private void sync() {
        List list = this.definitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (list.size() == 1) {
            DefinitionsCustomization definitionsCustomization = (DefinitionsCustomization)list.get(0);
            EnableAsyncMapping enableAsyncMapping = definitionsCustomization.getEnableAsyncMapping();
            if (enableAsyncMapping != null) {
                this.setEnableAsyncMapping(enableAsyncMapping.isEnabled());
            } else {
                this.setEnableAsyncMapping(false);
            }
            EnableWrapperStyle enableWrapperStyle = definitionsCustomization.getEnableWrapperStyle();
            if (enableWrapperStyle != null) {
                this.setEnableWrapperStyle(enableWrapperStyle.isEnabled());
            } else {
                this.setEnableWrapperStyle(true);
            }
            EnableMIMEContent enableMIMEContent = definitionsCustomization.getEnableMIMEContent();
            if (enableMIMEContent != null) {
                this.setEnableMIMEContent(enableMIMEContent.isEnabled());
            } else {
                this.setEnableMIMEContent(false);
            }
            JavaPackage javaPackage = definitionsCustomization.getPackage();
            if (javaPackage != null) {
                this.setPackageName(javaPackage.getName());
            } else {
                this.setPackageName(null);
            }
        } else {
            this.setEnableAsyncMapping(false);
            this.setEnableWrapperStyle(true);
            this.setEnableMIMEContent(false);
            this.setPackageName(null);
        }
    }

    public void setEnableAsyncMapping(boolean bl) {
        this.enableAsyncMappingCB.setSelected(bl);
    }

    public boolean getEnableAsyncMapping() {
        return this.enableAsyncMappingCB.isSelected();
    }

    public void setEnableWrapperStyle(boolean bl) {
        this.enableWrapperStyleCB.setSelected(bl);
    }

    public boolean getEnableWrapperStyle() {
        return this.enableWrapperStyleCB.isSelected();
    }

    public void setEnableMIMEContent(boolean bl) {
        this.enableMIMEContentCB.setSelected(bl);
    }

    public boolean getEnableMIMEContent() {
        return this.enableMIMEContentCB.isSelected();
    }

    public void setPackageName(String string) {
        if (string == null) {
            this.packageNameText.setText("");
            this.defaultPackageCB.setSelected(true);
            this.packageNameText.setEnabled(false);
        } else {
            this.packageNameText.setEnabled(true);
            this.packageNameText.setText(string);
            this.defaultPackageCB.setSelected(false);
        }
    }

    public String getPackageName() {
        if (this.defaultPackageCB.isSelected()) {
            return null;
        }
        String string = this.packageNameText.getText().trim();
        if (string.length() > 0) {
            return string;
        }
        return null;
    }

    public JComponent getErrorComponent(String string) {
        return new JButton();
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List list = this.definitions.getExtensibilityElements(DefinitionsCustomization.class);
        CustomizationComponentFactory customizationComponentFactory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.packageNameText || jComponent == this.defaultPackageCB) {
            if (this.getPackageName() == null) {
                DefinitionsCustomization definitionsCustomization;
                JavaPackage javaPackage;
                if (list.size() == 1 && (javaPackage = (definitionsCustomization = (DefinitionsCustomization)list.get(0)).getPackage()) != null) {
                    try {
                        this.model.startTransaction();
                        definitionsCustomization.removePackage(javaPackage);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else if (list.size() == 1) {
                DefinitionsCustomization definitionsCustomization = (DefinitionsCustomization)list.get(0);
                JavaPackage javaPackage = definitionsCustomization.getPackage();
                if (javaPackage == null) {
                    try {
                        this.model.startTransaction();
                        javaPackage = customizationComponentFactory.createJavaPackage(this.model);
                        javaPackage.setName(this.packageNameText.getText());
                        definitionsCustomization.setPackage(javaPackage);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        javaPackage.setName(this.packageNameText.getText());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                DefinitionsCustomization definitionsCustomization = customizationComponentFactory.createDefinitionsCustomization(this.model);
                JavaPackage javaPackage = customizationComponentFactory.createJavaPackage(this.model);
                try {
                    this.model.startTransaction();
                    javaPackage.setName(this.packageNameText.getText());
                    definitionsCustomization.setPackage(javaPackage);
                    this.definitions.addExtensibilityElement((ExtensibilityElement)definitionsCustomization);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        } else if (jComponent == this.enableWrapperStyleCB) {
            if (list.size() == 1) {
                DefinitionsCustomization definitionsCustomization = (DefinitionsCustomization)list.get(0);
                EnableWrapperStyle enableWrapperStyle = definitionsCustomization.getEnableWrapperStyle();
                if (enableWrapperStyle == null) {
                    try {
                        this.model.startTransaction();
                        enableWrapperStyle = customizationComponentFactory.createEnableWrapperStyle(this.model);
                        enableWrapperStyle.setEnabled(this.getEnableWrapperStyle());
                        definitionsCustomization.setEnableWrapperStyle(enableWrapperStyle);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        enableWrapperStyle.setEnabled(this.getEnableWrapperStyle());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                DefinitionsCustomization definitionsCustomization = customizationComponentFactory.createDefinitionsCustomization(this.model);
                EnableWrapperStyle enableWrapperStyle = customizationComponentFactory.createEnableWrapperStyle(this.model);
                try {
                    this.model.startTransaction();
                    enableWrapperStyle.setEnabled(this.getEnableWrapperStyle());
                    definitionsCustomization.setEnableWrapperStyle(enableWrapperStyle);
                    this.definitions.addExtensibilityElement((ExtensibilityElement)definitionsCustomization);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        } else if (jComponent == this.enableAsyncMappingCB) {
            if (list.size() == 1) {
                DefinitionsCustomization definitionsCustomization = (DefinitionsCustomization)list.get(0);
                EnableAsyncMapping enableAsyncMapping = definitionsCustomization.getEnableAsyncMapping();
                if (enableAsyncMapping == null) {
                    try {
                        this.model.startTransaction();
                        enableAsyncMapping = customizationComponentFactory.createEnableAsyncMapping(this.model);
                        enableAsyncMapping.setEnabled(this.getEnableAsyncMapping());
                        definitionsCustomization.setEnableAsyncMapping(enableAsyncMapping);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        enableAsyncMapping.setEnabled(this.getEnableAsyncMapping());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                DefinitionsCustomization definitionsCustomization = customizationComponentFactory.createDefinitionsCustomization(this.model);
                EnableAsyncMapping enableAsyncMapping = customizationComponentFactory.createEnableAsyncMapping(this.model);
                try {
                    this.model.startTransaction();
                    enableAsyncMapping.setEnabled(this.getEnableAsyncMapping());
                    definitionsCustomization.setEnableAsyncMapping(enableAsyncMapping);
                    this.definitions.addExtensibilityElement((ExtensibilityElement)definitionsCustomization);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        } else if (jComponent == this.enableMIMEContentCB) {
            if (list.size() == 1) {
                DefinitionsCustomization definitionsCustomization = (DefinitionsCustomization)list.get(0);
                EnableMIMEContent enableMIMEContent = definitionsCustomization.getEnableMIMEContent();
                if (enableMIMEContent == null) {
                    try {
                        this.model.startTransaction();
                        enableMIMEContent = customizationComponentFactory.createEnableMIMEContent(this.model);
                        enableMIMEContent.setEnabled(this.getEnableMIMEContent());
                        definitionsCustomization.setEnableMIMEContent(enableMIMEContent);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        enableMIMEContent.setEnabled(this.getEnableMIMEContent());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                DefinitionsCustomization definitionsCustomization = customizationComponentFactory.createDefinitionsCustomization(this.model);
                EnableMIMEContent enableMIMEContent = customizationComponentFactory.createEnableMIMEContent(this.model);
                try {
                    this.model.startTransaction();
                    enableMIMEContent.setEnabled(this.getEnableMIMEContent());
                    definitionsCustomization.setEnableMIMEContent(enableMIMEContent);
                    this.definitions.addExtensibilityElement((ExtensibilityElement)definitionsCustomization);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        if (jTextComponent == this.packageNameText && !JavaUtilities.isValidPackageName(string)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, string, (JComponent)jTextComponent));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.ewsButtonGroup = new ButtonGroup();
        this.eamButtonGroup = new ButtonGroup();
        this.emcButtonGroup = new ButtonGroup();
        this.packageLabel = new JLabel();
        this.packageNameText = new JTextField();
        this.enableWrapperStyleCB = new JCheckBox();
        this.enableAsyncMappingCB = new JCheckBox();
        this.enableMIMEContentCB = new JCheckBox();
        this.defaultPackageCB = new JCheckBox();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.packageLabel.setText(resourceBundle.getString("LBL_PACKAGE_NAME"));
        this.enableWrapperStyleCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_WRAPPER_STYLE").charAt(0));
        this.enableWrapperStyleCB.setText(resourceBundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableWrapperStyleCB.setContentAreaFilled(false);
        this.enableWrapperStyleCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableAsyncMappingCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_ASYNC_CLIENT").charAt(0));
        this.enableAsyncMappingCB.setText(resourceBundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.setActionCommand(resourceBundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableAsyncMappingCB.setContentAreaFilled(false);
        this.enableAsyncMappingCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableMIMEContentCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_MIME_CONTENT").charAt(0));
        this.enableMIMEContentCB.setText(resourceBundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setActionCommand(resourceBundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableMIMEContentCB.setContentAreaFilled(false);
        this.enableMIMEContentCB.setMargin(new Insets(0, 0, 0, 0));
        this.defaultPackageCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultPackageCB.setText(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultPackageCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultPackageCB.setContentAreaFilled(false);
        this.defaultPackageCB.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.packageLabel).addPreferredGap(0).add((Component)this.packageNameText, -2, 173, -2).add(26, 26, 26).add((Component)this.defaultPackageCB)).add((Component)this.enableWrapperStyleCB).add((Component)this.enableMIMEContentCB).add((Component)this.enableAsyncMappingCB)).addContainerGap(80, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.packageLabel).add((Component)this.packageNameText, -2, 15, -2).add((Component)this.defaultPackageCB)).add(20, 20, 20).add((Component)this.enableWrapperStyleCB).add(19, 19, 19).add((Component)this.enableMIMEContentCB).add(19, 19, 19).add((Component)this.enableAsyncMappingCB).addContainerGap(23, Short.MAX_VALUE)));
        this.packageLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_PACKAGE_NAME"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.defaultPackageCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultPackageCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_USE_DEFAULT"));
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (DefinitionsPanel.this.defaultPackageCB.isSelected()) {
                DefinitionsPanel.this.packageNameText.setEnabled(false);
            } else {
                DefinitionsPanel.this.packageNameText.setEnabled(true);
                DefinitionsPanel.this.packageNameText.requestFocus();
            }
        }
    }

    class DefinitionsActionListener
    implements ActionListener {
        DefinitionsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefinitionsPanel.this.setValue((JComponent)actionEvent.getSource(), null);
        }
    }
}

