/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.netbeans.modules.debugger.jpda.ui.SwitcherTable;
import org.netbeans.modules.debugger.jpda.ui.SwitcherTableItem;
import org.openide.util.Utilities;

final class ButtonPopupSwitcher
implements MouseInputListener,
AWTEventListener {
    private static Popup popup;
    private Component invokingComponent = null;
    private long invocationTime = -1L;
    private static boolean shown;
    private SwitcherTable pTable;
    private int x;
    private int y;

    public static void selectItem(JComponent owner, SwitcherTableItem[] items, int x, int y) {
        ButtonPopupSwitcher switcher = new ButtonPopupSwitcher(owner, items, x, y);
        switcher.doSelect(owner);
    }

    private ButtonPopupSwitcher(JComponent owner, SwitcherTableItem[] items, int x, int y) {
        int cornerY;
        int yOrient;
        int cornerX;
        int xOrient;
        int ownerWidth = owner.getWidth();
        int ownerHeight = owner.getHeight();
        Rectangle screenRect = Utilities.getUsableScreenBounds();
        int gap = y == 0 ? 10 : 5;
        int height = 0;
        int leftD = x - screenRect.x;
        int rightD = screenRect.x + screenRect.width - x;
        if (leftD < rightD / 2) {
            xOrient = 1;
            cornerX = x + 1;
        } else {
            xOrient = -1;
            cornerX = x + ownerWidth;
        }
        int topD = y - screenRect.y;
        int bottomD = screenRect.y + screenRect.height - y;
        if (bottomD < topD / 4) {
            yOrient = -1;
            height = topD - gap;
            cornerY = y;
        } else {
            yOrient = 1;
            cornerY = y + ownerHeight;
            height = screenRect.height - cornerY - gap;
        }
        this.pTable = new SwitcherTable(items, height);
        this.x = cornerX - (xOrient == -1 ? (int)this.pTable.getPreferredSize().getWidth() : 0);
        this.y = cornerY - (yOrient == -1 ? (int)this.pTable.getPreferredSize().getHeight() : 0);
    }

    private void doSelect(JComponent owner) {
        this.invokingComponent = owner;
        this.invokingComponent.addMouseListener(this);
        this.invokingComponent.addMouseMotionListener(this);
        this.pTable.addMouseListener(this);
        this.pTable.addMouseMotionListener(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        popup = PopupFactory.getSharedInstance().getPopup(this.invokingComponent, this.pTable, this.x, this.y);
        popup.show();
        shown = true;
        this.invocationTime = System.currentTimeMillis();
    }

    public static boolean isShown() {
        return shown;
    }

    private synchronized void hideCurrentPopup() {
        this.pTable.removeMouseListener(this);
        this.pTable.removeMouseMotionListener(this);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.invokingComponent != null) {
            this.invokingComponent.removeMouseListener(this);
            this.invokingComponent.removeMouseMotionListener(this);
            this.invokingComponent = null;
        }
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
            popup = null;
            shown = false;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        e.consume();
        Point p = e.getPoint();
        if (e.getSource() != this) {
            p = SwingUtilities.convertPoint((Component)e.getSource(), p, this.pTable);
        }
        if (this.pTable.contains(p)) {
            int row = this.pTable.rowAtPoint(p);
            int col = this.pTable.columnAtPoint(p);
            this.pTable.changeSelection(row, col, false, false);
        } else {
            this.pTable.clearSelection();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        SwitcherTableItem item;
        e.consume();
        Point p = e.getPoint();
        p = SwingUtilities.convertPoint((Component)e.getSource(), p, this.pTable);
        if (this.pTable.contains(p) && (item = this.pTable.getSelectedItem()) != null) {
            item.activate();
            this.hideCurrentPopup();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        long time;
        if (e.getSource() == this.invokingComponent && (time = System.currentTimeMillis()) - this.invocationTime > 500L) {
            this.mousePressed(e);
        }
        e.consume();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseDragged(e);
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.pTable.clearSelection();
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
        e.consume();
    }

    private boolean onSwitcherTable(MouseEvent e) {
        Point p = e.getPoint();
        if (!(e.getSource() instanceof Component)) {
            return false;
        }
        p = SwingUtilities.convertPoint((Component)e.getSource(), p, this.pTable);
        return this.pTable.contains(p);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getSource() == this) {
            return;
        }
        if (event instanceof MouseEvent) {
            if (event.getID() == 502) {
                long time = System.currentTimeMillis();
                if (time - this.invocationTime > 500L && !this.onSwitcherTable((MouseEvent)event)) {
                    this.hideCurrentPopup();
                }
            } else if (event.getID() == 501 && !this.onSwitcherTable((MouseEvent)event) && event.getSource() != this.invokingComponent) {
                this.hideCurrentPopup();
            }
        } else if (event instanceof KeyEvent && event.getID() == 401) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.hideCurrentPopup();
        }
    }

    private class PopupHider
    implements Runnable {
        private Popup toHide;

        public PopupHider(Popup popup) {
            this.toHide = popup;
        }

        @Override
        public void run() {
            this.toHide.hide();
            this.toHide = null;
        }
    }
}

