/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.EditRegions;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

public class BlockVarReuse
extends RubyAstRule {
    public boolean appliesTo(RuleContext context) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.ITERNODE);
    }

    public void cancel() {
    }

    public String getId() {
        return "Block_Var_Reuse";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(BlockVarReuse.class, (String)"UnintentionalSideEffect");
    }

    public String getDescription() {
        return NbBundle.getMessage(BlockVarReuse.class, (String)"UnintentionalSideEffectDesc");
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        ParserResult info = context.parserResult;
        if (node.getNodeType() == NodeType.ITERNODE) {
            List list = node.childNodes();
            for (Node child : list) {
                if (child.getNodeType() != NodeType.LOCALASGNNODE) continue;
                OffsetRange range = AstUtilities.getNameRange((Node)child);
                ArrayList<RenameVarFix> fixList = new ArrayList<RenameVarFix>(2);
                Node root = AstUtilities.getRoot((Parser.Result)info);
                AstPath childPath = new AstPath(root, child);
                fixList.add(new RenameVarFix(context, childPath, false));
                fixList.add(new RenameVarFix(context, childPath, true));
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range)) == OffsetRange.NONE) continue;
                Hint desc = new Hint((Rule)this, this.getDisplayName(), RubyUtils.getFileObject((Parser.Result)info), range, fixList, 100);
                result.add(desc);
            }
        }
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static class RenameVarFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final AstPath path;
        private final boolean renameLocal;

        RenameVarFix(RubyRuleContext context, AstPath path, boolean renameLocal) {
            this.context = context;
            this.path = path;
            this.renameLocal = renameLocal;
        }

        public String getDescription() {
            if (this.renameLocal) {
                return NbBundle.getMessage(BlockVarReuse.class, (String)"ChangeLocalVarName");
            }
            return NbBundle.getMessage(BlockVarReuse.class, (String)"ChangeBlockVarName");
        }

        public void implement() throws Exception {
            Set<OffsetRange> ranges = this.findRegionsToEdit();
            int caretOffset = Integer.MAX_VALUE;
            for (OffsetRange range : ranges) {
                if (range.getStart() >= caretOffset) continue;
                caretOffset = range.getStart();
            }
            EditRegions.getInstance().edit(RubyUtils.getFileObject((Parser.Result)this.context.parserResult), ranges, caretOffset);
        }

        private void addNonBlockRefs(Node node, String name, Set<OffsetRange> ranges, boolean isParameter) {
            OffsetRange range;
            if ((node.getNodeType() == NodeType.LOCALASGNNODE || node.getNodeType() == NodeType.LOCALVARNODE) && name.equals(((INameNode)node).getName())) {
                range = AstUtilities.getNameRange((Node)node);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)this.context.parserResult, (OffsetRange)range)) != OffsetRange.NONE) {
                    ranges.add(range);
                }
            } else if (isParameter && node.getNodeType() == NodeType.ARGUMENTNODE && name.equals(((INameNode)node).getName())) {
                range = AstUtilities.getNameRange((Node)node);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)this.context.parserResult, (OffsetRange)range)) != OffsetRange.NONE) {
                    ranges.add(range);
                }
            } else if (node.getNodeType() == NodeType.ARGSNODE) {
                isParameter = true;
            }
            List list = node.childNodes();
            for (Node child : list) {
                if (child.isInvisible() || child.getNodeType() == NodeType.DEFNNODE || child.getNodeType() == NodeType.DEFSNODE || child.getNodeType() == NodeType.ITERNODE && child == this.path.leafParent()) continue;
                this.addNonBlockRefs(child, name, ranges, isParameter);
            }
        }

        private Set<OffsetRange> findRegionsToEdit() {
            HashSet<OffsetRange> ranges = new HashSet<OffsetRange>();
            assert (this.path.leaf() instanceof INameNode);
            String name = ((INameNode)this.path.leaf()).getName();
            if (this.renameLocal) {
                Node scope = AstUtilities.findLocalScope((Node)this.path.leaf(), (AstPath)this.path);
                this.addNonBlockRefs(scope, name, ranges, false);
            } else {
                Node parent = this.path.leafParent();
                assert (parent instanceof IterNode);
                this.addNonBlockRefs(parent, name, ranges, false);
            }
            return ranges;
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }

        public EditList getEditList() throws Exception {
            BaseDocument doc = this.context.doc;
            EditList edits = new EditList(doc);
            Set<OffsetRange> ranges = this.findRegionsToEdit();
            String oldName = ((INameNode)this.path.leaf()).getName();
            int oldLen = oldName.length();
            String newName = "new_name";
            for (OffsetRange range : ranges) {
                edits.replace(range.getStart(), oldLen, newName, false, 0);
            }
            return edits;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

