/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.EditRegions;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyStructureAnalyzer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstAttributeElement;
import org.netbeans.modules.ruby.elements.AstClassElement;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AttributeIsLocal
extends RubyAstRule {
    private Map<AstClassElement, Set<AstAttributeElement>> attributes;
    private Set<String> attributeNames;

    public boolean appliesTo(RuleContext context) {
        ParserResult parserResult = context.parserResult;
        RubyParseResult rpr = AstUtilities.getParseResult((Parser.Result)parserResult);
        RubyStructureAnalyzer.AnalysisResult ar = rpr.getStructure();
        this.attributes = ar.getAttributes();
        if (this.attributes == null || this.attributes.size() == 0) {
            return false;
        }
        this.attributeNames = new HashSet<String>();
        for (AstClassElement clz : this.attributes.keySet()) {
            Set<AstAttributeElement> ats = this.attributes.get(clz);
            for (AstAttributeElement ae : ats) {
                if (ae.isReadOnly()) continue;
                this.attributeNames.add(ae.getName());
            }
        }
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.LOCALASGNNODE);
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        AstPath path = context.path;
        ParserResult parserResult = context.parserResult;
        String name = ((INameNode)node).getName();
        AstAttributeElement element = null;
        if (this.attributeNames.contains(name)) {
            Set<AstClassElement> keySet = this.attributes.keySet();
            boolean match = false;
            AstClassElement clzElement = null;
            String fqn = AstUtilities.getFqnName((AstPath)path);
            for (AstClassElement clz : keySet) {
                if (!fqn.equals(clz.getFqn())) continue;
                clzElement = clz;
                break;
            }
            if (clzElement == null) {
                return;
            }
            match = false;
            Set<AstAttributeElement> attribs = this.attributes.get(clzElement);
            if (attribs != null) {
                for (AstAttributeElement ae : attribs) {
                    if (!ae.getName().equals(name)) continue;
                    element = ae;
                    match = true;
                    break;
                }
            }
            if (!match) {
                return;
            }
            ListIterator it = path.leafToRoot();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (n.getNodeType() != NodeType.ARGSNODE) continue;
                return;
            }
            assert (element != null);
            OffsetRange range = AstUtilities.getNameRange((Node)node);
            ArrayList<Object> fixList = new ArrayList<Object>(1);
            fixList.add(new ShowAttributeFix(parserResult, element));
            fixList.add(new AttributeConflictFix(context, node, true));
            fixList.add(new AttributeConflictFix(context, node, false));
            range = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)range);
            if (range != OffsetRange.NONE) {
                Hint desc = new Hint((Rule)this, this.getDisplayName(), RubyUtils.getFileObject((Parser.Result)parserResult), range, fixList, 50);
                result.add(desc);
            }
        }
    }

    public String getId() {
        return "Attribute_Is_Local";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AttributeIsLocal.class, (String)"AttributeIsLocal");
    }

    public String getDescription() {
        return NbBundle.getMessage(AttributeIsLocal.class, (String)"AttributeIsLocalDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static class ShowAttributeFix
    implements HintFix {
        private final ParserResult parserResult;
        private final AstAttributeElement element;

        ShowAttributeFix(ParserResult parserResult, AstAttributeElement element) {
            this.parserResult = parserResult;
            this.element = element;
        }

        public String getDescription() {
            Node creationNode = this.element.getCreationNode();
            String desc = creationNode instanceof INameNode ? ((INameNode)creationNode).getName() + " " + this.element.getName() : this.element.getName();
            return NbBundle.getMessage(AttributeIsLocal.class, (String)"ShowAttribute", (Object)desc);
        }

        public void implement() throws Exception {
            FileObject fo = RubyUtils.getFileObject((Parser.Result)this.parserResult);
            int astOffset = this.element.getNode().getPosition().getStartOffset();
            int lexOffset = LexUtilities.getLexerOffset((Parser.Result)this.parserResult, (int)astOffset);
            if (lexOffset != -1) {
                GsfUtilities.open((FileObject)fo, (int)lexOffset, (String)this.element.getName());
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return true;
        }
    }

    private static class AttributeConflictFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final boolean fixSelf;
        private final Node node;

        AttributeConflictFix(RubyRuleContext context, Node node, boolean fixSelf) {
            this.context = context;
            this.node = node;
            this.fixSelf = fixSelf;
        }

        public String getDescription() {
            return this.fixSelf ? NbBundle.getMessage(AttributeIsLocal.class, (String)"FixSelf", (Object)((INameNode)this.node).getName()) : NbBundle.getMessage(AttributeIsLocal.class, (String)"FixRename");
        }

        public void implement() throws Exception {
            EditList edits = this.createEditList(true);
            if (edits != null) {
                edits.apply();
            }
        }

        public EditList getEditList() throws Exception {
            return this.createEditList(false);
        }

        private EditList createEditList(boolean doit) throws Exception {
            BaseDocument doc = this.context.doc;
            ParserResult parserResult = this.context.parserResult;
            EditList edits = new EditList(doc);
            if (this.fixSelf) {
                OffsetRange range = AstUtilities.getRange((Node)this.node);
                int start = range.getStart();
                if ((start = LexUtilities.getLexerOffset((Parser.Result)parserResult, (int)start)) != -1) {
                    edits.replace(start, 0, "self.", false, 0);
                }
            } else {
                String name = ((INameNode)this.node).getName();
                Node root = AstUtilities.getRoot((Parser.Result)parserResult);
                AstPath path = new AstPath(root, this.node);
                Node scope = AstUtilities.findLocalScope((Node)path.leaf(), (AstPath)path);
                HashSet<OffsetRange> ranges = new HashSet<OffsetRange>();
                this.addLocalRegions(scope, name, ranges);
                int caretOffset = Integer.MAX_VALUE;
                for (OffsetRange range : ranges) {
                    if (range.getStart() >= caretOffset) continue;
                    caretOffset = range.getStart();
                }
                if (doit) {
                    EditRegions.getInstance().edit(RubyUtils.getFileObject((Parser.Result)parserResult), ranges, caretOffset);
                    return null;
                }
                String oldName = ((INameNode)path.leaf()).getName();
                int oldLen = oldName.length();
                String newName = "new_name";
                for (OffsetRange range : ranges) {
                    edits.replace(range.getStart(), oldLen, newName, false, 0);
                }
            }
            return edits;
        }

        private void addLocalRegions(Node node, String name, Set<OffsetRange> ranges) {
            if ((node.getNodeType() == NodeType.LOCALASGNNODE || node.getNodeType() == NodeType.LOCALVARNODE) && name.equals(((INameNode)node).getName())) {
                OffsetRange range = AstUtilities.getNameRange((Node)node);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)this.context.parserResult, (OffsetRange)range)) != OffsetRange.NONE) {
                    ranges.add(range);
                }
            }
            List list = node.childNodes();
            for (Node child : list) {
                if (child.isInvisible() || child instanceof MethodDefNode) continue;
                this.addLocalRegions(child, name, ranges);
            }
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

