/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java_cup.runtime.Symbol;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.php.editor.parser.GSFPHPError;
import org.netbeans.modules.php.editor.parser.GSFPHPParser;
import org.netbeans.modules.php.editor.parser.ParserErrorHandler;
import org.netbeans.modules.php.editor.parser.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.openide.util.NbBundle;

public class PHP5ErrorHandler
implements ParserErrorHandler {
    private static final Logger LOGGER = Logger.getLogger(PHP5ErrorHandler.class.getName());
    private final List<SyntaxError> syntaxErrors;
    private final GSFPHPParser.Context context;
    GSFPHPParser outer;

    public PHP5ErrorHandler(GSFPHPParser.Context context, GSFPHPParser outer) {
        this.outer = outer;
        this.context = context;
        this.syntaxErrors = new ArrayList<SyntaxError>();
    }

    @Override
    public void handleError(ParserErrorHandler.Type type, short[] expectedtokens, Symbol current, Symbol previous) {
        if (type == ParserErrorHandler.Type.SYNTAX_ERROR) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Syntax error:");
                LOGGER.finest("Current [" + current.left + ", " + current.right + "](" + Utils.getASTScannerTokenName(current.sym) + "): " + current.value);
                LOGGER.finest("Previous [" + previous.left + ", " + previous.right + "] (" + Utils.getASTScannerTokenName(previous.sym) + "):" + previous.value);
                StringBuffer message = new StringBuffer();
                message.append("Expected tokens:");
                for (int i = 0; i < expectedtokens.length; i += 2) {
                    message.append(" ").append(Utils.getASTScannerTokenName(expectedtokens[i]));
                }
                LOGGER.finest(message.toString());
            }
            this.syntaxErrors.add(new SyntaxError(expectedtokens, current, previous));
        } else {
            String message = null;
            if (current != null) {
                String tagText = this.getTokenTextForm(current.sym);
                message = tagText != null ? "Unexpected " + tagText : "Unexpected " + Utils.getASTScannerTokenName(current.sym);
            }
            if (message == null) {
                message = "Parser error";
            }
            GSFPHPError gSFPHPError = new GSFPHPError(message, this.context.getSnapshot().getSource().getFileObject(), current.left, current.right, Severity.ERROR, null);
        }
    }

    public List<Error> displayFatalError() {
        FatalError error = new FatalError();
        return Arrays.asList(error);
    }

    public List<Error> displaySyntaxErrors(Program program) {
        ArrayList<Error> errors = new ArrayList<Error>();
        for (SyntaxError syntaxError : this.syntaxErrors) {
            ASTNode astError = null;
            if (program != null) {
                astError = org.netbeans.modules.php.editor.parser.api.Utils.getNodeAtOffset(program, ((SyntaxError)syntaxError).currentToken.left);
                if (!(astError instanceof ASTError) && !((astError = org.netbeans.modules.php.editor.parser.api.Utils.getNodeAtOffset(program, ((SyntaxError)syntaxError).previousToken.right)) instanceof ASTError)) {
                    astError = null;
                }
                if (astError != null) {
                    LOGGER.finest("ASTError [" + astError.getStartOffset() + ", " + astError.getEndOffset() + "]");
                } else {
                    LOGGER.finest("ASTError was not found");
                }
            }
            Error error = this.defaultSyntaxErrorHandling(syntaxError, astError);
            errors.add(error);
        }
        return errors;
    }

    private Error defaultSyntaxErrorHandling(SyntaxError syntaxError, ASTNode astError) {
        GSFPHPError error = null;
        String unexpectedText = "";
        StringBuffer message = new StringBuffer();
        boolean isUnexpected = false;
        int start = syntaxError.getCurrentToken().left;
        int end = syntaxError.getCurrentToken().right;
        if (syntaxError.getCurrentToken().sym == 0) {
            isUnexpected = true;
            unexpectedText = NbBundle.getMessage(PHP5ErrorHandler.class, (String)"SE_EOF");
            start = end - 1;
        } else if (syntaxError.getCurrentToken().sym == 12) {
            isUnexpected = true;
            unexpectedText = "String";
            end = start + ((String)syntaxError.getCurrentToken().value).trim().length();
        } else {
            String currentText = (String)syntaxError.getCurrentToken().value;
            boolean bl = isUnexpected = currentText != null && currentText.trim().length() > 0;
            if (isUnexpected) {
                unexpectedText = currentText.trim();
                end = start + unexpectedText.length();
            }
        }
        ArrayList<String> possibleTags = new ArrayList<String>();
        for (int i = 0; i < syntaxError.getExpectedTokens().length; i += 2) {
            String text = this.getTokenTextForm(syntaxError.getExpectedTokens()[i]);
            if (text == null) continue;
            possibleTags.add(text);
        }
        message.append(NbBundle.getMessage(PHP5ErrorHandler.class, (String)"SE_Message"));
        message.append(':');
        if (isUnexpected) {
            message.append(' ').append(NbBundle.getMessage(PHP5ErrorHandler.class, (String)"SE_Unexpected"));
            message.append(": ");
            message.append(unexpectedText);
        }
        if (possibleTags.size() > 0) {
            message.append('\n').append(NbBundle.getMessage(PHP5ErrorHandler.class, (String)"SE_Expected"));
            message.append(": ");
            boolean addOR = false;
            for (String tag : possibleTags) {
                if (addOR) {
                    message.append(", ");
                } else {
                    addOR = true;
                }
                message.append(tag);
            }
        }
        if (astError != null) {
            start = astError.getStartOffset();
            end = astError.getEndOffset();
            String text = this.context.getSource().substring(start, end);
            int lastNewLine = text.length() - 1;
            while ((text.charAt(lastNewLine) == '\n' || text.charAt(lastNewLine) == '\r' || text.charAt(lastNewLine) == '\t' || text.charAt(lastNewLine) == ' ') && --lastNewLine >= 0) {
            }
            if ((lastNewLine = text.lastIndexOf(10, lastNewLine)) > 0) {
                start = start + lastNewLine + 1;
            }
        }
        error = new GSFPHPError(message.toString(), this.context.getSnapshot().getSource().getFileObject(), start, end, Severity.ERROR, new Object[]{syntaxError});
        return error;
    }

    public List<SyntaxError> getSyntaxErrors() {
        return this.syntaxErrors;
    }

    private String getTokenTextForm(int token) {
        String text = null;
        switch (token) {
            case 6: {
                text = "identifier";
                break;
            }
            case 8: {
                text = "variable";
                break;
            }
            case 120: {
                text = "++";
                break;
            }
            case 121: {
                text = "--";
                break;
            }
            case 104: {
                text = "===";
                break;
            }
            case 105: {
                text = "!==";
                break;
            }
            case 102: {
                text = "==";
                break;
            }
            case 103: {
                text = "!=";
                break;
            }
            case 106: {
                text = "<=+";
                break;
            }
            case 107: {
                text = ">=+";
                break;
            }
            case 84: {
                text = "+=";
                break;
            }
            case 85: {
                text = "-=";
                break;
            }
            case 86: {
                text = "*=";
                break;
            }
            case 87: {
                text = "/=";
                break;
            }
            case 88: {
                text = ".=";
                break;
            }
            case 89: {
                text = "%=";
                break;
            }
            case 93: {
                text = "<<=";
                break;
            }
            case 94: {
                text = ">>=";
                break;
            }
            case 90: {
                text = "&=";
                break;
            }
            case 91: {
                text = "|+";
                break;
            }
            case 92: {
                text = "^=";
                break;
            }
            case 97: {
                text = "||";
                break;
            }
            case 98: {
                text = "&&";
                break;
            }
            case 79: {
                text = "OR";
                break;
            }
            case 81: {
                text = "AND";
                break;
            }
            case 80: {
                text = "XOR";
                break;
            }
            case 110: {
                text = "<<";
                break;
            }
            case 111: {
                text = ">>";
                break;
            }
            case 96: {
                text = "';'";
                break;
            }
            case 144: {
                text = "':'";
                break;
            }
            case 78: {
                text = "','";
                break;
            }
            case 119: {
                text = "'.'";
                break;
            }
            case 130: {
                text = "[";
                break;
            }
            case 131: {
                text = "]";
                break;
            }
            case 142: {
                text = "(";
                break;
            }
            case 143: {
                text = ")";
                break;
            }
            case 99: {
                text = "|";
                break;
            }
            case 100: {
                text = "^";
                break;
            }
            case 101: {
                text = "&";
                break;
            }
            case 112: {
                text = "+";
                break;
            }
            case 113: {
                text = "-";
                break;
            }
            case 115: {
                text = "/";
                break;
            }
            case 114: {
                text = "*";
                break;
            }
            case 83: {
                text = "=";
                break;
            }
            case 116: {
                text = "%";
                break;
            }
            case 117: {
                text = "!";
                break;
            }
            case 118: {
                text = "~";
                break;
            }
            case 145: {
                text = "$";
                break;
            }
            case 108: {
                text = "<";
                break;
            }
            case 109: {
                text = ">";
                break;
            }
            case 95: {
                text = "?";
                break;
            }
            case 129: {
                text = "@";
                break;
            }
            case 2: {
                text = "exit";
                break;
            }
            case 34: {
                text = "function";
                break;
            }
            case 35: {
                text = "const";
                break;
            }
            case 36: {
                text = "return";
                break;
            }
            case 3: {
                text = "if";
                break;
            }
            case 134: {
                text = "elseif";
                break;
            }
            case 133: {
                text = "endif";
                break;
            }
            case 135: {
                text = "else";
                break;
            }
            case 16: {
                text = "while";
                break;
            }
            case 17: {
                text = "endwhile";
                break;
            }
            case 15: {
                text = "do";
                break;
            }
            case 18: {
                text = "for";
                break;
            }
            case 19: {
                text = "endfor";
                break;
            }
            case 20: {
                text = "foreach";
                break;
            }
            case 21: {
                text = "endforeach";
                break;
            }
            case 26: {
                text = "as";
                break;
            }
            case 27: {
                text = "switch";
                break;
            }
            case 28: {
                text = "endswitch";
                break;
            }
            case 29: {
                text = "case";
                break;
            }
            case 30: {
                text = "default";
                break;
            }
            case 31: {
                text = "break";
                break;
            }
            case 32: {
                text = "continue";
                break;
            }
            case 13: {
                text = "echo";
                break;
            }
            case 82: {
                text = "print";
                break;
            }
            case 47: {
                text = "class";
                break;
            }
            case 37: {
                text = "try";
                break;
            }
            case 38: {
                text = "catch";
                break;
            }
            case 39: {
                text = "throw";
                break;
            }
            case 24: {
                text = "instanceof";
                break;
            }
            case 48: {
                text = "interface";
                break;
            }
            case 50: {
                text = "implements";
                break;
            }
            case 137: {
                text = "abstract";
                break;
            }
            case 138: {
                text = "final";
                break;
            }
            case 139: {
                text = "private";
                break;
            }
            case 140: {
                text = "protected";
                break;
            }
            case 141: {
                text = "public";
                break;
            }
            case 49: {
                text = "extends";
                break;
            }
            case 132: {
                text = "new";
                break;
            }
            case 75: {
                text = "eval";
                break;
            }
            case 73: {
                text = "include";
                break;
            }
            case 74: {
                text = "include_once";
                break;
            }
            case 76: {
                text = "require";
                break;
            }
            case 77: {
                text = "require_once";
                break;
            }
            case 40: {
                text = "use";
                break;
            }
            case 41: {
                text = "global";
                break;
            }
            case 44: {
                text = "isset";
                break;
            }
            case 45: {
                text = "empty";
                break;
            }
            case 136: {
                text = "static";
                break;
            }
            case 43: {
                text = "unset";
                break;
            }
            case 53: {
                text = "array";
                break;
            }
            case 42: {
                text = "var";
                break;
            }
            case 22: {
                text = "declare";
                break;
            }
            case 23: {
                text = "enddeclare";
                break;
            }
            case 51: {
                text = "->";
                break;
            }
            case 66: {
                text = "::";
                break;
            }
            case 65: {
                text = "}";
                break;
            }
            case 64: {
                text = "{";
                break;
            }
            case 52: {
                text = "=>";
                break;
            }
            case 62: {
                text = "${";
            }
        }
        return text;
    }

    private class FatalError
    extends GSFPHPError {
        FatalError() {
            super(NbBundle.getMessage(PHP5ErrorHandler.class, (String)"MSG_FatalError"), PHP5ErrorHandler.this.context.getSnapshot().getSource().getFileObject(), 0, PHP5ErrorHandler.this.context.getSource().length(), Severity.ERROR, null);
        }

        @Override
        public boolean isLineError() {
            return false;
        }
    }

    public static class SyntaxError {
        private final short[] expectedTokens;
        private final Symbol currentToken;
        private final Symbol previousToken;

        public SyntaxError(short[] expectedTokens, Symbol currentToken, Symbol previousToken) {
            this.expectedTokens = expectedTokens;
            this.currentToken = currentToken;
            this.previousToken = previousToken;
        }

        public Symbol getCurrentToken() {
            return this.currentToken;
        }

        public Symbol getPreviousToken() {
            return this.previousToken;
        }

        public short[] getExpectedTokens() {
            return this.expectedTokens;
        }
    }
}

