/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VarAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.openide.util.Union2;

class VariableBaseType {
    public static final String FUNCTION_TYPE_PREFIX = "fn:";
    public static final String METHOD_TYPE_PREFIX = "mtd:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "static.mtd:";
    public static final String FIELD_TYPE_PREFIX = "fld:";
    public static final String STATIC_FIELD__TYPE_PREFIX = "static.fld:";
    public static final String VAR_TYPE_PREFIX = "var:";
    private Union2<String, TypeScopeImpl> type;

    private VariableBaseType(Union2<String, TypeScopeImpl> type) {
        this.type = type;
    }

    static VariableBaseType create(MethodInvocation mi) {
        return VariableBaseType.createImpl(mi);
    }

    static VariableBaseType create(Variable variable) {
        return VariableBaseType.createImpl(variable);
    }

    static VariableBaseType create(StaticMethodInvocation smi) {
        return VariableBaseType.createImpl(smi);
    }

    static VariableBaseType create(FunctionInvocation fi) {
        return VariableBaseType.createImpl(fi);
    }

    static VariableBaseType create(Assignment assignment) {
        return new VariableBaseType((Union2<String, TypeScopeImpl>)Union2.createFirst((Object)VariableBaseType.extractVariableTypeFromAssignment(assignment, new HashMap<String, VariableNameImpl>())));
    }

    private static VariableBaseType createImpl(VariableBase varBase) {
        return new VariableBaseType((Union2<String, TypeScopeImpl>)Union2.createFirst((Object)VariableBaseType.extractTypeFroVariableBase(varBase, new HashMap<String, VariableNameImpl>())));
    }

    private static String extractTypeFroVariableBase(VariableBase varBase, Map<String, VariableNameImpl> allAssignments) {
        Stack<VariableBase> stack = new Stack<VariableBase>();
        String typeName = null;
        VariableBaseType.createVariableBaseChain(varBase, stack);
        while (!stack.isEmpty() && stack.peek() != null) {
            varBase = stack.pop();
            String tmpType = VariableBaseType.extractVariableTypeFromVariableBase(varBase, allAssignments);
            if (tmpType == null) {
                typeName = tmpType;
                break;
            }
            if (typeName == null) {
                typeName = tmpType;
                continue;
            }
            typeName = typeName + tmpType;
        }
        return typeName;
    }

    private static void createVariableBaseChain(VariableBase node, Stack<VariableBase> stack) {
        stack.push(node);
        if (node instanceof MethodInvocation) {
            VariableBaseType.createVariableBaseChain(((MethodInvocation)node).getDispatcher(), stack);
        }
    }

    private static String extractVariableTypeFromVariableBase(VariableBase varBase, Map<String, VariableNameImpl> allAssignments) {
        MethodInvocation methodInvocation;
        String methodName;
        if (varBase instanceof Variable) {
            String semiTypeName;
            VarAssignmentImpl last;
            String varName = CodeUtils.extractVariableName((Variable)varBase);
            VariableNameImpl nameImpl = allAssignments.get(varName);
            if (nameImpl != null && (last = ModelUtils.getLast(nameImpl.getVarAssignments())) != null && (semiTypeName = last.typeNameFromUnion()) != null) {
                return semiTypeName;
            }
            return "@var:" + varName;
        }
        if (varBase instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)varBase;
            String fname = CodeUtils.extractFunctionName(functionInvocation);
            return "@fn:" + fname;
        }
        if (varBase instanceof StaticMethodInvocation) {
            StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)varBase;
            String className = CodeUtils.extractUnqualifiedClassName(staticMethodInvocation);
            String methodName2 = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod());
            if (className != null && methodName2 != null) {
                return "@static.mtd:" + className + '.' + methodName2;
            }
        } else if (varBase instanceof MethodInvocation && (methodName = CodeUtils.extractFunctionName((methodInvocation = (MethodInvocation)varBase).getMethod())) != null) {
            return "@mtd:" + methodName;
        }
        return null;
    }

    static String extractVariableTypeFromAssignment(Assignment assignment, Map<String, VariableNameImpl> allAssignments) {
        Expression expression = assignment.getRightHandSide();
        if (expression instanceof Assignment) {
            return VariableBaseType.extractVariableTypeFromAssignment((Assignment)expression, allAssignments);
        }
        if (expression instanceof Reference) {
            Reference ref = (Reference)expression;
            expression = ref.getExpression();
        }
        if (expression instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
            Expression className = classInstanceCreation.getClassName().getName();
            if (className instanceof Identifier) {
                Identifier identifier = (Identifier)className;
                return identifier.getName();
            }
        } else {
            if (expression instanceof ArrayCreation) {
                return "array";
            }
            if (expression instanceof VariableBase) {
                return VariableBaseType.extractTypeFroVariableBase((VariableBase)expression, allAssignments);
            }
        }
        return null;
    }
}

