/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.TreeElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;

final class TypeTreeElementImpl
implements TreeElement<TypeElement> {
    private final TypeElement delegate;
    private final Set<TypeElement> preferredTypes;

    TypeTreeElementImpl(TypeElement delegate) {
        this(delegate, new HashSet<TypeElement>());
    }

    TypeTreeElementImpl(TypeElement delegate, Set<TypeElement> preferredTypes) {
        this.delegate = delegate;
        this.preferredTypes = preferredTypes;
    }

    @Override
    public Set<TreeElement<TypeElement>> children() {
        QualifiedName superClassName;
        HashSet<TreeElement<TypeElement>> directTypes = new HashSet<TreeElement<TypeElement>>();
        if (this.delegate instanceof ClassElement && (superClassName = ((ClassElement)this.delegate).getSuperClassName()) != null) {
            ElementFilter forName = ElementFilter.forName(NameKind.exact(superClassName));
            Set<TypeElement> types = forName.filter(this.preferredTypes);
            if (types.isEmpty()) {
                ElementQuery.Index index = this.getIndex();
                types = index.getTypes(NameKind.exact(superClassName));
            }
            for (TypeElement typeElementImpl : types) {
                directTypes.add(new TypeTreeElementImpl(typeElementImpl, this.preferredTypes));
            }
        }
        for (QualifiedName iface : this.delegate.getSuperInterfaces()) {
            ElementFilter forName = ElementFilter.forName(NameKind.exact(iface));
            Set<TypeElement> types = forName.filter(this.preferredTypes);
            if (types.isEmpty()) {
                ElementQuery.Index index = this.getIndex();
                types = index.getTypes(NameKind.exact(iface));
            }
            for (TypeElement typeElementImpl : types) {
                directTypes.add(new TypeTreeElementImpl(typeElementImpl, this.preferredTypes));
            }
        }
        return directTypes;
    }

    @Override
    public TypeElement getElement() {
        return this.delegate;
    }

    private ElementQuery.Index getIndex() {
        ElementQuery elementQuery = this.delegate.getElementQuery();
        boolean indexScope = elementQuery.getQueryScope().isIndexScope();
        if (indexScope && elementQuery instanceof ElementQuery.Index) {
            return (ElementQuery.Index)elementQuery;
        }
        return null;
    }
}

