/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public abstract class ResultConvertor<T> {
    public abstract T convert(ElementKind var1, String var2);

    public static ResultConvertor<FileObject> fileObjectConvertor(FileObject ... roots) {
        assert (roots != null);
        return new FileObjectConvertor(roots);
    }

    public static ResultConvertor<ElementHandle<TypeElement>> elementHandleConvertor() {
        return new ElementHandleConvertor();
    }

    public static ResultConvertor<String> identityConvertor() {
        return new IdentityConvertor();
    }

    private static class IdentityConvertor
    extends ResultConvertor<String> {
        private IdentityConvertor() {
        }

        @Override
        public String convert(ElementKind kind, String value) {
            return value;
        }
    }

    private static class ElementHandleConvertor
    extends ResultConvertor<ElementHandle<TypeElement>> {
        private ElementHandleConvertor() {
        }

        @Override
        public ElementHandle<TypeElement> convert(ElementKind kind, String value) {
            return ElementHandleConvertor.createTypeHandle(kind, value);
        }

        private static ElementHandle<TypeElement> createTypeHandle(ElementKind kind, String binaryName) {
            assert (binaryName != null);
            return ElementHandleAccessor.INSTANCE.create(kind, binaryName);
        }
    }

    private static class FileObjectConvertor
    extends ResultConvertor<FileObject> {
        private FileObject[] roots;

        private FileObjectConvertor(FileObject ... roots) {
            this.roots = roots;
        }

        @Override
        public FileObject convert(ElementKind kind, String value) {
            for (FileObject root : this.roots) {
                FileObject result = FileObjectConvertor.resolveFile(root, value);
                if (result == null) continue;
                return result;
            }
            ClassIndexManager cim = ClassIndexManager.getDefault();
            for (FileObject root : this.roots) {
                try {
                    FileObject result;
                    String sourceName;
                    ClassIndexImpl impl = cim.getUsagesQuery(root.getURL());
                    if (impl == null || (sourceName = impl.getSourceName(value)) == null || (result = root.getFileObject(sourceName)) == null) continue;
                    return result;
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            return null;
        }

        private static FileObject resolveFile(FileObject root, String classBinaryName) {
            String name;
            FileObject folder;
            assert (classBinaryName != null);
            int index = (classBinaryName = classBinaryName.replace('.', '/')).lastIndexOf(47);
            if (index < 0) {
                folder = root;
                name = classBinaryName;
            } else {
                assert (index > 0) : classBinaryName;
                assert (index < classBinaryName.length() - 1) : classBinaryName;
                folder = root.getFileObject(classBinaryName.substring(0, index));
                name = classBinaryName.substring(index + 1);
            }
            if (folder == null) {
                return null;
            }
            index = name.indexOf(36);
            if (index > 0) {
                name = name.substring(0, index);
            }
            for (FileObject child : folder.getChildren()) {
                if (!"java".equalsIgnoreCase(child.getExt()) || !name.equals(child.getName())) continue;
                return child;
            }
            return null;
        }
    }
}

