/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.dlight.procfs.reader.impl.ReusableByteBuffer;

class DataReader {
    private final ByteOrder byteOrder;
    private final AtomicInteger data_offset;
    private final ReusableByteBuffer buffer;
    private final int buffer_offset;

    DataReader(ReusableByteBuffer buffer, int offset, ByteOrder byteOrder) {
        this.buffer = buffer;
        this.byteOrder = byteOrder;
        this.buffer_offset = offset;
        this.data_offset = new AtomicInteger(0);
    }

    void releaseBuffer() {
        this.buffer.unlock(this.buffer_offset);
    }

    void seek(int pos) {
        this.data_offset.set(this.buffer_offset + pos);
    }

    int _int() {
        int b1 = 0xFF & this.buffer.buffer[this.data_offset.getAndIncrement()];
        int b2 = 0xFF & this.buffer.buffer[this.data_offset.getAndIncrement()];
        int b3 = 0xFF & this.buffer.buffer[this.data_offset.getAndIncrement()];
        int b4 = 0xFF & this.buffer.buffer[this.data_offset.getAndIncrement()];
        return this.byteOrder == ByteOrder.BIG_ENDIAN ? b1 << 24 | b2 << 16 | b3 << 8 | b4 : b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    long _time() {
        return (long)((double)this._int() * 1.0E9 + (double)this._int());
    }
}

