/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbBundle;

public final class SSHKeyFileChooser
extends JFileChooser {
    public SSHKeyFileChooser(String startPoint) {
        super(SSHKeyFileChooser.getClosestDirectory(startPoint));
        this.setMultiSelectionEnabled(false);
        this.setFileFilter(new SSHKeyFilter());
        this.setFileHidingEnabled(false);
        this.setDialogTitle(NbBundle.getMessage(SSHKeyFileChooser.class, (String)"SSHKeyFileChooser.DialogTitle.text"));
    }

    private static File getClosestDirectory(String startPoint) {
        File candidate = new File(startPoint.trim());
        while (candidate != null) {
            if (candidate.isDirectory()) {
                return candidate;
            }
            candidate = candidate.getParentFile();
        }
        return new File(System.getProperty("user.home"));
    }

    private static class SSHKeyFilter
    extends FileFilter {
        private static final JSch testJSch = new JSch();

        private SSHKeyFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            try {
                testJSch.addIdentity(file.getAbsolutePath());
                boolean bl = true;
                return bl;
            }
            catch (JSchException ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    testJSch.removeAllIdentity();
                }
                catch (JSchException ex) {}
            }
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(SSHKeyFileChooser.class, (String)"SSHKeyFileChooser.SSHKeyFileType.text");
        }
    }
}

