/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.AID;
import com.sun.javacard.filemodels.DeploymentXmlAppletEntry;
import com.sun.javacard.filemodels.DeploymentXmlInstanceEntry;
import com.sun.javacard.filemodels.DeploymentXmlModel;
import com.sun.javacard.nbtasks.JCInstallerTask;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTask
extends JCInstallerTask {
    private String instanceID;
    private File instancesFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        if (this.isWebApplication()) {
            this.validateInstanceID();
        } else {
            this.validateInstancesFile();
        }
        if (this.isWebApplication()) {
            this.createArg().setValue("delete");
            if (this.instanceID != null) {
                this.createArg().setValue("--instance");
                this.createArg().setValue(this.instanceID);
            }
            super.execute();
        } else {
            try {
                DeploymentXmlModel mdl;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.instancesFile));
                try {
                    mdl = new DeploymentXmlModel((InputStream)in);
                }
                finally {
                    in.close();
                }
                for (DeploymentXmlAppletEntry e : mdl.getData()) {
                    AID aid = e.getAppletAid();
                    this.deleteForOneApplet(aid, e.getData());
                }
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
    }

    private void deleteForOneApplet(AID appletAID, List<? extends DeploymentXmlInstanceEntry> instances) throws BuildException {
        for (DeploymentXmlInstanceEntry deploymentXmlInstanceEntry : instances) {
            String deployParams = deploymentXmlInstanceEntry.getDeploymentParams();
            AID instanceAID = deploymentXmlInstanceEntry.getInstanceAID();
            this.deleteOneInstanceForOneApplet(appletAID, instanceAID, deployParams);
        }
    }

    private void deleteOneInstanceForOneApplet(AID appletAID, AID instanceAID, String deployParams) throws BuildException {
        String applet_ID = appletAID.toString();
        String instance_ID = instanceAID.toString();
        String data = deployParams.trim();
        if (data.length() <= 0) {
            data = null;
        }
        super.clearArgs();
        this.createArg().setValue("delete");
        if (instance_ID != null) {
            this.createArg().setValue("--instance");
            this.createArg().setValue(instance_ID);
        }
        super.execute();
    }

    private void validateInstanceID() throws BuildException {
        if (this.instanceID == null) {
            this.instanceID = this.getProject().getProperty("webcontextpath");
        }
        if (this.instanceID == null) {
            throw new BuildException("InstanceID value not specified");
        }
        this.instanceID = this.instanceID.trim();
        if (this.instanceID.length() <= 0) {
            throw new BuildException("Empty value for InstanceID");
        }
    }

    private void validateInstancesFile() {
        if (this.instancesFile == null) {
            this.instancesFile = new File(this.getProject().getBaseDir(), "nbproject" + File.separatorChar + "deployment.xml");
        }
        if (!this.instancesFile.exists()) {
            throw new BuildException(this.instancesFile.getPath() + " does not exist");
        }
        if (!this.instancesFile.isFile()) {
            throw new BuildException(this.instancesFile.getPath() + " is not a regular file");
        }
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public void setInstanceID(String instanceID) {
        this.instanceID = instanceID;
    }
}

