/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.dwarfdump.Offset2LineService;
import org.netbeans.modules.cnd.gizmo.RemoteJarServiceProvider;
import org.netbeans.modules.dlight.management.remote.spi.PathMapper;
import org.netbeans.modules.dlight.management.remote.spi.PathMapperProvider;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.api.RemoteBinaryService;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class DwarfSourceInfoProvider
implements SourceFileInfoProvider {
    private static final RequestProcessor RP = new RequestProcessor("ReadErrorStream", 2);
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.gizmo.dwarf");
    private WeakHashMap<String, Map<String, Offset2LineService.AbstractFunctionToLine>> cache = new WeakHashMap();

    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(String functionQName, int lineNumber, long offset, Map<String, String> serviceInfo) {
        String remote;
        PathMapper pathMapper;
        String env;
        PathMapperProvider provider;
        SourceFileInfoProvider.SourceFileInfo info = this._fileName(functionQName, lineNumber, offset, serviceInfo);
        if (info != null && (provider = (PathMapperProvider)Lookup.getDefault().lookup(PathMapperProvider.class)) != null && (env = serviceInfo.get("service.storage.execution.env.key")) != null && (pathMapper = provider.getPathMapper(ExecutionEnvironmentFactory.fromUniqueID((String)env))) != null && (remote = pathMapper.getLocalPath(info.getFileName())) != null) {
            return new SourceFileInfoProvider.SourceFileInfo((CharSequence)remote, info.getLine(), 0);
        }
        return info;
    }

    private synchronized SourceFileInfoProvider.SourceFileInfo _fileName(String functionQName, int lineNumber, long offset, Map<String, String> serviceInfo) {
        if (serviceInfo == null) {
            return null;
        }
        ExecutionEnvironment execEnv = ExecutionEnvironmentFactory.fromUniqueID((String)serviceInfo.get("service.storage.execution.env.key"));
        String executable = null;
        if (execEnv.isLocal()) {
            executable = serviceInfo.get("GizmoProjectExecutable");
        } else {
            String executableID;
            RemoteBinaryService.RemoteBinaryID id;
            Future remoteSyncResult;
            String remoteExecutable = serviceInfo.get("GizmoProjectRemoteExecutable");
            if (remoteExecutable != null) {
                Map<String, Offset2LineService.AbstractFunctionToLine> sourceInfoMap;
                if (this.cache.containsKey(remoteExecutable)) {
                    sourceInfoMap = this.cache.get(remoteExecutable);
                    if (sourceInfoMap != null) {
                        return this.findSourceInfo(sourceInfoMap, functionQName, lineNumber, offset);
                    }
                } else {
                    sourceInfoMap = this.getOffsets(execEnv, remoteExecutable);
                    if (sourceInfoMap != null) {
                        this.cache.put(remoteExecutable, sourceInfoMap.isEmpty() ? Collections.emptyMap() : sourceInfoMap);
                        return this.findSourceInfo(sourceInfoMap, functionQName, lineNumber, offset);
                    }
                    this.cache.put(remoteExecutable, null);
                }
            }
            if ((remoteSyncResult = RemoteBinaryService.getResult((RemoteBinaryService.RemoteBinaryID)(id = RemoteBinaryService.RemoteBinaryID.fromIDString((String)(executableID = serviceInfo.get("GizmoProjectExecutable")))))) != null && remoteSyncResult.isDone()) {
                try {
                    if (((Boolean)remoteSyncResult.get()).booleanValue()) {
                        executable = RemoteBinaryService.getFileName((RemoteBinaryService.RemoteBinaryID)id);
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    // empty catch block
                }
            }
        }
        if (executable != null) {
            return this.findSourceInfo(this.getSourceInfo(executable), functionQName, lineNumber, offset);
        }
        return null;
    }

    private SourceFileInfoProvider.SourceFileInfo findSourceInfo(Map<String, Offset2LineService.AbstractFunctionToLine> sourceInfoMap, String functionQName, int lineNumber, long offset) {
        logger.log(Level.FINE, "Search for:{0}+{1}", new Object[]{functionQName, offset});
        Offset2LineService.AbstractFunctionToLine fl = sourceInfoMap.get(functionQName);
        if (fl != null) {
            Offset2LineService.SourceLineInfo sourceInfo = fl.getLine((int)offset);
            logger.log(Level.FINE, "Found:{0}", fl);
            logger.log(Level.FINE, "Line:{0}", sourceInfo);
            if (lineNumber > 0 && sourceInfo != null) {
                return new SourceFileInfoProvider.SourceFileInfo((CharSequence)sourceInfo.getFileName(), lineNumber, 0);
            }
            return new SourceFileInfoProvider.SourceFileInfo((CharSequence)sourceInfo.getFileName(), sourceInfo.getLine(), 0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Offset2LineService.AbstractFunctionToLine> getOffsets(ExecutionEnvironment execEnv, String executable) {
        NativeProcess process = null;
        RequestProcessor.Task errorTask = null;
        try {
            process = RemoteJarServiceProvider.getJavaProcess(Offset2LineService.class, execEnv, new String[]{executable});
            if (process.getState() != NativeProcess.State.ERROR) {
                final NativeProcess startedProcess = process;
                final ArrayList errors = new ArrayList();
                errorTask = RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            errors.addAll(ProcessUtils.readProcessError((Process)startedProcess));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));
                Map res = Offset2LineService.getOffset2Line((BufferedReader)out);
                int rc = process.waitFor();
                logger.log(Level.FINE, "Return code {0}", rc);
                boolean hasException = false;
                for (String error : errors) {
                    if (error.indexOf("Exception") >= 0) {
                        hasException = true;
                    }
                    logger.log(Level.INFO, error);
                }
                if (rc == 0 && !hasException) {
                    logger.log(Level.FINE, "Loaded lines info for {0} functions from executable file {1}", new Object[]{res.size(), executable});
                    Map map = res;
                    return map;
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.INFO, ex.getMessage(), ex);
        }
        catch (InterruptedException ex) {
        }
        catch (Throwable ex) {
            logger.log(Level.INFO, ex.getMessage(), ex);
        }
        finally {
            if (errorTask != null) {
                errorTask.cancel();
            }
            if (process != null) {
                process.destroy();
            }
        }
        return null;
    }

    private synchronized Map<String, Offset2LineService.AbstractFunctionToLine> getSourceInfo(String executable) {
        Map sourceInfoMap = this.cache.get(executable);
        if (sourceInfoMap == null) {
            try {
                sourceInfoMap = Offset2LineService.getOffset2Line((String)executable);
                logger.log(Level.FINE, "Loaded lines info for {0} functions from executable file {1}", new Object[]{sourceInfoMap.size(), executable});
            }
            catch (FileNotFoundException ex) {
                DLightLogger.instance.log(Level.INFO, ex.getMessage(), ex);
                sourceInfoMap = Collections.emptyMap();
            }
            catch (IOException ex) {
                DLightLogger.instance.log(Level.INFO, ex.getMessage());
                sourceInfoMap = Collections.emptyMap();
            }
            catch (Throwable ex) {
                DLightLogger.instance.log(Level.INFO, ex.getMessage(), ex);
                sourceInfoMap = Collections.emptyMap();
            }
            this.cache.put(executable, sourceInfoMap.isEmpty() ? Collections.emptyMap() : sourceInfoMap);
        }
        return sourceInfoMap;
    }
}

