/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.environment;

import java.lang.reflect.Method;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.environment.IOSEnvironmentReader;
import org.jruby.nb.environment.OSEnvironment;

class OSEnvironmentReaderFromJava5SystemGetenv
implements IOSEnvironmentReader {
    OSEnvironmentReaderFromJava5SystemGetenv() {
    }

    protected Method getSystemGetenvMethod() {
        Method getenvMethod = null;
        try {
            getenvMethod = System.class.getMethod("getenv", null);
            if (!getenvMethod.getReturnType().equals(Map.class)) {
                getenvMethod = null;
            }
        }
        catch (NoSuchMethodException e) {
            getenvMethod = null;
        }
        catch (Exception e) {
            getenvMethod = null;
        }
        return getenvMethod;
    }

    @Override
    public boolean isAccessible(Ruby runtime) {
        return this.getSystemGetenvMethod() != null;
    }

    @Override
    public Map getVariables(Ruby runtime) {
        Map returnMap = null;
        Method getenvMethod = this.getSystemGetenvMethod();
        try {
            if (getenvMethod != null) {
                returnMap = (Map)getenvMethod.invoke(null, (Object[])null);
            }
        }
        catch (Exception e) {
            new OSEnvironment().handleException(e);
        }
        return returnMap;
    }

    public static void main(String[] args) {
        OSEnvironmentReaderFromJava5SystemGetenv getenv = new OSEnvironmentReaderFromJava5SystemGetenv();
        Map envs = getenv.getVariables(null);
        for (Map.Entry entry : envs.entrySet()) {
            System.out.println(entry.getKey() + ":" + entry.getValue());
        }
        System.out.println();
    }
}

