/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfIndex;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.openide.util.NbBundle;

public class CompositeComponentLibrary
extends FaceletsLibrary {
    private String libraryName;
    private LibraryDescriptor generatedDescribingLibrary;

    public CompositeComponentLibrary(FaceletsLibrarySupport faceletsLibrarySupport, String string) {
        this(faceletsLibrarySupport, string, null);
    }

    public CompositeComponentLibrary(FaceletsLibrarySupport faceletsLibrarySupport, String string, String string2) {
        super(faceletsLibrarySupport, string2);
        this.libraryName = string;
    }

    @Override
    public String getNamespace() {
        return this.getDeclaredNamespace() != null ? this.getDeclaredNamespace() : this.getDefaultNamespace();
    }

    public String getDeclaredNamespace() {
        return super.getNamespace();
    }

    public String getDefaultNamespace() {
        return JsfUtils.getCompositeLibraryURL(this.getLibraryName());
    }

    @Override
    public String getDisplayName() {
        return this.getLibraryName();
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public Collection<FaceletsLibrary.NamedComponent> getComponents() {
        Collection<String> collection = this.index().getCompositeLibraryComponents(this.getLibraryName());
        ArrayList<FaceletsLibrary.NamedComponent> arrayList = new ArrayList<FaceletsLibrary.NamedComponent>();
        for (String string : collection) {
            CompositeComponent compositeComponent = new CompositeComponent(string);
            arrayList.add(compositeComponent);
        }
        return arrayList;
    }

    @Override
    public LibraryDescriptor getLibraryDescriptor() {
        LibraryDescriptor libraryDescriptor = this.support.getJsfSupport().getLibraryDescriptor(this.getNamespace());
        if (libraryDescriptor != null) {
            return libraryDescriptor;
        }
        this.generatedDescribingLibrary = new CCTldLibrary();
        return this.generatedDescribingLibrary;
    }

    @Override
    public String toString() {
        return "CompositeComponent(" + (this.getNamespace() == null ? "created via indexing" : "created by Mojarra") + " " + super.toString();
    }

    private JsfIndex index() {
        return this.support.getJsfSupport().getIndex();
    }

    private class CCTldLibrary
    extends LibraryDescriptor {
        private Map<String, LibraryDescriptor.Tag> cctags = new HashMap<String, LibraryDescriptor.Tag>();
        private String virtualLibraryPrefix;

        public CCTldLibrary() {
            this.init();
        }

        @Override
        protected void parseLibrary(InputStream inputStream) throws LibraryDescriptorException {
        }

        @Override
        public String getDefaultPrefix() {
            return this.virtualLibraryPrefix != null ? this.virtualLibraryPrefix : super.getDefaultPrefix();
        }

        private void init() {
            Collection<String> collection = CompositeComponentLibrary.this.index().getCompositeLibraryComponents(CompositeComponentLibrary.this.getLibraryName());
            for (String string : collection) {
                Object object3;
                CompositeComponentModel compositeComponentModel = CompositeComponentLibrary.this.index().getCompositeComponentModel(CompositeComponentLibrary.this.getLibraryName(), string);
                if (compositeComponentModel == null) {
                    return;
                }
                String string2 = compositeComponentModel.getRelativePath();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
                LinkedList<String> linkedList = new LinkedList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    linkedList.add(stringTokenizer.nextToken());
                }
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    object3 = (String)iterator.next();
                    if ("resources".equalsIgnoreCase((String)object3)) {
                        iterator.remove();
                        break;
                    }
                    iterator.remove();
                }
                assert (linkedList.size() >= 2);
                linkedList.removeLast();
                if (linkedList.size() == 1) {
                    this.virtualLibraryPrefix = (String)linkedList.peek();
                } else {
                    object3 = new StringBuilder();
                    for (String string3 : linkedList) {
                        ((StringBuilder)object3).append(string3.charAt(0));
                    }
                    this.virtualLibraryPrefix = ((StringBuilder)object3).toString();
                }
                object3 = new HashMap();
                String string3 = NbBundle.getBundle(CompositeComponentLibrary.class).getString("MSG_NO_DESCRIPTOR");
                for (Map<String, String> map : compositeComponentModel.getExistingInterfaceAttributes()) {
                    String string4 = map.get("name");
                    boolean bl = Boolean.parseBoolean(map.get("required"));
                    String string5 = this.getAttributesDescription(compositeComponentModel, true);
                    object3.put(string4, new LibraryDescriptor.Attribute(string4, string5, bl));
                }
                StringBuffer object22 = new StringBuffer();
                object22.append("<p><b>");
                object22.append(NbBundle.getMessage(CompositeComponentLibrary.class, (String)"MSG_COMPOSITE_COMPONENT_SOURCE"));
                object22.append("</b>");
                object22.append("&nbsp;");
                object22.append(string2);
                object22.append("</p>");
                object22.append("<p>");
                object22.append(this.getAttributesDescription(compositeComponentModel, false));
                object22.append("</p>");
                object22.append("<p style=\"color: red\">" + (String)string3 + "</p>");
                LibraryDescriptor.TagImpl tagImpl = new LibraryDescriptor.TagImpl(string, object22.toString(), (Map<String, LibraryDescriptor.Attribute>)object3);
                this.cctags.put(string, tagImpl);
            }
        }

        private String getAttributesDescription(CompositeComponentModel compositeComponentModel, boolean bl) {
            if (compositeComponentModel.getExistingInterfaceAttributes().isEmpty()) {
                return NbBundle.getMessage(CompositeComponentLibrary.class, (String)"MSG_NO_TAG_ATTRS");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<b>");
            stringBuffer.append(NbBundle.getMessage(CompositeComponentLibrary.class, (String)"MSG_TAG_ATTRS"));
            stringBuffer.append("</b>");
            stringBuffer.append("<table border=\"1\">");
            for (Map<String, String> map : compositeComponentModel.getExistingInterfaceAttributes()) {
                stringBuffer.append("<tr>");
                stringBuffer.append("<td>");
                stringBuffer.append("<div style=\"font-weight: bold\">");
                String string = map.get("name");
                stringBuffer.append(string);
                stringBuffer.append("</div>");
                stringBuffer.append("</td>");
                if (map.size() > 1) {
                    stringBuffer.append("<td>");
                    stringBuffer.append("<table border=\"0\" padding=\"0\" margin=\"0\" spacing=\"2\">");
                    for (String string2 : map.keySet()) {
                        if (string2.equals("name")) continue;
                        String string3 = map.get(string2);
                        stringBuffer.append("<tr><td><b>");
                        stringBuffer.append(string2);
                        stringBuffer.append("</b></td><td>");
                        stringBuffer.append(string3);
                        stringBuffer.append("</td></tr>");
                    }
                    stringBuffer.append("</table>");
                    stringBuffer.append("</td>");
                }
                stringBuffer.append("</tr>");
            }
            stringBuffer.append("</table>");
            if (bl) {
                String string = NbBundle.getBundle(CompositeComponentLibrary.class).getString("MSG_NO_DESCRIPTOR");
                stringBuffer.append("<p style=\"color: red\">" + (String)string + "</p>");
            }
            return stringBuffer.toString();
        }

        @Override
        public Map<String, LibraryDescriptor.Tag> getTags() {
            return this.cctags;
        }
    }

    public class CompositeComponent
    extends FaceletsLibrary.NamedComponent {
        public CompositeComponent(String string) {
            super(CompositeComponentLibrary.this, string);
        }

        public CompositeComponentModel getComponentModel() {
            return CompositeComponentLibrary.this.index().getCompositeComponentModel(CompositeComponentLibrary.this.getLibraryName(), this.name);
        }
    }
}

