/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;

public class BreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{CndBreakpoint.class.getName()};
    }

    public Object read(String typeID, Properties properties) {
        CndBreakpoint b = null;
        if (typeID.equals(LineBreakpoint.class.getName()) || typeID.equals(LineBreakpoint.class.getName() + "$LineBreakpointComparable")) {
            LineBreakpoint lb = LineBreakpoint.create(properties.getString("url", null), properties.getInt("lineNumber", 1));
            b = lb;
        }
        if (typeID.equals(FunctionBreakpoint.class.getName()) || typeID.equals(FunctionBreakpoint.class.getName() + "$FunctionBreakpointComparable")) {
            FunctionBreakpoint fb = FunctionBreakpoint.create(properties.getString("functionName", ""));
            fb.setBreakpointType(properties.getInt("breakpointType", 1));
            b = fb;
        }
        if (typeID.equals(AddressBreakpoint.class.getName()) || typeID.equals(AddressBreakpoint.class.getName() + "$AddressBreakpointComparable")) {
            AddressBreakpoint ab = AddressBreakpoint.create(properties.getString("address", ""));
            b = ab;
        }
        b.setCondition(properties.getString("condition", ""));
        b.setSkipCount(properties.getInt("skipCount", 0));
        b.setPrintText(properties.getString("printText", ""));
        b.setGroupName(properties.getString("groupName", ""));
        b.setSuspend(properties.getInt("suspend", 2), properties.getString("threadID", "1"));
        if (properties.getBoolean("enabled", true)) {
            b.enable();
        } else {
            b.disable();
        }
        return b;
    }

    public void write(Object object, Properties properties) {
        CndBreakpoint b = (CndBreakpoint)((Object)object);
        properties.setString("printText", b.getPrintText());
        properties.setString("groupName", b.getGroupName());
        properties.setInt("suspend", b.getSuspend());
        properties.setString("threadID", b.getThreadID());
        properties.setBoolean("enabled", b.isEnabled());
        properties.setString("condition", b.getCondition());
        properties.setInt("skipCount", b.getSkipCount());
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)((Object)object);
            properties.setString("url", lb.getURL());
            properties.setInt("lineNumber", lb.getLineNumber());
        } else if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint fb = (FunctionBreakpoint)((Object)object);
            properties.setString("functionName", fb.getFunctionName());
            properties.setInt("breakpointType", fb.getBreakpointType());
        } else if (object instanceof AddressBreakpoint) {
            AddressBreakpoint fb = (AddressBreakpoint)object;
            properties.setString("address", fb.getAddress());
        }
    }
}

