/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.listeners;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeGlobalLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeMultiGuardedLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeReferencePresenter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.sources.CommandEventSourceCD;
import org.netbeans.modules.vmd.midp.components.sources.ItemCommandEventSourceCD;

class EventListenerCode {
    EventListenerCode() {
    }

    private static ExpressionTree findImplementIdentifier(Trees trees, TreePath treePath, String string) {
        ClassTree classTree = (ClassTree)treePath.getLeaf();
        for (Tree tree : classTree.getImplementsClause()) {
            Element element = trees.getElement(new TreePath(treePath, tree));
            if (!EventListenerCode.equalsElementWithFQN(element, string)) continue;
            return (ExpressionTree)tree;
        }
        return null;
    }

    private static boolean equalsElementWithFQN(Element element, String string) {
        TypeElement typeElement;
        return (element.getKind().isInterface() || element.getKind().isClass()) && (typeElement = (TypeElement)element).getQualifiedName().contentEquals(string);
    }

    public static class CodeItemCommandListenerPresenter
    extends CodeClassLevelPresenter.Adapter {
        protected void generateClassBodyCode(StyledDocument styledDocument) {
            List list = DocumentSupport.gatherAllComponentsOfTypeID((DesignDocument)this.getComponent().getDocument(), (TypeID)ItemCommandEventSourceCD.TYPEID);
            if (list.size() == 0) {
                return;
            }
            MultiGuardedSection multiGuardedSection = MultiGuardedSection.create((StyledDocument)styledDocument, (String)(this.getComponent().getComponentID() + "-itemCommandAction"));
            multiGuardedSection.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Method: commandAction for Items \">\n");
            multiGuardedSection.getWriter().write("/**\n * Called by a system to indicated that a command has been invoked on a particular item.\n * @param command the Command that was invoked\n * @param displayable the Item where the command was invoked\n */\n");
            multiGuardedSection.getWriter().write("public void commandAction (Command command, Item item) {\n").commit();
            multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-preItemCommandAction");
            multiGuardedSection.getWriter().write(" // write pre-action user code here\n").commit();
            multiGuardedSection.switchToGuarded();
            this.resolveFirstLevel(multiGuardedSection, list);
            multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-postItemCommandAction");
            multiGuardedSection.getWriter().write(" // write post-action user code here\n").commit();
            multiGuardedSection.switchToGuarded();
            multiGuardedSection.getWriter().write("}\n");
            multiGuardedSection.getWriter().write("//</editor-fold>\n").commit();
            multiGuardedSection.close();
        }

        private void resolveFirstLevel(MultiGuardedSection multiGuardedSection, List<DesignComponent> list) {
            HashMap<String, ArrayList<DesignComponent>> hashMap = this.gatherItems(list);
            ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
            Collections.sort(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                if (i > 0) {
                    multiGuardedSection.getWriter().write("else ");
                }
                multiGuardedSection.getWriter().write("if (item == " + string + ") {\n");
                this.resolveSecondLevel(multiGuardedSection, (List<DesignComponent>)hashMap.get(string));
                assert (multiGuardedSection.isGuarded());
                if (i < arrayList.size() - 1) {
                    multiGuardedSection.getWriter().write("} ");
                    continue;
                }
                multiGuardedSection.getWriter().write("}\n");
            }
            multiGuardedSection.getWriter().commit();
        }

        private void resolveSecondLevel(MultiGuardedSection multiGuardedSection, List<DesignComponent> list) {
            HashMap<String, ArrayList<DesignComponent>> hashMap = this.gatherCommands(list);
            ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
            Collections.sort(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                if (i > 0) {
                    multiGuardedSection.getWriter().write("else ");
                }
                multiGuardedSection.getWriter().write("if (command == " + string + ") {\n");
                for (DesignComponent designComponent : hashMap.get(string)) {
                    CodeMultiGuardedLevelPresenter.generateMultiGuardedSectionCode((MultiGuardedSection)multiGuardedSection, (DesignComponent)designComponent);
                }
                assert (multiGuardedSection.isGuarded());
                if (i < arrayList.size() - 1) {
                    multiGuardedSection.getWriter().write("} ");
                    continue;
                }
                multiGuardedSection.getWriter().write("}\n");
            }
        }

        private HashMap<String, ArrayList<DesignComponent>> gatherItems(List<DesignComponent> list) {
            HashMap<String, ArrayList<DesignComponent>> hashMap = new HashMap<String, ArrayList<DesignComponent>>();
            for (DesignComponent designComponent : list) {
                String string = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)ItemCommandEventSourceCD.getItemComponent(designComponent));
                ArrayList<Object> arrayList = hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(designComponent);
            }
            return hashMap;
        }

        private HashMap<String, ArrayList<DesignComponent>> gatherCommands(List<DesignComponent> list) {
            HashMap<String, ArrayList<DesignComponent>> hashMap = new HashMap<String, ArrayList<DesignComponent>>();
            for (DesignComponent designComponent : list) {
                String string = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)designComponent.readProperty("command").getComponent());
                ArrayList<Object> arrayList = hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(designComponent);
            }
            return hashMap;
        }
    }

    public static class CodeCommandListenerPresenter
    extends CodeClassLevelPresenter.Adapter {
        protected void generateClassBodyCode(StyledDocument styledDocument) {
            List list = DocumentSupport.gatherAllComponentsOfTypeID((DesignDocument)this.getComponent().getDocument(), (TypeID)CommandEventSourceCD.TYPEID);
            if (list.size() == 0) {
                return;
            }
            MultiGuardedSection multiGuardedSection = MultiGuardedSection.create((StyledDocument)styledDocument, (String)(this.getComponent().getComponentID() + "-commandAction"));
            multiGuardedSection.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Method: commandAction for Displayables \">\n");
            multiGuardedSection.getWriter().write("/**\n * Called by a system to indicated that a command has been invoked on a particular displayable.\n * @param command the Command that was invoked\n * @param displayable the Displayable where the command was invoked\n */\n");
            multiGuardedSection.getWriter().write("public void commandAction (Command command, Displayable displayable) {\n").commit();
            multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-preCommandAction");
            multiGuardedSection.getWriter().write(" // write pre-action user code here\n").commit();
            multiGuardedSection.switchToGuarded();
            this.resolveFirstLevel(multiGuardedSection, list);
            multiGuardedSection.switchToEditable(this.getComponent().getComponentID() + "-postCommandAction");
            multiGuardedSection.getWriter().write(" // write post-action user code here\n").commit();
            multiGuardedSection.switchToGuarded();
            multiGuardedSection.getWriter().write("}\n");
            multiGuardedSection.getWriter().write("//</editor-fold>\n").commit();
            multiGuardedSection.close();
        }

        private void resolveFirstLevel(MultiGuardedSection multiGuardedSection, List<DesignComponent> list) {
            HashMap<String, ArrayList<DesignComponent>> hashMap = this.gatherDisplayables(list);
            ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
            Collections.sort(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                if (i > 0) {
                    multiGuardedSection.getWriter().write("else ");
                }
                multiGuardedSection.getWriter().write("if (displayable == " + string + ") {\n");
                this.resolveSecondLevel(multiGuardedSection, (List<DesignComponent>)hashMap.get(string));
                assert (multiGuardedSection.isGuarded());
                if (i < arrayList.size() - 1) {
                    multiGuardedSection.getWriter().write("} ");
                    continue;
                }
                multiGuardedSection.getWriter().write("}\n");
            }
            multiGuardedSection.getWriter().commit();
        }

        private void resolveSecondLevel(MultiGuardedSection multiGuardedSection, List<DesignComponent> list) {
            HashMap<String, ArrayList<DesignComponent>> hashMap = this.gatherCommands(list);
            ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
            Collections.sort(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                if (i > 0) {
                    multiGuardedSection.getWriter().write("else ");
                }
                multiGuardedSection.getWriter().write("if (command == " + string + ") {\n");
                for (DesignComponent designComponent : hashMap.get(string)) {
                    CodeMultiGuardedLevelPresenter.generateMultiGuardedSectionCode((MultiGuardedSection)multiGuardedSection, (DesignComponent)designComponent);
                }
                assert (multiGuardedSection.isGuarded());
                if (i < arrayList.size() - 1) {
                    multiGuardedSection.getWriter().write("} ");
                    continue;
                }
                multiGuardedSection.getWriter().write("}\n");
            }
        }

        private HashMap<String, ArrayList<DesignComponent>> gatherDisplayables(List<DesignComponent> list) {
            HashMap<String, ArrayList<DesignComponent>> hashMap = new HashMap<String, ArrayList<DesignComponent>>();
            for (DesignComponent designComponent : list) {
                String string = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)designComponent.readProperty("displayable").getComponent());
                ArrayList<Object> arrayList = hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(designComponent);
            }
            return hashMap;
        }

        private HashMap<String, ArrayList<DesignComponent>> gatherCommands(List<DesignComponent> list) {
            HashMap<String, ArrayList<DesignComponent>> hashMap = new HashMap<String, ArrayList<DesignComponent>>();
            for (DesignComponent designComponent : list) {
                String string = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)designComponent.readProperty("command").getComponent());
                ArrayList<Object> arrayList = hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(designComponent);
            }
            return hashMap;
        }
    }

    private static class ContainsMethodTreeVisitor
    extends TreePathScanner<Void, Void> {
        private Trees trees;
        private String methodName;
        private String[] parameters;
        private boolean isFirstLevel;
        private TreePath classTreePath;
        private boolean methodExists;

        public ContainsMethodTreeVisitor(Trees trees, String string, String ... stringArray) {
            this.trees = trees;
            this.methodName = string;
            this.parameters = stringArray;
            this.methodExists = false;
            this.isFirstLevel = false;
        }

        public boolean isMethodExists() {
            return this.methodExists;
        }

        public TreePath getClassTreePath() {
            return this.classTreePath;
        }

        @Override
        public Void visitClass(ClassTree classTree, Void void_) {
            if (!this.isFirstLevel) {
                this.isFirstLevel = true;
                if (classTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
                    this.classTreePath = this.getCurrentPath();
                    return (Void)super.visitClass(classTree, void_);
                }
                this.isFirstLevel = false;
            }
            return null;
        }

        @Override
        public Void visitMethod(MethodTree methodTree, Void void_) {
            List<? extends VariableTree> list;
            if (methodTree.getName().contentEquals(this.methodName) && this.parameters.length == (list = methodTree.getParameters()).size()) {
                boolean bl = true;
                for (int i = 0; i < this.parameters.length; ++i) {
                    Tree tree = list.get(i).getType();
                    TreePath treePath = new TreePath(this.getCurrentPath(), tree);
                    Element element = this.trees.getElement(treePath);
                    if (EventListenerCode.equalsElementWithFQN(element, this.parameters[i])) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.methodExists = true;
                }
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void void_) {
            return null;
        }
    }

    static class CodeImplementsPresenter
    extends CodeGlobalLevelPresenter {
        private String className;
        private String methodName;
        private String[] parameters;

        public CodeImplementsPresenter(String string, String string2, String ... stringArray) {
            this.className = string;
            this.methodName = string2;
            this.parameters = stringArray;
        }

        protected void performGlobalGeneration(StyledDocument styledDocument) {
            JavaSource javaSource = JavaSource.forDocument((Document)styledDocument);
            try {
                ModificationResult modificationResult = javaSource.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws Exception {
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                        TreeMaker treeMaker = workingCopy.getTreeMaker();
                        Trees trees = workingCopy.getTrees();
                        ContainsMethodTreeVisitor containsMethodTreeVisitor = new ContainsMethodTreeVisitor(trees, CodeImplementsPresenter.this.methodName, CodeImplementsPresenter.this.parameters);
                        containsMethodTreeVisitor.scan(compilationUnitTree, null);
                        TreePath treePath = containsMethodTreeVisitor.getClassTreePath();
                        if (treePath != null) {
                            ExpressionTree expressionTree = EventListenerCode.findImplementIdentifier(trees, treePath, CodeImplementsPresenter.this.className);
                            if (containsMethodTreeVisitor.isMethodExists()) {
                                if (expressionTree == null) {
                                    TypeElement typeElement = workingCopy.getElements().getTypeElement(CodeImplementsPresenter.this.className);
                                    ExpressionTree expressionTree2 = typeElement != null ? treeMaker.QualIdent((Element)typeElement) : treeMaker.Identifier((CharSequence)CodeImplementsPresenter.this.className);
                                    ClassTree classTree = (ClassTree)treePath.getLeaf();
                                    ClassTree classTree2 = treeMaker.addClassImplementsClause(classTree, (Tree)expressionTree2);
                                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                                }
                            } else if (expressionTree != null) {
                                ClassTree classTree = (ClassTree)treePath.getLeaf();
                                ClassTree classTree3 = treeMaker.removeClassImplementsClause(classTree, (Tree)expressionTree);
                                workingCopy.rewrite((Tree)classTree, (Tree)classTree3);
                            }
                        }
                    }
                });
                modificationResult.commit();
            }
            catch (IOException iOException) {
                throw Debug.error((Object[])new Object[]{iOException});
            }
        }
    }
}

