/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NameAndLocationWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.SelectLibraryWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

final class NewLibraryDescriptor
implements WizardDescriptor.InstantiatingIterator {
    private static final String WIZARD_TITLE = "LBL_LibraryWizardTitle";
    private static final String LIB_STEPS_COUNT = "LBL_LibWizardStepsCount";
    public static final String LIBRARY_STEP = "LBL_LibSelectLibraryStep";
    public static final String NAME_LOCATION_STEP = "LBL_LibNameAndLocationStep";
    public static final String LIBRARY = "library";
    public static final String DISPLAY_NAME = "displayName";
    public static final String LIB_NAME = "libName";
    public static final String EXISTING_LIBRARIES = "existLibrary";
    public static final String EXISTING_LIB_NAMES = "existLibName";
    public static final String LIBRARY_TYPE_J2SE = "j2se";
    private int myCurrentIndex;
    private WizardDescriptor.Panel[] myPanels;
    private WizardDescriptor myWizard;
    private WizardDescriptor myMainWizard;

    NewLibraryDescriptor(WizardDescriptor wizardDescriptor) {
        this.myMainWizard = wizardDescriptor;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.myWizard = wizardDescriptor;
        this.myCurrentIndex = 0;
        this.myPanels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.myPanels.length; ++i) {
            Component component = this.myPanels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
        wizardDescriptor.setTitle(NbBundle.getMessage(NewLibraryDescriptor.class, (String)WIZARD_TITLE));
        wizardDescriptor.putProperty("projName", this.myMainWizard.getProperty("projName"));
        wizardDescriptor.putProperty("codeBaseName", (Object)this.getCodeNameBase());
        wizardDescriptor.putProperty(EXISTING_LIB_NAMES, this.myMainWizard.getProperty("libNames"));
        wizardDescriptor.putProperty(EXISTING_LIBRARIES, this.myMainWizard.getProperty("libraries"));
    }

    public Set<?> instantiate() throws IOException {
        LinkedList<Object> linkedList;
        LinkedList<Object> linkedList2;
        LinkedList<Object> linkedList3 = (LinkedList<Object>)this.myMainWizard.getProperty("libraries");
        if (linkedList3 == null) {
            linkedList3 = new LinkedList<Object>();
            this.myMainWizard.putProperty("libraries", linkedList3);
        }
        if ((linkedList2 = (LinkedList<Object>)this.myMainWizard.getProperty("libNames")) == null) {
            linkedList2 = new LinkedList<Object>();
            this.myMainWizard.putProperty("libNames", linkedList2);
        }
        if ((linkedList = (LinkedList<Object>)this.myMainWizard.getProperty("libDisplayNames")) == null) {
            linkedList = new LinkedList<Object>();
            this.myMainWizard.putProperty("libDisplayNames", linkedList);
        }
        linkedList3.add(this.myWizard.getProperty(LIBRARY));
        linkedList2.add(this.myWizard.getProperty(LIB_NAME));
        linkedList.add(this.myWizard.getProperty(DISPLAY_NAME));
        return Collections.EMPTY_SET;
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.myWizard.putProperty(LIBRARY, null);
        this.myWizard.putProperty(LIB_NAME, null);
        this.myWizard.putProperty(DISPLAY_NAME, null);
        this.myWizard.putProperty("projName", null);
        this.myWizard.putProperty("codeBaseName", null);
        this.myWizard.putProperty(EXISTING_LIB_NAMES, null);
        this.myWizard.putProperty(EXISTING_LIBRARIES, null);
        this.myWizard = null;
        this.myPanels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.myPanels[this.myCurrentIndex];
    }

    public boolean hasNext() {
        return this.myCurrentIndex < this.myPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.myCurrentIndex > 0;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getBundle(NewLibraryDescriptor.class).getString(LIB_STEPS_COUNT), this.myCurrentIndex + 1, this.myPanels.length);
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.myCurrentIndex;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.myCurrentIndex;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new SelectLibraryWizardPanel(), new NameAndLocationWizardPanel()};
    }

    private String getCodeNameBase() {
        String string = (String)this.myMainWizard.getProperty("codeBaseName");
        String string2 = (String)this.myMainWizard.getProperty("projName");
        if (string == null) {
            string = BaseHelper.getDefaultCodeNameBase(string2);
        }
        return string;
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(NewLibraryDescriptor.class, (String)LIBRARY_STEP), NbBundle.getMessage(NewLibraryDescriptor.class, (String)NAME_LOCATION_STEP)};
    }
}

