/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.product;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreePath;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.RegistryType;
import org.netbeans.installer.product.filters.RegistryFilter;
import org.netbeans.installer.product.filters.TrueFilter;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.XMLUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.exceptions.FinalizationException;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.helper.ExtendedUri;
import org.netbeans.installer.utils.helper.NbiProperties;
import org.netbeans.installer.utils.helper.PropertyContainer;
import org.netbeans.installer.utils.helper.UiMode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegistryNode
implements PropertyContainer {
    protected RegistryNode parent;
    protected RegistryType registryType;
    protected String uid;
    protected ExtendedUri iconUri;
    protected Icon icon;
    protected long offset;
    protected boolean expand;
    protected boolean initialVisible = true;
    protected boolean currentVisible = true;
    protected Date built = new Date();
    protected Map<Locale, String> displayNames = new HashMap<Locale, String>();
    protected Map<Locale, String> descriptions = new HashMap<Locale, String>();
    protected List<RegistryNode> children = new ArrayList<RegistryNode>();
    protected NbiProperties properties = new NbiProperties();

    protected RegistryNode() {
    }

    public String getUid() {
        return this.uid;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return StringUtils.getLocalizedString(this.displayNames, locale);
    }

    public Map<Locale, String> getDisplayNames() {
        return this.displayNames;
    }

    public void setDisplayName(String displayName) {
        this.setDisplayName(Locale.getDefault(), displayName);
    }

    public void setDisplayName(Locale locale, String displayName) {
        this.displayNames.put(locale, displayName);
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        return StringUtils.getLocalizedString(this.descriptions, locale);
    }

    public Map<Locale, String> getDescriptions() {
        return this.descriptions;
    }

    public void setDescription(String description) {
        this.setDescription(Locale.getDefault(), description);
    }

    public void setDescription(Locale locale, String description) {
        this.descriptions.put(locale, description);
    }

    public ExtendedUri getIconUri() {
        return this.iconUri;
    }

    public Icon getIcon() {
        if (this.icon == null && UiMode.getCurrentUiMode() != UiMode.SILENT && this.getIconUri() != null && this.getIconUri().getLocal() != null) {
            this.icon = new ImageIcon(this.getIconUri().getLocal().getPath());
        }
        return this.icon;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean isVisible() {
        return this.currentVisible;
    }

    public void setVisible(boolean visible) {
        this.currentVisible = visible;
    }

    public boolean getExpand() {
        return this.expand;
    }

    public Date getBuildDate() {
        return this.built;
    }

    public RegistryType getRegistryType() {
        return this.registryType;
    }

    public void setRegistryType(RegistryType registryType) {
        this.registryType = registryType;
    }

    public RegistryNode getParent() {
        return this.parent;
    }

    public void setParent(RegistryNode parent) {
        this.parent = parent;
    }

    public List<RegistryNode> getChildren() {
        return this.children;
    }

    public List<RegistryNode> getVisibleChildren() {
        LinkedList<RegistryNode> visibleChildren = new LinkedList<RegistryNode>();
        for (RegistryNode child : this.children) {
            if (!child.isVisible()) continue;
            visibleChildren.add(child);
        }
        return visibleChildren;
    }

    public void addChild(RegistryNode child) {
        int i;
        child.setParent(this);
        for (i = 0; i < this.children.size() && this.children.get(i).getOffset() <= child.getOffset(); ++i) {
        }
        this.children.add(i, child);
    }

    public void removeChild(RegistryNode child) {
        this.children.remove(child);
    }

    public void attachRegistry(Registry registry) {
        for (RegistryNode node : registry.getRegistryRoot().getChildren()) {
            this.addChild(node);
        }
    }

    public boolean isAncestor(RegistryNode candidate) {
        for (RegistryNode node : this.getChildren()) {
            if (node != candidate && !node.isAncestor(candidate)) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestor(List<? extends RegistryNode> candidates) {
        for (RegistryNode registryNode : candidates) {
            if (!this.isAncestor(registryNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        return this.hasChildren(new TrueFilter());
    }

    public boolean hasChildren(RegistryFilter filter) {
        for (RegistryNode child : this.children) {
            if (filter.accept(child)) {
                return true;
            }
            if (!child.hasChildren(filter)) continue;
            return true;
        }
        return false;
    }

    public TreePath getTreePath() {
        LinkedList<RegistryNode> nodes = new LinkedList<RegistryNode>();
        for (RegistryNode node = this; node != null; node = node.getParent()) {
            nodes.add(0, node);
        }
        return new TreePath(nodes.toArray());
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public Element saveToDom(Document document, RegistryFilter filter) throws FinalizationException {
        boolean hasChilren = this.hasChildren(filter);
        if (filter.accept(this) || hasChilren) {
            Element element = this.saveToDom(document.createElement(this.getTagName()));
            if (hasChilren) {
                element.appendChild(this.saveChildrenToDom(document, filter));
            }
            return element;
        }
        return null;
    }

    public Element saveChildrenToDom(Document document, RegistryFilter filter) throws FinalizationException {
        Element components = null;
        if (this.hasChildren(filter)) {
            components = document.createElement("components");
            for (RegistryNode child : this.children) {
                if (!filter.accept(child) && !child.hasChildren(filter)) continue;
                components.appendChild(child.saveToDom(document, filter));
            }
        }
        return components;
    }

    protected String getTagName() {
        return "node";
    }

    protected Element saveToDom(Element element) throws FinalizationException {
        Document document = element.getOwnerDocument();
        element.setAttribute("uid", this.uid);
        element.setAttribute("offset", Long.toString(this.offset));
        element.setAttribute("expand", Boolean.toString(this.expand));
        element.setAttribute("visible", Boolean.toString(this.initialVisible));
        element.setAttribute("built", Long.toString(this.built.getTime()));
        element.appendChild(XMLUtils.saveLocalizedString(this.displayNames, document.createElement("display-name")));
        element.appendChild(XMLUtils.saveLocalizedString(this.descriptions, document.createElement("description")));
        element.appendChild(XMLUtils.saveExtendedUri(this.iconUri, document.createElement("icon")));
        if (this.properties.size() > 0) {
            element.appendChild(XMLUtils.saveNbiProperties(this.properties, document.createElement("properties")));
        }
        return element;
    }

    public RegistryNode loadFromDom(Element element) throws InitializationException {
        try {
            this.uid = element.getAttribute("uid");
            this.iconUri = XMLUtils.parseExtendedUri(XMLUtils.getChild(element, "icon"));
            if (!Boolean.getBoolean("nbi.product.lazy.load.icons")) {
                File iconFile = FileProxy.getInstance().getFile(this.iconUri.getRemote());
                this.iconUri.setLocal(iconFile.toURI());
            }
            this.offset = Long.parseLong(element.getAttribute("offset"));
            this.currentVisible = this.initialVisible = Boolean.parseBoolean(element.getAttribute("visible"));
            this.expand = Boolean.parseBoolean(element.getAttribute("expand"));
            this.built = new Date(Long.parseLong(element.getAttribute("built")));
            this.displayNames = XMLUtils.parseLocalizedString(XMLUtils.getChild(element, "display-name"));
            this.descriptions = XMLUtils.parseLocalizedString(XMLUtils.getChild(element, "description"));
            this.properties = XMLUtils.parseNbiProperties(XMLUtils.getChild(element, "properties"));
        }
        catch (ParseException e) {
            throw new InitializationException("Cannot deserialize product tree node", e);
        }
        catch (DownloadException e) {
            throw new InitializationException("Cannot deserialize product tree node", e);
        }
        catch (NumberFormatException e) {
            throw new InitializationException("Cannot deserialize product tree node", e);
        }
        return this;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

