/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.wizard.J2SEWizardIterator;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class DetectPanel
extends JPanel {
    private static final int COLS = 30;
    private static final RequestProcessor RP = new RequestProcessor(DetectPanel.class.getName(), 1, false, false);
    private NewJ2SEPlatform primaryPlatform;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField javadoc;
    private JTextField jdkName;
    private JLabel progressLabel;
    private JPanel progressPanel;
    private JTextField sources;

    public DetectPanel(NewJ2SEPlatform primaryPlatform) {
        this.initComponents();
        this.postInitComponents();
        this.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName")});
        this.primaryPlatform = primaryPlatform;
        this.setName(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName"));
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    private void postInitComponents() {
        this.jdkName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DetectPanel.this.handleNameChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DetectPanel.this.handleNameChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DetectPanel.this.handleNameChange();
            }
        });
        this.progressLabel.setVisible(false);
        this.progressPanel.setVisible(false);
    }

    private void handleNameChange() {
        this.cs.fireChange();
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jdkName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.javadoc = new JTextField();
        this.sources = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.progressLabel = new JLabel();
        this.progressPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.jdkName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_DetailsPanel_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jdkName, gridBagConstraints);
        this.jdkName.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformName"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.sources);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(DetectPanel.class).getString("TXT_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel4.setLabelFor(this.javadoc);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getBundle(DetectPanel.class).getString("TXT_JavaDoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.javadoc.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel1.add((Component)this.javadoc, gridBagConstraints);
        this.javadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformJavadoc"));
        this.sources.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.sources, gridBagConstraints);
        this.sources.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformSources"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_BrowseSources"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.selectSources(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_SelectSources"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_BrowseJavadoc"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.selectJavadoc(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        this.jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_SelectJavadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.progressLabel.setLabelFor(this.progressPanel);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/j2seplatform/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)bundle.getString("TXT_PlatfromDetectProgress"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.add((Component)this.progressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.progressPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_DetectPanel"));
    }

    private void selectJavadoc(ActionEvent evt) {
        String newValue = this.browse(this.javadoc.getText(), NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectJavadoc"));
        if (newValue != null) {
            this.javadoc.setText(newValue);
        }
    }

    private void selectSources(ActionEvent evt) {
        String newValue = this.browse(this.sources.getText(), NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectSources"));
        if (newValue != null) {
            this.sources.setText(newValue);
        }
    }

    public final synchronized void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public final synchronized void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    public String getPlatformName() {
        return this.jdkName.getText();
    }

    String getSources() {
        String val = this.sources.getText();
        return val.length() == 0 ? null : val;
    }

    void setSources(String sources) {
        this.sources.setText(sources == null ? "" : sources);
    }

    String getJavadoc() {
        String val = this.javadoc.getText();
        return val.length() == 0 ? null : val;
    }

    void setJavadoc(String jdoc) {
        this.javadoc.setText(jdoc == null ? "" : jdoc);
    }

    void updateData() {
        Map m = this.primaryPlatform.getSystemProperties();
        if ("".equals(this.jdkName.getText())) {
            this.jdkName.setText(DetectPanel.getInitialName(m));
            this.jdkName.selectAll();
        }
    }

    private static String getInitialName(Map<String, String> m) {
        String vmVersion = m.get("java.specification.version");
        StringBuilder result = new StringBuilder(NbBundle.getMessage(DetectPanel.class, (String)"TXT_DetectPanel_Java"));
        if (vmVersion != null) {
            result.append(vmVersion);
        }
        return result.toString();
    }

    private String browse(String oldValue, String title) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.exists() && f.canRead() && (f.isDirectory() || f.getName().endsWith(".zip") || f.getName().endsWith(".jar"));
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(DetectPanel.class, (String)"TXT_ZipFilter");
            }
        });
        File f = new File(oldValue);
        chooser.setSelectedFile(f);
        chooser.setDialogTitle(title);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    static class WizardPanel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    TaskListener,
    ChangeListener {
        private DetectPanel component;
        private RequestProcessor.Task task;
        private final J2SEWizardIterator iterator;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private boolean detected;
        private boolean valid;
        private boolean firstPass = true;
        private WizardDescriptor wiz;
        private ProgressHandle progressHandle;

        WizardPanel(J2SEWizardIterator iterator) {
            this.iterator = iterator;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public Component getComponent() {
            if (this.component == null) {
                final NewJ2SEPlatform primaryPlatform = this.iterator.getPlatform();
                final NewJ2SEPlatform secondaryPlatform = this.iterator.getSecondaryPlatform();
                this.component = new DetectPanel(primaryPlatform);
                this.component.addChangeListener(this);
                this.task = RP.create(new Runnable(){

                    @Override
                    public void run() {
                        primaryPlatform.run();
                        if (secondaryPlatform != null) {
                            secondaryPlatform.run();
                        }
                    }
                });
                this.task.addTaskListener((TaskListener)this);
            }
            return this.component;
        }

        void setValid(boolean v) {
            if (v == this.valid) {
                return;
            }
            this.valid = v;
            this.cs.fireChange();
        }

        public HelpCtx getHelp() {
            return new HelpCtx(DetectPanel.class);
        }

        public boolean isValid() {
            return this.valid;
        }

        public void readSettings(WizardDescriptor settings) {
            this.wiz = settings;
            NewJ2SEPlatform platform = this.iterator.getPlatform();
            String srcPath = null;
            String jdocPath = null;
            ClassPath src = platform.getSourceFolders();
            if (src.entries().size() > 0) {
                URL folderRoot = ((ClassPath.Entry)src.entries().get(0)).getURL();
                if ("jar".equals(folderRoot.getProtocol())) {
                    folderRoot = FileUtil.getArchiveFile((URL)folderRoot);
                }
                srcPath = new File(URI.create(folderRoot.toExternalForm())).getAbsolutePath();
            } else if (this.firstPass) {
                for (FileObject folder : platform.getInstallFolders()) {
                    File base = FileUtil.toFile((FileObject)folder);
                    if (base == null) continue;
                    File f = new File(base, "src.zip");
                    if (f.canRead()) {
                        srcPath = f.getAbsolutePath();
                        continue;
                    }
                    f = new File(base, "src.jar");
                    if (!f.canRead()) continue;
                    srcPath = f.getAbsolutePath();
                }
            }
            List jdoc = platform.getJavadocFolders();
            if (jdoc.size() > 0) {
                URL folderRoot = (URL)jdoc.get(0);
                if ("jar".equals(folderRoot.getProtocol())) {
                    folderRoot = FileUtil.getArchiveFile((URL)folderRoot);
                }
                jdocPath = new File(URI.create(folderRoot.toExternalForm())).getAbsolutePath();
            } else if (this.firstPass) {
                for (FileObject folder : platform.getInstallFolders()) {
                    File f;
                    File base = FileUtil.toFile((FileObject)folder);
                    if (base == null || !(f = new File(base, "docs")).isDirectory() || !f.canRead()) continue;
                    jdocPath = f.getAbsolutePath();
                }
                this.firstPass = false;
            }
            this.component.setSources(srcPath);
            this.component.setJavadoc(jdocPath);
            this.component.jdkName.setEditable(false);
            this.component.progressPanel.setVisible(true);
            this.component.progressLabel.setVisible(true);
            this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_PlatfromDetectProgress"));
            this.component.progressPanel.removeAll();
            this.component.progressPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = -1;
            c.gridx = -1;
            c.gridwidth = 0;
            c.gridheight = 0;
            c.fill = 2;
            c.weightx = 1.0;
            JComponent pc = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle);
            ((GridBagLayout)this.component.progressPanel.getLayout()).setConstraints(pc, c);
            this.component.progressPanel.add(pc);
            this.progressHandle.start();
            this.task.schedule(0);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        public void storeSettings(WizardDescriptor settings) {
            if (this.isValid()) {
                String jdocPath;
                String name = this.component.getPlatformName();
                ArrayList<PathResourceImplementation> src = new ArrayList<PathResourceImplementation>();
                ArrayList<URL> jdoc = new ArrayList<URL>();
                String srcPath = this.component.getSources();
                if (srcPath != null) {
                    File f = new File(srcPath);
                    try {
                        URL url = f.toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)url)) {
                            FileObject fo = URLMapper.findFileObject((URL)(url = FileUtil.getArchiveRoot((URL)url)));
                            if (fo != null && (fo = fo.getFileObject("src")) != null) {
                                url = fo.getURL();
                            }
                            src.add(ClassPathSupport.createResource((URL)url));
                        } else {
                            src.add(ClassPathSupport.createResource((URL)url));
                        }
                    }
                    catch (IllegalArgumentException mue) {
                    }
                    catch (MalformedURLException mue) {
                    }
                    catch (FileStateInvalidException e) {
                        // empty catch block
                    }
                }
                if ((jdocPath = this.component.getJavadoc()) != null) {
                    File f = new File(jdocPath);
                    try {
                        URL url = f.toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)url)) {
                            url = FileUtil.getArchiveRoot((URL)url);
                        } else if (!f.exists()) {
                            url = new URL(url.toExternalForm() + '/');
                        }
                        jdoc.add(url);
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                }
                NewJ2SEPlatform platform = this.iterator.getPlatform();
                platform.setDisplayName(name);
                platform.setAntName(WizardPanel.createAntName(name));
                platform.setSourceFolders(ClassPathSupport.createClassPath(src));
                platform.setJavadocFolders(jdoc);
                platform = this.iterator.getSecondaryPlatform();
                if (platform != null) {
                    name = NbBundle.getMessage(DetectPanel.class, (String)"FMT_64BIT", (Object)name);
                    platform.setDisplayName(name);
                    platform.setAntName(WizardPanel.createAntName(name));
                    platform.setSourceFolders(ClassPathSupport.createClassPath(src));
                    platform.setJavadocFolders(jdoc);
                }
            }
        }

        public void taskFinished(Task task) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardPanel.this.component.updateData();
                    WizardPanel.this.component.jdkName.setEditable(true);
                    assert (WizardPanel.this.progressHandle != null);
                    WizardPanel.this.progressHandle.finish();
                    WizardPanel.this.component.progressPanel.setVisible(false);
                    WizardPanel.this.component.progressLabel.setVisible(false);
                    WizardPanel.this.detected = WizardPanel.this.iterator.getPlatform().isValid();
                    WizardPanel.this.checkValid();
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.checkValid();
        }

        private void checkValid() {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)"");
            String name = this.component.getPlatformName();
            boolean validDisplayName = name.length() > 0;
            boolean usedDisplayName = false;
            if (!this.detected) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_NoSDKRegistry"));
            } else if (!validDisplayName) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_InvalidDisplayName"));
            } else {
                JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
                for (int i = 0; i < platforms.length; ++i) {
                    if (!name.equals(platforms[i].getDisplayName())) continue;
                    usedDisplayName = true;
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_UsedDisplayName"));
                    break;
                }
            }
            boolean v = this.detected && validDisplayName && !usedDisplayName;
            this.setValid(v);
        }

        private static String createAntName(String name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException();
            }
            String antName = PropertyUtils.getUsablePropertyName((String)name);
            if (WizardPanel.platformExists(antName)) {
                String baseName = antName;
                int index = 1;
                antName = baseName + Integer.toString(index);
                while (WizardPanel.platformExists(antName)) {
                    antName = baseName + Integer.toString(++index);
                }
            }
            return antName;
        }

        private static boolean platformExists(String antName) {
            JavaPlatformManager mgr = JavaPlatformManager.getDefault();
            JavaPlatform[] platforms = mgr.getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                String val;
                if (!(platforms[i] instanceof J2SEPlatformImpl) || !antName.equals(val = ((J2SEPlatformImpl)platforms[i]).getAntName())) continue;
                return true;
            }
            return false;
        }
    }
}

