/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.awt.Image;
import java.awt.event.KeyEvent;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewTopComponent;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public abstract class AbstractSVGAction
extends AbstractAction
implements Presenter.Popup {
    public static final String ICON_PATH_PREFIX = "org/netbeans/modules/mobility/svgcore/resources/";
    public static final String LBL_ID_PREFIX = "LBL_";
    public static final String ICON_ID_PREFIX = "ICON_";
    public static final String HINT_ID_PREFIX = "HINT_";
    public static final String KEY_ID_PREFIX = "KEY_";
    protected final String m_name;
    protected final String m_label;
    protected final String m_hint;
    protected final ImageIcon m_icon;
    protected final int m_toolbarPos;

    public AbstractSVGAction(String name) {
        this(name, true);
    }

    public AbstractSVGAction(String name, boolean isEnabled) {
        this(name, isEnabled, 100);
    }

    public AbstractSVGAction(String name, boolean isEnabled, int toolBarPos) {
        String hint;
        this.m_name = name;
        this.m_label = AbstractSVGAction.getMessage(LBL_ID_PREFIX + name);
        this.m_icon = AbstractSVGAction.getIcon(ICON_ID_PREFIX + name);
        this.setIcon(this.m_icon);
        try {
            hint = AbstractSVGAction.getMessage(HINT_ID_PREFIX + name);
        }
        catch (MissingResourceException e) {
            hint = this.m_label;
        }
        this.m_hint = hint;
        try {
            String key = AbstractSVGAction.getCleanMessage(KEY_ID_PREFIX + name);
            KeyStroke stroke = KeyStroke.getKeyStroke(key);
            assert (stroke != null) : "Invalid key stroke: " + name;
            this.putValue("AcceleratorKey", stroke);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        this.setDescription(hint);
        this.setEnabled(isEnabled);
        this.m_toolbarPos = toolBarPos;
    }

    protected final void setIcon(ImageIcon icon) {
        if (icon != null) {
            this.putValue("SmallIcon", icon);
        }
    }

    protected final void setDescription(String hint) {
        KeyStroke stroke = (KeyStroke)this.getValue("AcceleratorKey");
        if (stroke != null) {
            hint = hint + " (";
            String str = KeyEvent.getKeyModifiersText(stroke.getModifiers());
            if (str.length() > 0) {
                hint = hint + str + "+";
            }
            hint = hint + KeyEvent.getKeyText(stroke.getKeyCode()) + ")";
        }
        this.putValue("ShortDescription", hint);
    }

    public String getActionID() {
        return this.m_name;
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem menu = new JMenuItem(this);
        menu.setText(this.getLabel());
        menu.setToolTipText(null);
        menu.setIcon(null);
        return menu;
    }

    public int getPositionInToolbar() {
        return this.m_toolbarPos;
    }

    public void registerAction(TopComponent tc) {
        KeyStroke ks = (KeyStroke)this.getValue("AcceleratorKey");
        if (ks != null) {
            InputMap inputMap = tc.getInputMap(1);
            inputMap.put(ks, this.m_name);
            tc.getActionMap().put(this.m_name, this);
        }
    }

    protected String getLabel() {
        return this.m_label;
    }

    public static String getMessage(String msgId) {
        return NbBundle.getMessage(SVGViewTopComponent.class, (String)msgId);
    }

    public static String getCleanMessage(String msgId) {
        int q;
        int p;
        String msg = AbstractSVGAction.getMessage(msgId);
        if (msg != null && msg.length() > 0 && (p = msg.lastIndexOf(40)) != -1 && (q = msg.indexOf(41, p)) != -1) {
            StringBuilder sb = new StringBuilder(msg);
            sb.delete(p, q + 1);
            msg = sb.toString().trim();
        }
        return msg;
    }

    public static ImageIcon getIcon(String bundleKey) {
        try {
            String iconFileName = AbstractSVGAction.getCleanMessage(bundleKey).trim();
            String iconPath = ICON_PATH_PREFIX + iconFileName;
            Image img = ImageUtilities.loadImage((String)iconPath);
            assert (img != null) : "Icon not found: " + iconPath;
            return new ImageIcon(img);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

