/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.navigator;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.netbeans.modules.mobility.svgcore.navigator.FiltersDescription;
import org.netbeans.modules.mobility.svgcore.navigator.FiltersManager;

public final class FilterActions
extends AbstractAction {
    private static final String PROP_FILTER_NAME = "nbFilterName";
    private FiltersManager filters;

    public FilterActions(FiltersManager filters) {
        this.filters = filters;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)source;
            String filterName = (String)menuItem.getClientProperty(PROP_FILTER_NAME);
            this.filters.setSelected(filterName, menuItem.isSelected());
        }
    }

    public JMenuItem[] createMenuItems() {
        FiltersDescription filtersDesc = this.filters.getDescription();
        ArrayList<JCheckBoxMenuItem> menuItems = new ArrayList<JCheckBoxMenuItem>();
        for (int i = 0; i < filtersDesc.getFilterCount(); ++i) {
            String filterName = filtersDesc.getName(i);
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(filtersDesc.getDisplayName(i), this.filters.isSelected(filterName));
            menuItem.addActionListener(this);
            menuItem.putClientProperty(PROP_FILTER_NAME, filterName);
            menuItems.add(menuItem);
        }
        return menuItems.toArray(new JMenuItem[0]);
    }
}

