/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorDebug;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.completion.impl.xref.DocOffsetableImpl;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.utils.cache.TextCache;

public class ReferenceImpl
extends DocOffsetableImpl
implements CsmReference {
    private final TokenItem<CppTokenId> token;
    private CsmObject target = null;
    private CsmObject owner = null;
    private boolean findDone = false;
    private final int offset;
    private CsmReferenceKind kind;
    private FileReferencesContext fileReferencesContext;

    public ReferenceImpl(CsmFile file, BaseDocument doc, int offset, TokenItem<CppTokenId> token, CsmReferenceKind kind) {
        super(doc, file, offset);
        this.token = token;
        this.offset = offset;
        this.kind = kind;
    }

    public CsmObject getReferencedObject() {
        if (!this.findDone && this.isValid()) {
            this.target = ReferencesSupport.instance().findReferencedObject(super.getContainingFile(), super.getDocument(), this.offset, this.token, this.fileReferencesContext);
            this.findDone = true;
        }
        return this.target;
    }

    public CsmObject getOwner() {
        if (this.owner == null && this.isValid()) {
            this.owner = ReferencesSupport.findOwnerObject(super.getContainingFile(), super.getDocument(), this.offset, this.token);
        }
        return this.owner;
    }

    @Override
    public CharSequence getText() {
        CharSequence cs = this.token.text();
        if (cs == null) {
            return "";
        }
        return TextCache.getManager().getString(cs);
    }

    public String toString() {
        return "'" + EditorDebug.debugString((String)((Object)this.getText()).toString()) + "', tokenID=" + ((CppTokenId)this.token.id()).toString().toLowerCase() + ", offset=" + this.offset + " [" + super.getStartPosition() + "-" + super.getEndPosition() + "]";
    }

    final void setTarget(CsmObject target) {
        this.target = target;
    }

    final CsmObject getTarget() {
        return this.target;
    }

    final int getOffset() {
        return this.offset;
    }

    final TokenItem<CppTokenId> getToken() {
        return this.token;
    }

    final CsmReferenceKind getKindImpl() {
        return this.kind;
    }

    public CsmReferenceKind getKind() {
        if (this.kind == null) {
            CsmReferenceKind curKind;
            this.kind = curKind = ReferencesSupport.getReferenceKind(this);
        }
        return this.kind;
    }

    void setFileReferencesContext(FileReferencesContext fileReferencesContext) {
        this.fileReferencesContext = fileReferencesContext;
    }
}

