/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.dlight.core.ui.components.ContentValidator;
import org.netbeans.modules.dlight.core.ui.components.DLightTargetSelectionDialog;
import org.netbeans.modules.dlight.core.ui.components.JComboBox2;
import org.netbeans.modules.dlight.core.ui.components.SelectExecutableTargetDialog;
import org.openide.util.NbBundle;

public class SelectJavaApplicationDialog
extends DLightTargetSelectionDialog {
    private DefaultComboBoxModel cmbJvmPathModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbJvmOptionsModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbJarFileModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbMainClassModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbArgumentsModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbClassPathModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbWorkingDirModel = new DefaultComboBoxModel();
    private JButton btnBrowseJDK = new JButton(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.Browse.Title"));
    private JButton btnBrowseJARFile = new JButton(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.Browse.Title"));
    private JButton btnBrowseWorkingDir = new JButton(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.Browse.Title"));
    private ContentValidator fileValidator = new ContentValidator(){

        @Override
        public String validate(String value) {
            return new File(value).exists() ? null : NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.SpecifyPathToJVM");
        }
    };
    private ContentValidator workingDirValidator = new ContentValidator(){

        @Override
        public String validate(String value) {
            File dir = new File(value);
            if (!dir.exists() || !dir.isDirectory()) {
                return NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.SpecifyExistentWorkingDir");
            }
            return dir.canWrite() ? null : NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.WorkingDirIsNotWritable");
        }
    };

    public SelectJavaApplicationDialog() {
        super(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.Title"));
        this.setDefaults();
        this.init();
    }

    @Override
    public String getProgramArguments() {
        String classPath;
        String progArgs;
        String mainClass;
        String jarFile;
        StringBuffer args = new StringBuffer();
        String jvmOptions = this.getJvmOptions();
        if (jvmOptions != null) {
            args.append(" ").append(jvmOptions);
        }
        if ((jarFile = this.getJarFile()) != null) {
            args.append(" -jar " + jarFile);
        }
        if ((mainClass = this.getMainClass()) != null) {
            args.append(" ").append(mainClass);
        }
        if ((progArgs = this.getArguments()) != null) {
            args.append(" ").append(progArgs);
        }
        if ((classPath = this.getClassPath()) != null) {
            args.append(" -cp ").append(classPath);
        }
        return args.toString();
    }

    @Override
    public String getWorkingDirectory() {
        return (String)this.cmbWorkingDirModel.getSelectedItem();
    }

    private String getArguments() {
        return (String)this.cmbArgumentsModel.getSelectedItem();
    }

    private String getClassPath() {
        return (String)this.cmbClassPathModel.getSelectedItem();
    }

    private String getJvmOptions() {
        return (String)this.cmbJvmOptionsModel.getSelectedItem();
    }

    private String getJvmPath() {
        return (String)this.cmbJvmPathModel.getSelectedItem();
    }

    private String getJarFile() {
        return (String)this.cmbJarFileModel.getSelectedItem();
    }

    private String getMainClass() {
        return (String)this.cmbMainClassModel.getSelectedItem();
    }

    private void setDefaults() {
        String[] jdkPathsGuess = new String[]{System.getProperty("java.home"), "/usr/java", System.getProperty("JAVA_HOME"), System.getProperty("JDK_HOME")};
        for (int i = jdkPathsGuess.length - 1; i >= 0; --i) {
            File jvmPathGuess = new File(jdkPathsGuess[i], "bin/java");
            if (!jvmPathGuess.exists()) continue;
            SelectJavaApplicationDialog.updateModel(this.cmbJvmPathModel, jvmPathGuess.getPath());
            File demoJar = new File(jdkPathsGuess[i], "demo/jfc/Java2D/Java2Demo.jar");
            if (!demoJar.exists()) continue;
            SelectJavaApplicationDialog.updateModel(this.cmbJarFileModel, demoJar.getPath());
        }
        SelectJavaApplicationDialog.updateModel(this.cmbJarFileModel, "");
        SelectJavaApplicationDialog.updateModel(this.cmbJvmOptionsModel, "-Xmx128m  -XX:+ExtendedDTraceProbes");
        SelectJavaApplicationDialog.updateModel(this.cmbWorkingDirModel, "/tmp");
    }

    @Override
    void initComponents() {
        this.setLayout(new GridLayout(8, 1));
        this.btnBrowseJDK.addActionListener(this);
        this.btnBrowseJARFile.addActionListener(this);
        this.btnBrowseWorkingDir.addActionListener(this);
        this.btnBrowseJDK.setToolTipText(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.BrowseJDK.Tooltip"));
        this.btnBrowseJARFile.setToolTipText(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.BrowseJar.Tooltip"));
        this.btnBrowseWorkingDir.setToolTipText(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.BrowseWorkingDir.Tooltip"));
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.JVMPath"), new JComboBox2(this.cmbJvmPathModel, 10, true, this.fileValidator), this.btnBrowseJDK);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.JVMOptions"), new JComboBox2(this.cmbJvmOptionsModel, 10, true, null), null);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.JARFile"), new JComboBox2(this.cmbJarFileModel, 10, true, this.fileValidator), this.btnBrowseJARFile);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.MainClass"), new JComboBox2(this.cmbMainClassModel, 10, true, null), null);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.Arguments"), new JComboBox2(this.cmbArgumentsModel, 10, true, null), null);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.ClassPath"), new JComboBox2(this.cmbClassPathModel, 10, true, null), null);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.WorkingDir"), new JComboBox2(this.cmbWorkingDirModel, 10, true, this.workingDirValidator), this.btnBrowseWorkingDir);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object src = e.getSource();
        if (!(src instanceof JButton)) {
            return;
        }
        if (src == this.btnBrowseJDK) {
            String jvmPath = this.selectFile((String)this.cmbJvmPathModel.getSelectedItem());
            SelectJavaApplicationDialog.updateModel(this.cmbJvmPathModel, jvmPath);
        } else if (src == this.btnBrowseJARFile) {
            String jarFile = this.selectFile((String)this.cmbJarFileModel.getSelectedItem(), new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f != null) {
                        String desiredExtension;
                        if (f.isDirectory()) {
                            return true;
                        }
                        String fileName = f.getName();
                        int i = fileName.lastIndexOf(46);
                        if (i > 0 && i < fileName.length() - 1 && (desiredExtension = fileName.substring(i + 1).toLowerCase(Locale.ENGLISH)).equals("jar")) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return "JAR file (*.jar)";
                }
            });
            SelectJavaApplicationDialog.updateModel(this.cmbJarFileModel, jarFile);
        } else if (src == this.btnBrowseWorkingDir) {
            String workDir = this.selectDirectory((String)this.cmbWorkingDirModel.getSelectedItem(), this.workingDirValidator);
            SelectJavaApplicationDialog.updateModel(this.cmbWorkingDirModel, workDir);
        }
    }

    @Override
    public void approveSelection() {
        String jarFile = this.getJarFile();
        String mainClass = this.getMainClass();
        if ((jarFile == null || jarFile.equals("")) && (mainClass == null || mainClass.equals(""))) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectJavaApplicationDialog.SpecifyJarOrMainClass"));
        } else {
            super.approveSelection();
        }
    }

    @Override
    public String getProgramName() {
        return this.getJvmPath();
    }
}

