/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.sun.api.ServerInterface;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DomainEditor;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.JvmOptions;

public class HttpProxyUpdater {
    public static final String HTTP_PROXY_HOST = "-Dhttp.proxyHost=";
    public static final String HTTP_PROXY_PORT = "-Dhttp.proxyPort=";
    public static final String HTTPS_PROXY_HOST = "-Dhttps.proxyHost=";
    public static final String HTTPS_PROXY_PORT = "-Dhttps.proxyPort=";
    public static final String HTTP_PROXY_NO_HOST = "-Dhttp.nonProxyHosts=";
    private String httpProxyPort;
    private String httpProxyHost;
    private String httpsProxyPort;
    private String httpsProxyHost;
    private String httpProxyNoHost;
    private static String JVM_OPTIONS = "jvm-options";
    private ObjectName jvmOptionsObjectName;
    private ServerInterface si;
    private String[] options;
    private boolean serverRunning;
    ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.j2ee.Bundle");

    public HttpProxyUpdater(ServerInterface serverInterface, boolean bl) {
        this.serverRunning = bl;
        this.si = serverInterface;
    }

    private void getOptionsFromServer() throws Exception {
        this.jvmOptionsObjectName = new JvmOptions(this.si.getMBeanServerConnection()).getConfigObjectName();
        this.options = (String[])this.si.getAttribute(this.jvmOptionsObjectName, JVM_OPTIONS);
        this.initializeProps();
    }

    private void setOptionsToServer() throws Exception {
        this.jvmOptionsObjectName = new JvmOptions(this.si.getMBeanServerConnection()).getConfigObjectName();
        Attribute attribute = new Attribute(JVM_OPTIONS, this.options);
        this.si.setAttribute(this.jvmOptionsObjectName, attribute);
    }

    private void getOptionsFromXml() {
        DomainEditor domainEditor = new DomainEditor(this.si.getDeploymentManager());
        this.options = domainEditor.getHttpProxyOptions();
        this.initializeProps();
    }

    private void setOptionsToXml() {
        DomainEditor domainEditor = new DomainEditor(this.si.getDeploymentManager());
        domainEditor.setHttpProxyOptions(this.options);
    }

    private boolean removeProperty(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.options.length; ++n) {
            String string2 = this.options[n].trim();
            if (string2.startsWith(string)) continue;
            arrayList.add(this.options[n]);
        }
        int n2 = n = this.options.length != arrayList.size() ? 1 : 0;
        if (n != 0) {
            this.options = arrayList.toArray(new String[arrayList.size()]);
        }
        return n != 0;
    }

    private boolean setProperty(String string, String string2) {
        if (string2 == null) {
            return this.removeProperty(string);
        }
        String string3 = string + string2;
        boolean bl = false;
        for (int i = 0; i < this.options.length; ++i) {
            String string4 = this.options[i].trim();
            if (!string4.startsWith(string)) continue;
            this.options[i] = string3;
            bl = true;
            break;
        }
        if (bl) {
            return true;
        }
        String[] stringArray = new String[this.options.length + 1];
        System.arraycopy(this.options, 0, stringArray, 0, this.options.length);
        stringArray[this.options.length] = string3;
        this.options = stringArray;
        return true;
    }

    private boolean removeProxy() {
        boolean bl = this.removeProperty(HTTP_PROXY_HOST);
        bl |= this.removeProperty(HTTP_PROXY_PORT);
        bl |= this.removeProperty(HTTPS_PROXY_HOST);
        bl |= this.removeProperty(HTTPS_PROXY_PORT);
        return bl |= this.removeProperty(HTTP_PROXY_NO_HOST);
    }

    public void addHttpProxySettings() throws Exception {
        String string;
        String string2;
        String string3 = System.getProperty("http.proxyHost", "");
        if (string3.trim().length() == 0) {
            string3 = null;
        }
        if ((string2 = System.getProperty("http.proxyPort", "")).trim().length() == 0) {
            string2 = null;
        }
        string = (string = System.getProperty("http.nonProxyHosts", "")).trim().length() != 0 ? string.replaceAll(" ", "") : null;
        if (this.serverRunning) {
            try {
                this.getOptionsFromServer();
                if (string3 == null || string2 == null || string == null) {
                    this.removeOptionsFromServer();
                    return;
                }
            }
            catch (Exception exception) {
                throw new Exception(this.bundle.getString("Err_CannotUpdateProxy"));
            }
            this.checkProxyInfo(string3, string2);
            if (this.updateOptions(string3, string2, string)) {
                try {
                    this.setOptionsToServer();
                }
                catch (Exception exception) {
                    String string4 = MessageFormat.format(this.bundle.getString("Err_InvalidProxyInfo"), string3, string2);
                    throw new Exception(string4);
                }
            }
        } else {
            this.getOptionsFromXml();
            if (string3 == null || string2 == null || string == null) {
                this.removeOptionsFromXml();
                return;
            }
            this.checkProxyInfo(string3, string2);
            if (this.updateOptions(string3, string2, string)) {
                this.setOptionsToXml();
            }
        }
    }

    public void removeHttpProxySettings() throws Exception {
        if (this.serverRunning) {
            this.getOptionsFromServer();
            this.removeOptionsFromServer();
        } else {
            this.getOptionsFromXml();
            this.removeOptionsFromXml();
        }
    }

    private void removeOptionsFromXml() {
        if ((this.httpProxyHost != null || this.httpProxyPort != null || this.httpProxyNoHost != null || this.httpsProxyHost != null || this.httpsProxyPort != null) && this.removeProxy()) {
            this.setOptionsToXml();
        }
    }

    private void removeOptionsFromServer() throws Exception {
        try {
            if ((this.httpProxyHost != null || this.httpProxyPort != null || this.httpProxyNoHost != null || this.httpsProxyHost != null || this.httpsProxyPort != null) && this.removeProxy()) {
                try {
                    this.setOptionsToServer();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean updateOptions(String string, String string2, String string3) {
        SunDeploymentManagerInterface sunDeploymentManagerInterface;
        boolean bl = false;
        if (!string.equals(this.httpProxyHost)) {
            this.setProperty(HTTP_PROXY_HOST, string);
            bl = true;
        }
        if (!string2.equals(this.httpProxyPort)) {
            this.setProperty(HTTP_PROXY_PORT, string2);
            bl = true;
        }
        if (!string.equals(this.httpsProxyHost)) {
            this.setProperty(HTTPS_PROXY_HOST, string);
            bl = true;
        }
        if (!string2.equals(this.httpsProxyPort)) {
            this.setProperty(HTTPS_PROXY_PORT, string2);
            bl = true;
        }
        if (ServerLocationManager.isGlassFish((File)(sunDeploymentManagerInterface = (SunDeploymentManagerInterface)this.si.getDeploymentManager()).getPlatformRoot()) && !string3.equals(this.httpProxyNoHost)) {
            this.setProperty(HTTP_PROXY_NO_HOST, string3);
            bl = true;
        }
        return bl;
    }

    private void initializeProps() {
        for (int i = 0; i < this.options.length; ++i) {
            String string = this.options[i].trim();
            if (string.startsWith(HTTP_PROXY_HOST)) {
                this.httpProxyHost = string.substring(HTTP_PROXY_HOST.length());
                continue;
            }
            if (string.startsWith(HTTP_PROXY_PORT)) {
                this.httpProxyPort = string.substring(HTTP_PROXY_PORT.length());
                continue;
            }
            if (string.startsWith(HTTPS_PROXY_HOST)) {
                this.httpsProxyHost = string.substring(HTTPS_PROXY_HOST.length());
                continue;
            }
            if (string.startsWith(HTTPS_PROXY_PORT)) {
                this.httpsProxyPort = string.substring(HTTPS_PROXY_PORT.length());
                continue;
            }
            if (!string.startsWith(HTTP_PROXY_NO_HOST)) continue;
            this.httpProxyNoHost = string.substring(HTTP_PROXY_NO_HOST.length());
        }
    }

    private void checkProxyInfo(String string, String string2) throws Exception {
        try {
            int n = Integer.parseInt(string2);
            Socket socket = new Socket(string, n);
            return;
        }
        catch (Exception exception) {
            String string3 = MessageFormat.format(this.bundle.getString("Err_InvalidProxyInfo"), string, string2);
            throw new Exception(string3);
        }
    }
}

