/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.util.KCode;

public class ParserConfiguration {
    private DynamicScope existingScope = null;
    private boolean asBlock = false;
    private int lineNumber = 0;
    private boolean inlineSource = false;
    private boolean isEvalParse = true;
    private boolean isDebug = false;
    private boolean saveData = false;
    private Encoding defaultEncoding;
    private Ruby runtime;
    private int[] coverage = EMPTY_COVERAGE;
    private static final int[] EMPTY_COVERAGE = new int[0];

    public ParserConfiguration(Ruby runtime, int lineNumber, boolean inlineSource, boolean isFileParse, boolean saveData) {
        this.runtime = runtime;
        this.inlineSource = inlineSource;
        this.lineNumber = lineNumber;
        this.isEvalParse = !isFileParse;
        this.saveData = saveData;
    }

    public ParserConfiguration(Ruby runtime, int lineNumber, boolean inlineSource, boolean isFileParse, RubyInstanceConfig config) {
        this(runtime, lineNumber, inlineSource, isFileParse, false, config);
    }

    public ParserConfiguration(Ruby runtime, int lineNumber, boolean inlineSource, boolean isFileParse, boolean saveData, RubyInstanceConfig config) {
        this(runtime, lineNumber, inlineSource, isFileParse, saveData);
        this.isDebug = config.isParserDebug();
    }

    public void setDefaultEncoding(Encoding encoding2) {
        this.defaultEncoding = encoding2;
    }

    public Encoding getDefaultEncoding() {
        if (this.defaultEncoding == null) {
            this.defaultEncoding = UTF8Encoding.INSTANCE;
        }
        return this.defaultEncoding;
    }

    public EncodingService getEncodingService() {
        return this.runtime.getEncodingService();
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isEvalParse() {
        return this.isEvalParse;
    }

    public KCode getKCode() {
        return this.runtime.getKCode();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void parseAsBlock(DynamicScope existingScope) {
        this.asBlock = true;
        this.existingScope = existingScope;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public DynamicScope getScope(String file2) {
        if (this.asBlock) {
            return this.existingScope;
        }
        return new ManyVarsDynamicScope(this.runtime.getStaticScopeFactory().newLocalScope(null, file2), this.existingScope);
    }

    public boolean isSaveData() {
        return this.saveData;
    }

    public boolean isInlineSource() {
        return this.inlineSource;
    }

    public void coverLine(int i2) {
        if (i2 < 0) {
            return;
        }
        if (this.runtime.getCoverageData().isCoverageEnabled()) {
            if (this.coverage == null) {
                this.coverage = new int[i2 + 1];
            } else if (this.coverage.length <= i2) {
                int[] newCoverage = new int[i2 + 1];
                Arrays.fill(newCoverage, -1);
                System.arraycopy(this.coverage, 0, newCoverage, 0, this.coverage.length);
                this.coverage = newCoverage;
            }
            this.coverage[i2] = 0;
        }
    }

    public int[] getCoverage() {
        return this.coverage;
    }
}

