/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.runtime;

import com.headius.invokebinder.Signature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import org.jcodings.Encoding;
import org.jruby.MetaClass;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.methods.CompiledIRMetaClassBody;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedIRBodyMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMetaClassBody;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.Interp;
import org.jruby.ir.JIT;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.persistence.IRReader;
import org.jruby.ir.persistence.IRReaderStream;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.javasupport.JavaUtil;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.NormalCachingCallSite;
import org.jruby.runtime.callsite.RefinedCachingCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ByteList;
import org.jruby.util.DefinedMessage;
import org.jruby.util.RegexpOptions;
import org.jruby.util.TypeConverter;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class IRRuntimeHelpers {
    private static final Logger LOG = LoggerFactory.getLogger("IRRuntimeHelpers");

    public static boolean inProfileMode() {
        return RubyInstanceConfig.IR_PROFILE;
    }

    public static boolean isDebug() {
        return RubyInstanceConfig.IR_DEBUG;
    }

    public static boolean inNonMethodBodyLambda(StaticScope scope, Block.Type blockType) {
        return blockType == Block.Type.LAMBDA && !scope.isArgumentScope();
    }

    public static boolean inLambda(Block.Type blockType) {
        return blockType == Block.Type.LAMBDA;
    }

    public static boolean inProc(Block.Type blockType) {
        return blockType == Block.Type.PROC;
    }

    public static void checkForLJE(ThreadContext context, DynamicScope dynScope, boolean maybeLambda, Block.Type blockType) {
        if (IRRuntimeHelpers.inLambda(blockType)) {
            return;
        }
        StaticScope scope = dynScope.getStaticScope();
        IRScopeType scopeType = scope.getScopeType();
        boolean inDefineMethod = false;
        while (dynScope != null) {
            StaticScope ss = dynScope.getStaticScope();
            IRScopeType ssType = ss.getScopeType();
            if (ssType != null) {
                if (ssType.isMethodType()) break;
                if (ss.isArgumentScope() && ssType.isClosureType() && ssType != IRScopeType.EVAL_SCRIPT) {
                    inDefineMethod = true;
                    break;
                }
            }
            dynScope = dynScope.getParentScope();
        }
        if ((scopeType == null || !inDefineMethod && scopeType.isClosureType() && scopeType != IRScopeType.EVAL_SCRIPT) && (maybeLambda || !context.scopeExistsOnCallStack(dynScope))) {
            throw IRException.RETURN_LocalJumpError.getException(context.runtime);
        }
    }

    public static IRubyObject initiateNonLocalReturn(ThreadContext context, DynamicScope dynScope, Block.Type blockType, IRubyObject returnValue) {
        StaticScope ss;
        IRScopeType ssType;
        if (IRRuntimeHelpers.inLambda(blockType)) {
            return returnValue;
        }
        while (!(dynScope == null || (ssType = (ss = dynScope.getStaticScope()).getScopeType()) != null && (ssType.isMethodType() || ss.isArgumentScope() && ssType.isClosureType() && ssType != IRScopeType.EVAL_SCRIPT || ssType.isClosureType() && dynScope.isLambda()))) {
            dynScope = dynScope.getParentScope();
        }
        throw IRReturnJump.create(dynScope, returnValue);
    }

    @JIT
    public static IRubyObject handleNonlocalReturn(StaticScope scope, DynamicScope dynScope, Object rjExc, Block.Type blockType) throws RuntimeException {
        if (!(rjExc instanceof IRReturnJump)) {
            Helpers.throwException((Throwable)rjExc);
            return null;
        }
        IRReturnJump rj = (IRReturnJump)rjExc;
        if (rj.methodToReturnFrom == dynScope) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Non-local Return reached target in scope: " + dynScope + " matching dynscope? " + (rj.methodToReturnFrom == dynScope));
            }
            return (IRubyObject)rj.returnValue;
        }
        throw rj;
    }

    public static IRubyObject initiateBreak(ThreadContext context, DynamicScope dynScope, IRubyObject breakValue, Block.Type blockType) throws RuntimeException {
        if (IRRuntimeHelpers.inLambda(blockType)) {
            return breakValue;
        }
        StaticScope scope = dynScope.getStaticScope();
        IRScopeType scopeType = scope.getScopeType();
        if (!scopeType.isClosureType()) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
        IRBreakJump bj = IRBreakJump.create(dynScope.getParentScope(), breakValue);
        if (scopeType == IRScopeType.EVAL_SCRIPT) {
            bj.breakInEval = true;
        }
        throw bj;
    }

    @JIT
    public static IRubyObject handleBreakAndReturnsInLambdas(ThreadContext context, StaticScope scope, DynamicScope dynScope, Object exc, Block.Type blockType) throws RuntimeException {
        if (exc instanceof IRBreakJump && IRRuntimeHelpers.inNonMethodBodyLambda(scope, blockType)) {
            throw IRException.BREAK_LocalJumpError.getException(context.getRuntime());
        }
        if (exc instanceof IRReturnJump && (blockType == null || IRRuntimeHelpers.inLambda(blockType))) {
            return IRRuntimeHelpers.handleNonlocalReturn(scope, dynScope, exc, blockType);
        }
        Helpers.throwException((Throwable)exc);
        return null;
    }

    @JIT
    public static IRubyObject handlePropagatedBreak(ThreadContext context, DynamicScope dynScope, Object bjExc, Block.Type blockType) {
        if (!(bjExc instanceof IRBreakJump)) {
            Helpers.throwException((Throwable)bjExc);
            return null;
        }
        IRBreakJump bj = (IRBreakJump)bjExc;
        if (bj.breakInEval) {
            StaticScope scope = dynScope.getStaticScope();
            IRScopeType scopeType = scope.getScopeType();
            if (!scopeType.isClosureType()) {
                throw IRException.BREAK_LocalJumpError.getException(context.getRuntime());
            }
            bj.breakInEval = false;
            throw bj;
        }
        if (bj.scopeToReturnTo == dynScope) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Break reached target in scope: " + dynScope);
            }
            return bj.breakValue;
        }
        throw bj;
    }

    @JIT
    public static void defCompiledIRMethod(ThreadContext context, MethodHandle handle, String rubyName, DynamicScope currDynScope, IRubyObject self2, IRScope irScope) {
        Ruby runtime = context.runtime;
        RubyModule containingClass = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(runtime, containingClass, rubyName, currVisibility);
        CompiledIRMethod method = new CompiledIRMethod(handle, irScope, newVisibility, containingClass, irScope.receivesKeywordArgs());
        Helpers.addInstanceMethod(containingClass, rubyName, method, currVisibility, context, runtime);
    }

    @JIT
    public static void defCompiledIRClassMethod(ThreadContext context, IRubyObject obj, MethodHandle handle, String rubyName, IRScope irScope) {
        Ruby runtime = context.runtime;
        if (obj instanceof RubyFixnum || obj instanceof RubySymbol) {
            throw runtime.newTypeError("can't define singleton method \"" + rubyName + "\" for " + obj.getMetaClass().getBaseName());
        }
        if (obj.isFrozen()) {
            throw runtime.newFrozenError("object");
        }
        RubyClass containingClass = obj.getSingletonClass();
        CompiledIRMethod method = new CompiledIRMethod(handle, irScope, Visibility.PUBLIC, containingClass, irScope.receivesKeywordArgs());
        containingClass.addMethod(rubyName, method);
        obj.callMethod(context, "singleton_method_added", runtime.fastNewSymbol(rubyName));
    }

    public static IRubyObject undefMethod(ThreadContext context, Object nameArg, DynamicScope currDynScope, IRubyObject self2) {
        String name2;
        RubyModule module = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        String string2 = name2 = nameArg instanceof String ? (String)nameArg : nameArg.toString();
        if (module == null) {
            throw context.runtime.newTypeError("No class to undef method '" + name2 + "'.");
        }
        module.undef(context, name2);
        return context.runtime.getNil();
    }

    public static double unboxFloat(IRubyObject val) {
        if (val instanceof RubyFloat) {
            return ((RubyFloat)val).getValue();
        }
        return ((RubyFixnum)val).getDoubleValue();
    }

    public static long unboxFixnum(IRubyObject val) {
        if (val instanceof RubyFloat) {
            return (long)((RubyFloat)val).getValue();
        }
        return ((RubyFixnum)val).getLongValue();
    }

    public static boolean flt(double v1, double v2) {
        return v1 < v2;
    }

    public static boolean fgt(double v1, double v2) {
        return v1 > v2;
    }

    public static boolean feq(double v1, double v2) {
        return v1 == v2;
    }

    public static boolean ilt(long v1, long v2) {
        return v1 < v2;
    }

    public static boolean igt(long v1, long v2) {
        return v1 > v2;
    }

    public static boolean ieq(long v1, long v2) {
        return v1 == v2;
    }

    public static Object unwrapRubyException(Object excObj) {
        if (excObj instanceof Unrescuable) {
            Helpers.throwException((Throwable)excObj);
        }
        return excObj instanceof RaiseException ? ((RaiseException)excObj).getException() : excObj;
    }

    private static boolean isJavaExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj, boolean arrayCheck) {
        if (!(excObj instanceof Throwable)) {
            return false;
        }
        Ruby runtime = context.runtime;
        Throwable throwable = (Throwable)excObj;
        if (excType instanceof RubyArray) {
            RubyArray testTypes = (RubyArray)excType;
            int n = testTypes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                IRubyObject exceptionObj;
                IRubyObject testType = testTypes.eltInternal(i2);
                if (!IRRuntimeHelpers.isJavaExceptionHandled(context, testType, throwable, true)) continue;
                if (n == 1 && testType == runtime.getNativeException()) {
                    exceptionObj = new NativeException(runtime, runtime.getNativeException(), throwable);
                    ((NativeException)exceptionObj).prepareIntegratedBacktrace(context, throwable.getStackTrace());
                } else {
                    exceptionObj = JavaUtil.convertJavaToUsableRubyObject(runtime, throwable);
                }
                runtime.getGlobalVariables().set("$!", exceptionObj);
                return true;
            }
        } else if (Helpers.checkJavaException(throwable, excType, context)) {
            IRubyObject exceptionObj;
            if (excType == runtime.getNativeException()) {
                exceptionObj = new NativeException(runtime, runtime.getNativeException(), throwable);
                ((NativeException)exceptionObj).prepareIntegratedBacktrace(context, throwable.getStackTrace());
            } else {
                exceptionObj = JavaUtil.convertJavaToUsableRubyObject(runtime, throwable);
            }
            runtime.getGlobalVariables().set("$!", exceptionObj);
            return true;
        }
        return false;
    }

    private static boolean isRubyExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj) {
        if (excType instanceof RubyArray) {
            RubyArray testTypes = (RubyArray)excType;
            int n = testTypes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                IRubyObject testType = testTypes.eltInternal(i2);
                if (!IRRuntimeHelpers.isRubyExceptionHandled(context, testType, excObj)) continue;
                context.runtime.getGlobalVariables().set("$!", (IRubyObject)excObj);
                return true;
            }
        } else if (excObj instanceof IRubyObject) {
            if (!(excType instanceof RubyModule)) {
                throw context.runtime.newTypeError("class or module required for rescue clause. Found: " + excType);
            }
            if (excType.callMethod(context, "===", (IRubyObject)excObj).isTrue()) {
                context.runtime.getGlobalVariables().set("$!", (IRubyObject)excObj);
                return true;
            }
        }
        return false;
    }

    public static IRubyObject isExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj) {
        boolean ret = IRRuntimeHelpers.isRubyExceptionHandled(context, excType, excObj = IRRuntimeHelpers.unwrapRubyException(excObj)) || IRRuntimeHelpers.isJavaExceptionHandled(context, excType, excObj, false);
        return context.runtime.newBoolean(ret);
    }

    public static IRubyObject isEQQ(ThreadContext context, IRubyObject receiver2, IRubyObject value2) {
        boolean isUndefValue;
        boolean bl = isUndefValue = value2 == UndefinedValue.UNDEFINED;
        if (receiver2 instanceof RubyArray) {
            RubyArray testVals = (RubyArray)receiver2;
            int n = testVals.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                IRubyObject eqqVal;
                IRubyObject v = testVals.eltInternal(i2);
                IRubyObject iRubyObject = eqqVal = isUndefValue ? v : v.callMethod(context, "===", value2);
                if (!eqqVal.isTrue()) continue;
                return eqqVal;
            }
            return context.runtime.newBoolean(false);
        }
        return isUndefValue ? receiver2 : receiver2.callMethod(context, "===", value2);
    }

    public static IRubyObject newProc(Ruby runtime, Block block) {
        return block == Block.NULL_BLOCK ? runtime.getNil() : runtime.newProc(Block.Type.PROC, block);
    }

    public static IRubyObject yield(ThreadContext context, Object blk, Object yieldArg, boolean unwrapArray) {
        if (blk instanceof RubyProc) {
            blk = ((RubyProc)blk).getBlock();
        }
        if (blk instanceof RubyNil) {
            blk = Block.NULL_BLOCK;
        }
        Block b2 = (Block)blk;
        IRubyObject yieldVal = (IRubyObject)yieldArg;
        return unwrapArray && yieldVal instanceof RubyArray ? b2.yieldArray(context, yieldVal, null) : b2.yield(context, yieldVal);
    }

    public static IRubyObject yieldSpecific(ThreadContext context, Object blk) {
        if (blk instanceof RubyProc) {
            blk = ((RubyProc)blk).getBlock();
        }
        if (blk instanceof RubyNil) {
            blk = Block.NULL_BLOCK;
        }
        Block b2 = (Block)blk;
        return b2.yieldSpecific(context);
    }

    public static IRubyObject[] convertValueIntoArgArray(ThreadContext context, IRubyObject value2, int blockArity, boolean argIsArray) {
        if (argIsArray && !(value2 instanceof RubyArray)) {
            argIsArray = false;
        }
        switch (blockArity) {
            case -1: {
                IRubyObject[] iRubyObjectArray;
                if (argIsArray) {
                    iRubyObjectArray = ((RubyArray)value2).toJavaArray();
                } else {
                    IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                    iRubyObjectArray = iRubyObjectArray2;
                    iRubyObjectArray2[0] = value2;
                }
                return iRubyObjectArray;
            }
            case 0: {
                return new IRubyObject[]{value2};
            }
            case 1: {
                RubyArray valArray;
                if (argIsArray && (valArray = (RubyArray)value2).size() == 0) {
                    value2 = RubyArray.newEmptyArray(context.runtime);
                }
                return new IRubyObject[]{value2};
            }
        }
        if (argIsArray) {
            IRubyObject[] iRubyObjectArray;
            RubyArray valArray = (RubyArray)value2;
            if (valArray.size() == 1) {
                value2 = valArray.eltInternal(0);
            }
            if ((value2 = Helpers.aryToAry(value2)) instanceof RubyArray) {
                iRubyObjectArray = ((RubyArray)value2).toJavaArray();
            } else {
                IRubyObject[] iRubyObjectArray3 = new IRubyObject[1];
                iRubyObjectArray = iRubyObjectArray3;
                iRubyObjectArray3[0] = value2;
            }
            return iRubyObjectArray;
        }
        IRubyObject val0 = Helpers.aryToAry(value2);
        if (!(val0 instanceof RubyArray)) {
            throw context.runtime.newTypeError(value2.getType().getName() + "#to_ary should return Array");
        }
        return ((RubyArray)val0).toJavaArray();
    }

    @JIT
    public static Block getBlockFromObject(ThreadContext context, Object value2) {
        Block block;
        if (value2 instanceof Block) {
            block = (Block)value2;
        } else if (value2 instanceof RubyProc) {
            block = ((RubyProc)value2).getBlock();
        } else if (value2 instanceof RubyMethod) {
            block = ((RubyProc)((RubyMethod)value2).to_proc(context)).getBlock();
        } else if (value2 instanceof IRubyObject && ((IRubyObject)value2).isNil()) {
            block = Block.NULL_BLOCK;
        } else if (value2 instanceof IRubyObject) {
            block = ((RubyProc)TypeConverter.convertToType((IRubyObject)value2, context.runtime.getProc(), "to_proc", true)).getBlock();
        } else {
            throw new RuntimeException("Unhandled case in CallInstr:prepareBlock.  Got block arg: " + value2);
        }
        return block;
    }

    public static void checkArity(ThreadContext context, Object[] args2, int required, int opt, boolean rest2, boolean receivesKwargs, int restKey, Block.Type blockType) {
        int argsLength = args2.length;
        RubyHash keywordArgs = IRRuntimeHelpers.extractKwargsHash(args2, required, receivesKwargs);
        if (restKey == -1 && keywordArgs != null) {
            IRRuntimeHelpers.checkForExtraUnwantedKeywordArgs(context, keywordArgs);
        }
        if (keywordArgs != null) {
            --argsLength;
        }
        if ((blockType == null || blockType.checkArity) && (argsLength < required || !rest2 && argsLength > required + opt)) {
            Arity.raiseArgumentError(context.runtime, argsLength, required, required + opt);
        }
    }

    public static void frobnicateKwargsArgument(ThreadContext context, int requiredArguments, IRubyObject[] args2) {
        RubyHash kwargs = IRRuntimeHelpers.extractKwargsHash(args2, requiredArguments, true);
        if (kwargs != null) {
            kwargs = (RubyHash)kwargs.dup(context);
            kwargs.setFrozen(false);
            args2[args2.length - 1] = kwargs;
        }
    }

    public static RubyHash extractKwargsHash(Object[] args2, int requiredArgsCount, boolean receivesKwargs) {
        if (!receivesKwargs) {
            return null;
        }
        if (args2.length <= requiredArgsCount) {
            return null;
        }
        Object lastArg = args2[args2.length - 1];
        if (lastArg instanceof RubyHash) {
            return (RubyHash)lastArg;
        }
        if (((IRubyObject)lastArg).respondsTo("to_hash") && (lastArg = ((IRubyObject)lastArg).callMethod(((IRubyObject)lastArg).getRuntime().getCurrentContext(), "to_hash")) instanceof RubyHash) {
            return (RubyHash)lastArg;
        }
        return null;
    }

    public static void checkForExtraUnwantedKeywordArgs(final ThreadContext context, RubyHash keywordArgs) {
        final StaticScope scope = context.getCurrentStaticScope();
        keywordArgs.visitAll(new RubyHash.Visitor(){

            @Override
            public void visit(IRubyObject key2, IRubyObject value2) {
                String keyAsString = key2.asJavaString();
                int slot = scope.isDefined(keyAsString);
                if (slot >> 16 > 0) {
                    throw context.runtime.newArgumentError("unknown keyword: " + keyAsString);
                }
                if ((short)(slot & 0xFFFF) < 0) {
                    throw context.runtime.newArgumentError("unknown keyword: " + keyAsString);
                }
            }
        });
    }

    public static IRubyObject match3(ThreadContext context, RubyRegexp regexp2, IRubyObject argValue) {
        if (argValue instanceof RubyString) {
            return regexp2.op_match19(context, argValue);
        }
        return argValue.callMethod(context, "=~", regexp2);
    }

    public static IRubyObject extractOptionalArgument(RubyArray rubyArray, int minArgsLength, int index2) {
        int n = rubyArray.getLength();
        return minArgsLength < n ? rubyArray.entry(index2) : UndefinedValue.UNDEFINED;
    }

    @JIT
    public static IRubyObject isDefinedBackref(ThreadContext context) {
        return RubyMatchData.class.isInstance(context.getBackRef()) ? context.runtime.getDefinedMessage(DefinedMessage.GLOBAL_VARIABLE) : context.nil;
    }

    @JIT
    public static IRubyObject isDefinedGlobal(ThreadContext context, String name2) {
        return context.runtime.getGlobalVariables().isDefined(name2) ? context.runtime.getDefinedMessage(DefinedMessage.GLOBAL_VARIABLE) : context.nil;
    }

    @JIT
    public static IRubyObject isDefinedNthRef(ThreadContext context, int matchNumber) {
        IRubyObject backref = context.getBackRef();
        if (backref instanceof RubyMatchData && !((RubyMatchData)backref).group(matchNumber).isNil()) {
            return context.runtime.getDefinedMessage(DefinedMessage.GLOBAL_VARIABLE);
        }
        return context.nil;
    }

    @JIT
    public static IRubyObject isDefinedClassVar(ThreadContext context, RubyModule receiver2, String name2) {
        IRubyObject attached;
        boolean defined = receiver2.isClassVarDefined(name2);
        if (!defined && receiver2.isSingleton() && (attached = ((MetaClass)receiver2).getAttached()) instanceof RubyModule) {
            defined = ((RubyModule)attached).isClassVarDefined(name2);
        }
        return defined ? context.runtime.getDefinedMessage(DefinedMessage.CLASS_VARIABLE) : context.nil;
    }

    @JIT
    public static IRubyObject isDefinedInstanceVar(ThreadContext context, IRubyObject receiver2, String name2) {
        return receiver2.getInstanceVariables().hasInstanceVariable(name2) ? context.runtime.getDefinedMessage(DefinedMessage.INSTANCE_VARIABLE) : context.nil;
    }

    @JIT
    public static IRubyObject isDefinedCall(ThreadContext context, IRubyObject self2, IRubyObject receiver2, String name2) {
        RubyString boundValue = Helpers.getDefinedCall(context, self2, receiver2, name2);
        return boundValue == null ? context.nil : boundValue;
    }

    @JIT
    public static IRubyObject isDefinedConstantOrMethod(ThreadContext context, IRubyObject receiver2, String name2) {
        RubyString definedType = Helpers.getDefinedConstantOrBoundMethod(receiver2, name2);
        return definedType == null ? context.nil : definedType;
    }

    @JIT
    public static IRubyObject isDefinedMethod(ThreadContext context, IRubyObject receiver2, String name2, boolean checkIfPublic) {
        DynamicMethod method = receiver2.getMetaClass().searchMethod(name2);
        if (!(method.isUndefined() || checkIfPublic && method.getVisibility() != Visibility.PUBLIC)) {
            return context.runtime.getDefinedMessage(DefinedMessage.METHOD);
        }
        return context.nil;
    }

    @JIT
    public static IRubyObject isDefinedSuper(ThreadContext context, IRubyObject receiver2) {
        RubyModule frameClass;
        boolean flag = false;
        String frameName = context.getFrameName();
        if (frameName != null && (frameClass = context.getFrameKlazz()) != null) {
            flag = Helpers.findImplementerIfNecessary(receiver2.getMetaClass(), frameClass).getSuperClass().isMethodBound(frameName, false);
        }
        return flag ? context.runtime.getDefinedMessage(DefinedMessage.SUPER) : context.nil;
    }

    protected static void checkSuperDisabledOrOutOfMethod(ThreadContext context, RubyModule frameClass, String methodName) {
        if (frameClass == null) {
            if (methodName == null || !methodName.equals("")) {
                throw context.runtime.newNameError("superclass method '" + methodName + "' disabled", methodName);
            }
            throw context.runtime.newNoMethodError("super called outside of method", null, context.runtime.getNil());
        }
    }

    public static IRubyObject nthMatch(ThreadContext context, int matchNumber) {
        return RubyRegexp.nth_match(matchNumber, context.getBackRef());
    }

    public static void defineAlias(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, String newNameString, String oldNameString) {
        if (self2 == null || self2 instanceof RubyFixnum || self2 instanceof RubySymbol) {
            throw context.runtime.newTypeError("no class to make alias");
        }
        RubyModule module = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        module.defineAlias(newNameString, oldNameString);
        module.callMethod(context, "method_added", (IRubyObject)context.runtime.newSymbol(newNameString));
    }

    public static RubyModule getModuleFromScope(ThreadContext context, StaticScope scope, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        RubyModule rubyClass = scope.getModule();
        while (scope != null && (rubyClass.isSingleton() || rubyClass == runtime.getDummy())) {
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() != null) continue;
            runtime.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method");
        }
        if (scope == null && arg2 != null) {
            rubyClass = arg2.getMetaClass();
        }
        if (rubyClass == null) {
            throw context.runtime.newTypeError("no class/module to define class variable");
        }
        return rubyClass;
    }

    @JIT
    public static IRubyObject mergeKeywordArguments(ThreadContext context, IRubyObject restKwarg, IRubyObject explcitKwarg) {
        return ((RubyHash)TypeConverter.checkHashType(context.runtime, restKwarg)).merge(context, explcitKwarg, Block.NULL_BLOCK);
    }

    public static RubyModule findInstanceMethodContainer(ThreadContext context, DynamicScope currDynScope, IRubyObject self2) {
        boolean inBindingEval = currDynScope.inBindingEval();
        if (!inBindingEval && self2 == context.runtime.getTopSelf()) {
            return self2.getType();
        }
        DynamicScope ds = currDynScope;
        while (ds != null) {
            IRScopeType scopeType = ds.getStaticScope().getScopeType();
            switch (ds.getEvalType()) {
                case MODULE_EVAL: {
                    return self2 instanceof RubyModule ? (RubyModule)self2 : self2.getMetaClass();
                }
                case INSTANCE_EVAL: {
                    return self2.getSingletonClass();
                }
                case BINDING_EVAL: {
                    ds = ds.getParentScope();
                    break;
                }
                case NONE: {
                    if (scopeType == null || scopeType.isClosureType()) {
                        ds = ds.getParentScope();
                        break;
                    }
                    if (inBindingEval) {
                        return ds.getStaticScope().getModule();
                    }
                    if (scopeType == IRScopeType.CLASS_METHOD) {
                        return (RubyModule)self2;
                    }
                    if (scopeType == IRScopeType.INSTANCE_METHOD) {
                        return self2.getMetaClass();
                    }
                    switch (scopeType) {
                        case MODULE_BODY: 
                        case CLASS_BODY: {
                            return (RubyModule)self2;
                        }
                        case METACLASS_BODY: {
                            return (RubyModule)self2;
                        }
                    }
                    throw new RuntimeException("Should not get here! scopeType is " + (Object)((Object)scopeType));
                }
            }
        }
        throw new RuntimeException("Should not get here!");
    }

    public static RubyBoolean isBlockGiven(ThreadContext context, Object blk) {
        if (blk instanceof RubyProc) {
            blk = ((RubyProc)blk).getBlock();
        }
        if (blk instanceof RubyNil) {
            blk = Block.NULL_BLOCK;
        }
        Block b2 = (Block)blk;
        return context.runtime.newBoolean(b2.isGiven());
    }

    public static IRubyObject receiveRestArg(ThreadContext context, Object[] args2, int required, int argIndex, boolean acceptsKeywordArguments) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(args2, required, acceptsKeywordArguments);
        return IRRuntimeHelpers.constructRestArg(context, args2, keywordArguments, required, argIndex);
    }

    public static IRubyObject constructRestArg(ThreadContext context, Object[] args2, RubyHash keywordArguments, int required, int argIndex) {
        int argsLength = keywordArguments != null ? args2.length - 1 : args2.length;
        int remainingArguments = argsLength - required;
        if (remainingArguments <= 0) {
            return context.runtime.newArray(IRubyObject.NULL_ARRAY);
        }
        IRubyObject[] restArgs = new IRubyObject[remainingArguments];
        System.arraycopy(args2, argIndex, restArgs, 0, remainingArguments);
        return context.runtime.newArray(restArgs);
    }

    @JIT
    public static IRubyObject receivePostReqdArg(ThreadContext context, IRubyObject[] args2, int preReqdArgsCount, int postReqdArgsCount, int argIndex, boolean acceptsKeywordArgument) {
        boolean kwargs = IRRuntimeHelpers.extractKwargsHash(args2, preReqdArgsCount + postReqdArgsCount, acceptsKeywordArgument) != null;
        int n = kwargs ? args2.length - 1 : args2.length;
        int remaining = n - preReqdArgsCount;
        if (remaining <= argIndex) {
            return context.nil;
        }
        return remaining > postReqdArgsCount ? args2[n - postReqdArgsCount + argIndex] : args2[preReqdArgsCount + argIndex];
    }

    public static IRubyObject receiveOptArg(IRubyObject[] args2, int requiredArgs, int preArgs, int argIndex, boolean acceptsKeywordArgument) {
        int argsLength;
        int optArgIndex = argIndex;
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(args2, requiredArgs, acceptsKeywordArgument);
        int n = argsLength = keywordArguments != null ? args2.length - 1 : args2.length;
        if (requiredArgs + optArgIndex >= argsLength) {
            return UndefinedValue.UNDEFINED;
        }
        return args2[preArgs + optArgIndex];
    }

    public static IRubyObject getPreArgSafe(ThreadContext context, IRubyObject[] args2, int argIndex) {
        IRubyObject result2 = argIndex < args2.length ? args2[argIndex] : context.nil;
        return result2;
    }

    public static IRubyObject receiveKeywordArg(ThreadContext context, IRubyObject[] args2, int required, String argName, boolean acceptsKeywordArgument) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(args2, required, acceptsKeywordArgument);
        if (keywordArguments == null) {
            return UndefinedValue.UNDEFINED;
        }
        RubySymbol keywordName = context.getRuntime().newSymbol(argName);
        if (keywordArguments.fastARef(keywordName) == null) {
            return UndefinedValue.UNDEFINED;
        }
        return keywordArguments.delete(context, keywordName, Block.NULL_BLOCK);
    }

    public static IRubyObject receiveKeywordRestArg(ThreadContext context, IRubyObject[] args2, int required, boolean keywordArgumentSupplied) {
        RubyHash keywordArguments = IRRuntimeHelpers.extractKwargsHash(args2, required, keywordArgumentSupplied);
        return keywordArguments == null ? RubyHash.newSmallHash(context.getRuntime()) : keywordArguments;
    }

    public static IRubyObject setCapturedVar(ThreadContext context, IRubyObject matchRes, String varName) {
        IRubyObject val;
        if (matchRes.isNil()) {
            val = context.nil;
        } else {
            IRubyObject backref = context.getBackRef();
            int n = ((RubyMatchData)backref).getNameToBackrefNumber(varName);
            val = RubyRegexp.nth_match(n, backref);
        }
        return val;
    }

    @JIT
    public static IRubyObject instanceSuperSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.instanceSuper(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @Interp
    public static IRubyObject instanceSuper(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block) {
        RubyClass superClass = definingModule.getMethodLocation().getSuperClass();
        UndefinedMethod method = superClass != null ? superClass.searchMethod(methodName) : UndefinedMethod.INSTANCE;
        IRubyObject rVal = method.isUndefined() ? Helpers.callMethodMissing(context, self2, method.getVisibility(), methodName, CallType.SUPER, args2, block) : ((DynamicMethod)method).call(context, self2, (RubyModule)superClass, methodName, args2, block);
        return rVal;
    }

    @JIT
    public static IRubyObject classSuperSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.classSuper(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @Interp
    public static IRubyObject classSuper(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block) {
        RubyClass superClass = definingModule.getMetaClass().getSuperClass();
        UndefinedMethod method = superClass != null ? superClass.searchMethod(methodName) : UndefinedMethod.INSTANCE;
        IRubyObject rVal = method.isUndefined() ? Helpers.callMethodMissing(context, self2, method.getVisibility(), methodName, CallType.SUPER, args2, block) : ((DynamicMethod)method).call(context, self2, (RubyModule)superClass, methodName, args2, block);
        return rVal;
    }

    public static IRubyObject unresolvedSuperSplatArgs(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.unresolvedSuper(context, self2, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    public static IRubyObject unresolvedSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String methodName = context.getCurrentFrame().getName();
        IRRuntimeHelpers.checkSuperDisabledOrOutOfMethod(context, klazz, methodName);
        RubyModule implMod = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz);
        RubyClass superClass = implMod.getSuperClass();
        UndefinedMethod method = superClass != null ? superClass.searchMethod(methodName) : UndefinedMethod.INSTANCE;
        IRubyObject rVal = null;
        rVal = method.isUndefined() ? Helpers.callMethodMissing(context, self2, method.getVisibility(), methodName, CallType.SUPER, args2, block) : ((DynamicMethod)method).call(context, self2, (RubyModule)superClass, methodName, args2, block);
        return rVal;
    }

    public static IRubyObject zSuperSplatArgs(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, boolean[] splatMap) {
        if (block == null || !block.isGiven()) {
            block = context.getFrameBlock();
        }
        return IRRuntimeHelpers.unresolvedSuperSplatArgs(context, self2, args2, block, splatMap);
    }

    public static IRubyObject[] splatArguments(IRubyObject[] args2, boolean[] splatMap) {
        if (splatMap != null && splatMap.length > 0) {
            int count2 = 0;
            for (int i2 = 0; i2 < splatMap.length; ++i2) {
                count2 += splatMap[i2] ? ((RubyArray)args2[i2]).size() : 1;
            }
            IRubyObject[] newArgs = new IRubyObject[count2];
            int actualOffset = 0;
            for (int i3 = 0; i3 < splatMap.length; ++i3) {
                if (splatMap[i3]) {
                    RubyArray ary = (RubyArray)args2[i3];
                    for (int j = 0; j < ary.size(); ++j) {
                        newArgs[actualOffset++] = ary.eltOk(j);
                    }
                    continue;
                }
                newArgs[actualOffset++] = args2[i3];
            }
            args2 = newArgs;
        }
        return args2;
    }

    public static String encodeSplatmap(boolean[] splatmap) {
        if (splatmap == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (boolean b2 : splatmap) {
            builder.append(b2 ? (char)'1' : '0');
        }
        return builder.toString();
    }

    public static boolean[] decodeSplatmap(String splatmapString) {
        boolean[] splatMap;
        if (splatmapString.length() > 0) {
            splatMap = new boolean[splatmapString.length()];
            for (int i2 = 0; i2 < splatmapString.length(); ++i2) {
                if (splatmapString.charAt(i2) != '1') continue;
                splatMap[i2] = true;
            }
        } else {
            splatMap = new boolean[]{};
        }
        return splatMap;
    }

    public static boolean[] buildSplatMap(Operand[] args2, boolean containsArgSplat) {
        boolean[] splatMap = new boolean[args2.length];
        if (containsArgSplat) {
            for (int i2 = 0; i2 < args2.length; ++i2) {
                Operand operand = args2[i2];
                if (!(operand instanceof Splat)) continue;
                splatMap[i2] = true;
            }
        }
        return splatMap;
    }

    public static final Type[] typesFromSignature(Signature signature) {
        Type[] types = new Type[signature.argCount()];
        for (int i2 = 0; i2 < signature.argCount(); ++i2) {
            types[i2] = Type.getType(signature.argType(i2));
        }
        return types;
    }

    @JIT
    public static RubyString newFrozenStringFromRaw(Ruby runtime, String str, String encoding2, int cr) {
        return runtime.freezeAndDedupString(RubyString.newString(runtime, IRRuntimeHelpers.newByteListFromRaw(runtime, str, encoding2), cr));
    }

    @JIT
    public static final ByteList newByteListFromRaw(Ruby runtime, String str, String encoding2) {
        return new ByteList(str.getBytes(RubyEncoding.ISO), runtime.getEncodingService().getEncodingFromString(encoding2), false);
    }

    @JIT
    public static RubyEncoding retrieveEncoding(ThreadContext context, String name2) {
        return context.runtime.getEncodingService().getEncoding(IRRuntimeHelpers.retrieveJCodingsEncoding(context, name2));
    }

    @JIT
    public static Encoding retrieveJCodingsEncoding(ThreadContext context, String name2) {
        return context.runtime.getEncodingService().findEncodingOrAliasEntry(name2.getBytes()).getEncoding();
    }

    @JIT
    public static RubyHash constructHashFromArray(Ruby runtime, IRubyObject[] pairs) {
        int length2 = pairs.length / 2;
        boolean useSmallHash = length2 <= 10;
        RubyHash hash2 = useSmallHash ? RubyHash.newHash(runtime) : RubyHash.newSmallHash(runtime);
        int i2 = 0;
        while (i2 < pairs.length) {
            if (useSmallHash) {
                hash2.fastASetSmall(runtime, pairs[i2++], pairs[i2++], true);
                continue;
            }
            hash2.fastASet(runtime, pairs[i2++], pairs[i2++], true);
        }
        return hash2;
    }

    @JIT
    public static RubyHash dupKwargsHashAndPopulateFromArray(ThreadContext context, RubyHash dupHash, IRubyObject[] pairs) {
        Ruby runtime = context.runtime;
        RubyHash hash2 = dupHash.dupFast(context);
        int i2 = 0;
        while (i2 < pairs.length) {
            hash2.fastASet(runtime, pairs[i2++], pairs[i2++], true);
        }
        return hash2;
    }

    @JIT
    public static IRubyObject searchConst(ThreadContext context, StaticScope staticScope, String constName, boolean noPrivateConsts) {
        Ruby runtime = context.getRuntime();
        RubyClass object = runtime.getObject();
        IRubyObject constant = staticScope == null ? object.getConstant(constName) : staticScope.getConstantInner(constName);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope == null ? object : staticScope.getModule();
            IRubyObject iRubyObject = constant = noPrivateConsts ? module.getConstantFromNoConstMissing(constName, false) : module.getConstantNoConstMissing(constName);
        }
        if (constant == null) {
            return module.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(constName));
        }
        return constant;
    }

    @JIT
    public static IRubyObject inheritedSearchConst(ThreadContext context, IRubyObject cmVal, String constName, boolean noPrivateConsts) {
        IRubyObject constant;
        Ruby runtime = context.runtime;
        if (!(cmVal instanceof RubyModule)) {
            throw runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        IRubyObject iRubyObject = constant = noPrivateConsts ? module.getConstantFromNoConstMissing(constName, false) : module.getConstantNoConstMissing(constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        return constant;
    }

    @JIT
    public static IRubyObject lexicalSearchConst(ThreadContext context, StaticScope staticScope, String constName) {
        IRubyObject constant = staticScope.getConstantInner(constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        return constant;
    }

    public static IRubyObject setInstanceVariable(IRubyObject self2, IRubyObject value2, String name2) {
        return self2.getInstanceVariables().setInstanceVariable(name2, value2);
    }

    @Interp
    public static DynamicMethod newInterpretedMetaClass(Ruby runtime, IRScope metaClassBody, IRubyObject obj) {
        RubyClass singletonClass = IRRuntimeHelpers.newMetaClassFromIR(runtime, metaClassBody, obj);
        return new InterpretedIRMetaClassBody(metaClassBody, singletonClass);
    }

    @JIT
    public static DynamicMethod newCompiledMetaClass(ThreadContext context, MethodHandle handle, IRScope metaClassBody, IRubyObject obj) {
        RubyClass singletonClass = IRRuntimeHelpers.newMetaClassFromIR(context.runtime, metaClassBody, obj);
        return new CompiledIRMetaClassBody(handle, metaClassBody, singletonClass);
    }

    private static RubyClass newMetaClassFromIR(Ruby runtime, IRScope metaClassBody, IRubyObject obj) {
        RubyClass singletonClass = Helpers.getSingletonClass(runtime, obj);
        StaticScope metaClassScope = metaClassBody.getStaticScope();
        metaClassScope.setModule(singletonClass);
        return singletonClass;
    }

    @Interp
    public static DynamicMethod newInterpretedModuleBody(ThreadContext context, IRScope irModule, Object rubyContainer) {
        RubyModule newRubyModule = IRRuntimeHelpers.newRubyModuleFromIR(context, irModule, rubyContainer);
        return new InterpretedIRBodyMethod(irModule, newRubyModule);
    }

    @JIT
    public static DynamicMethod newCompiledModuleBody(ThreadContext context, MethodHandle handle, IRScope irModule, Object rubyContainer) {
        RubyModule newRubyModule = IRRuntimeHelpers.newRubyModuleFromIR(context, irModule, rubyContainer);
        return new CompiledIRMethod(handle, irModule, Visibility.PUBLIC, newRubyModule, false);
    }

    private static RubyModule newRubyModuleFromIR(ThreadContext context, IRScope irModule, Object rubyContainer) {
        if (!(rubyContainer instanceof RubyModule)) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        RubyModule newRubyModule = ((RubyModule)rubyContainer).defineOrGetModuleUnder(irModule.getName());
        irModule.getStaticScope().setModule(newRubyModule);
        return newRubyModule;
    }

    @Interp
    public static DynamicMethod newInterpretedClassBody(ThreadContext context, IRScope irClassBody, Object container, Object superClass) {
        RubyModule newRubyClass = IRRuntimeHelpers.newRubyClassFromIR(context.runtime, irClassBody, superClass, container);
        return new InterpretedIRBodyMethod(irClassBody, newRubyClass);
    }

    @JIT
    public static DynamicMethod newCompiledClassBody(ThreadContext context, MethodHandle handle, IRScope irClassBody, Object container, Object superClass) {
        RubyModule newRubyClass = IRRuntimeHelpers.newRubyClassFromIR(context.runtime, irClassBody, superClass, container);
        return new CompiledIRMethod(handle, irClassBody, Visibility.PUBLIC, newRubyClass, false);
    }

    public static RubyModule newRubyClassFromIR(Ruby runtime, IRScope irClassBody, Object superClass, Object container) {
        RubyClass newRubyClass;
        if (!(container instanceof RubyModule)) {
            throw runtime.newTypeError("no outer class/module");
        }
        if (irClassBody instanceof IRMetaClassBody) {
            newRubyClass = ((RubyModule)container).getMetaClass();
        } else {
            RubyClass sc;
            if (superClass == UndefinedValue.UNDEFINED) {
                sc = null;
            } else {
                RubyClass.checkInheritable((IRubyObject)superClass);
                sc = (RubyClass)superClass;
            }
            newRubyClass = ((RubyModule)container).defineOrGetClassUnder(irClassBody.getName(), sc);
        }
        irClassBody.getStaticScope().setModule(newRubyClass);
        return newRubyClass;
    }

    @Interp
    public static void defInterpretedClassMethod(ThreadContext context, IRScope method, IRubyObject obj) {
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, method, obj);
        DynamicMethod newMethod = context.runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.OFF ? new InterpretedIRMethod(method, Visibility.PUBLIC, rubyClass) : new MixedModeIRMethod(method, Visibility.PUBLIC, rubyClass);
        rubyClass.addMethod(method.getName(), newMethod);
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", context.runtime.fastNewSymbol(method.getName()));
        }
    }

    @JIT
    public static void defCompiledClassMethod(ThreadContext context, MethodHandle handle, IRScope method, IRubyObject obj) {
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, method, obj);
        rubyClass.addMethod(method.getName(), new CompiledIRMethod(handle, method, Visibility.PUBLIC, rubyClass, method.receivesKeywordArgs()));
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", context.runtime.fastNewSymbol(method.getName()));
        }
    }

    @JIT
    public static void defCompiledClassMethod(ThreadContext context, MethodHandle variable, MethodHandle specific, int specificArity, IRScope method, IRubyObject obj) {
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, method, obj);
        rubyClass.addMethod(method.getName(), new CompiledIRMethod(variable, specific, specificArity, method, Visibility.PUBLIC, rubyClass, method.receivesKeywordArgs()));
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", context.runtime.fastNewSymbol(method.getName()));
        }
    }

    private static RubyClass checkClassForDef(ThreadContext context, IRScope method, IRubyObject obj) {
        if (obj instanceof RubyFixnum || obj instanceof RubySymbol || obj instanceof RubyFloat) {
            throw context.runtime.newTypeError("can't define singleton method \"" + method.getName() + "\" for " + obj.getMetaClass().getBaseName());
        }
        return obj.getSingletonClass();
    }

    @Interp
    public static void defInterpretedInstanceMethod(ThreadContext context, IRScope method, DynamicScope currDynScope, IRubyObject self2) {
        Ruby runtime = context.runtime;
        RubyModule rubyClass = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(runtime, rubyClass, method.getName(), currVisibility);
        DynamicMethod newMethod = context.runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.OFF ? new InterpretedIRMethod(method, newVisibility, rubyClass) : new MixedModeIRMethod(method, newVisibility, rubyClass);
        Helpers.addInstanceMethod(rubyClass, method.getName(), newMethod, currVisibility, context, runtime);
    }

    @JIT
    public static void defCompiledInstanceMethod(ThreadContext context, MethodHandle handle, IRScope method, DynamicScope currDynScope, IRubyObject self2) {
        Ruby runtime = context.runtime;
        RubyModule clazz = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(runtime, clazz, method.getName(), currVisibility);
        CompiledIRMethod newMethod = new CompiledIRMethod(handle, method, newVisibility, clazz, method.receivesKeywordArgs());
        Helpers.addInstanceMethod(clazz, method.getName(), newMethod, currVisibility, context, runtime);
    }

    @JIT
    public static void defCompiledInstanceMethod(ThreadContext context, MethodHandle variable, MethodHandle specific, int specificArity, IRScope method, DynamicScope currDynScope, IRubyObject self2) {
        Ruby runtime = context.runtime;
        RubyModule clazz = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(runtime, clazz, method.getName(), currVisibility);
        CompiledIRMethod newMethod = new CompiledIRMethod(variable, specific, specificArity, method, newVisibility, clazz, method.receivesKeywordArgs());
        Helpers.addInstanceMethod(clazz, method.getName(), newMethod, currVisibility, context, runtime);
    }

    @JIT
    public static IRubyObject invokeModuleBody(ThreadContext context, DynamicMethod method, Block block) {
        RubyModule implClass = method.getImplementationClass();
        return method.call(context, (IRubyObject)implClass, implClass, "", block);
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject[] pieces, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context.runtime, pieces, options2);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    public static RubyRegexp newLiteralRegexp(ThreadContext context, ByteList source2, RegexpOptions options2) {
        RubyRegexp re = RubyRegexp.newRegexp(context.runtime, source2, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newLiteralRegexp(ThreadContext context, ByteList source2, int embeddedOptions) {
        return IRRuntimeHelpers.newLiteralRegexp(context, source2, RegexpOptions.fromEmbeddedOptions(embeddedOptions));
    }

    @JIT
    public static RubyArray irSplat(ThreadContext context, IRubyObject ary) {
        Ruby runtime = context.runtime;
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck19(ary, runtime.getArray(), "to_a");
        tmp = tmp.isNil() ? runtime.newArray(ary) : ((RubyArray)tmp).aryDup();
        return (RubyArray)tmp;
    }

    public static IRubyObject irToAry(ThreadContext context, IRubyObject value2) {
        if (!(value2 instanceof RubyArray)) {
            value2 = RubyArray.aryToAry(value2);
        }
        return value2;
    }

    public static int irReqdArgMultipleAsgnIndex(int n, int preArgsCount, int index2, int postArgsCount) {
        if (preArgsCount == -1) {
            return index2 < n ? index2 : -1;
        }
        int remaining = n - preArgsCount;
        if (remaining <= index2) {
            return -1;
        }
        return remaining > postArgsCount ? n - postArgsCount + index2 : preArgsCount + index2;
    }

    public static IRubyObject irReqdArgMultipleAsgn(ThreadContext context, RubyArray rubyArray, int preArgsCount, int index2, int postArgsCount) {
        int i2 = IRRuntimeHelpers.irReqdArgMultipleAsgnIndex(rubyArray.getLength(), preArgsCount, index2, postArgsCount);
        return i2 == -1 ? context.nil : rubyArray.entry(i2);
    }

    public static IRubyObject irNot(ThreadContext context, IRubyObject obj) {
        return context.runtime.newBoolean(!obj.isTrue());
    }

    @JIT
    public static RaiseException newRequiredKeywordArgumentError(ThreadContext context, String name2) {
        return context.runtime.newArgumentError("missing keyword: " + name2);
    }

    @JIT
    public static void pushExitBlock(ThreadContext context, Block blk) {
        context.runtime.pushExitBlock(context.runtime.newProc(Block.Type.LAMBDA, blk));
    }

    @JIT
    public static FunctionalCachingCallSite newFunctionalCachingCallSite(String name2) {
        return new FunctionalCachingCallSite(name2);
    }

    @JIT
    public static NormalCachingCallSite newNormalCachingCallSite(String name2) {
        return new NormalCachingCallSite(name2);
    }

    @JIT
    public static VariableCachingCallSite newVariableCachingCallSite(String name2) {
        return new VariableCachingCallSite(name2);
    }

    @JIT
    public static RefinedCachingCallSite newRefinedCachingCallSite(String name2, String callType) {
        return new RefinedCachingCallSite(name2, CallType.valueOf(callType));
    }

    @JIT
    public static IRScope decodeScopeFromBytes(Ruby runtime, byte[] scopeBytes, String filename2) {
        try {
            return IRReader.load(runtime.getIRManager(), new IRReaderStream(runtime.getIRManager(), new ByteArrayInputStream(scopeBytes), new ByteList(filename2.getBytes())));
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @JIT
    public static VariableAccessor getVariableAccessorForRead(IRubyObject object, String name2) {
        return ((RubyBasicObject)object).getMetaClass().getRealClass().getVariableAccessorForRead(name2);
    }

    @JIT
    public static VariableAccessor getVariableAccessorForWrite(IRubyObject object, String name2) {
        return ((RubyBasicObject)object).getMetaClass().getRealClass().getVariableAccessorForWrite(name2);
    }

    @JIT
    public static IRubyObject getVariableWithAccessor(IRubyObject self2, VariableAccessor accessor, ThreadContext context, String name2) {
        IRubyObject result2 = (IRubyObject)accessor.get(self2);
        if (result2 == null) {
            if (context.runtime.isVerbose()) {
                context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + name2 + " not initialized");
            }
            result2 = context.nil;
        }
        return result2;
    }

    @JIT
    public static void setVariableWithAccessor(IRubyObject self2, IRubyObject value2, VariableAccessor accessor) {
        accessor.set(self2, value2);
    }
}

