/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.x509store.CertificateFile;
import org.jruby.ext.openssl.x509store.CertificateHashDir;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Function4;
import org.jruby.ext.openssl.x509store.Function5;
import org.jruby.ext.openssl.x509store.LookupMethod;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.ext.openssl.x509store.X509Object;
import org.jruby.ext.openssl.x509store.X509Utils;
import org.jruby.util.JRubyFile;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

public class Lookup {
    boolean init = false;
    boolean skip = false;
    final LookupMethod method;
    private final Ruby runtime;
    Object methodData;
    Store store;
    private static final LookupMethod x509FileLookup = new LookupMethod();
    private static final LookupMethod x509DirectoryLookup;

    public Lookup(Ruby runtime, LookupMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        this.method = method;
        this.runtime = runtime;
        LookupMethod.NewItemFunction newItem = method.newItem;
        if (newItem != null && newItem != Function1.EMPTY) {
            int result;
            try {
                result = newItem.call(this);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalArgumentException("invalid lookup method", e);
            }
            if (result == 0) {
                throw new IllegalArgumentException("invalid lookup method");
            }
        }
    }

    public int loadFile(CertificateFile.Path file) throws Exception {
        return this.control(1, file.name, file.type, null);
    }

    public int addDir(CertificateHashDir.Dir dir) throws Exception {
        return this.control(2, dir.name, dir.type, null);
    }

    public static LookupMethod hashDirLookup() {
        return x509DirectoryLookup;
    }

    public static LookupMethod fileLookup() {
        return x509FileLookup;
    }

    public int control(int cmd, String argc, long argl, String[] ret) throws Exception {
        if (this.method == null) {
            return -1;
        }
        if (this.method.control != null && this.method.control != Function5.EMPTY) {
            return this.method.control.call(this, cmd, argc, argl, ret);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadCertificateFile(String file, int type) throws Exception {
        InputStream in;
        Reader reader;
        int ret;
        int count;
        block25: {
            if (file == null) {
                return 1;
            }
            count = 0;
            ret = 0;
            reader = null;
            in = this.wrapJRubyNormalizedInputStream(file);
            if (type != 1) {
                if (type == 2) {
                    X509Certificate cert2 = (X509Certificate)SecurityHelper.getCertificateFactory("X.509").generateCertificate(in);
                    X509AuxCertificate auxCert = StoreContext.ensureAux(cert2);
                    if (auxCert == null) {
                        X509Error.addError(13);
                        int n = ret;
                        return n;
                    }
                    int i2 = this.store.addCertificate(auxCert);
                    if (i2 == 0) {
                        int n = ret;
                        return n;
                    }
                    ret = i2;
                    return ret;
                }
                X509Error.addError(100);
                return ret;
            }
            break block25;
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        reader = new BufferedReader(new InputStreamReader(in));
        while (true) {
            X509AuxCertificate auxCert;
            if ((auxCert = PEMInputOutput.readX509Aux(reader, null)) == null) {
                ret = count;
                return ret;
            }
            int i3 = this.store.addCertificate(auxCert);
            if (i3 == 0) {
                int n = ret;
                return n;
            }
            ++count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadCRLFile(String file, int type) throws Exception {
        InputStream in;
        Reader reader;
        int ret;
        int count;
        block25: {
            if (file == null) {
                return 1;
            }
            count = 0;
            ret = 0;
            reader = null;
            in = this.wrapJRubyNormalizedInputStream(file);
            if (type != 1) {
                if (type == 2) {
                    CRL crl2 = SecurityHelper.getCertificateFactory("X.509").generateCRL(in);
                    if (crl2 == null) {
                        X509Error.addError(13);
                        int i2 = ret;
                        return i2;
                    }
                    int i3 = this.store.addCRL(crl2);
                    if (i3 == 0) {
                        int n = ret;
                        return n;
                    }
                    ret = i3;
                    return ret;
                }
                X509Error.addError(100);
                return ret;
            }
            break block25;
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        reader = new BufferedReader(new InputStreamReader(in));
        while (true) {
            X509CRL crl3;
            if ((crl3 = PEMInputOutput.readX509CRL(reader, null)) == null) {
                ret = count;
                return ret;
            }
            int i2 = this.store.addCRL(crl3);
            if (i2 == 0) {
                int n = ret;
                return n;
            }
            ++count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadCertificateOrCRLFile(String file, int type) throws Exception {
        if (type != 1) {
            return this.loadCertificateFile(file, type);
        }
        int count = 0;
        Reader reader = null;
        try {
            Object v;
            InputStream in = this.wrapJRubyNormalizedInputStream(file);
            reader = new BufferedReader(new InputStreamReader(in));
            while ((v = PEMInputOutput.readPEM(reader, null)) != null) {
                if (v instanceof X509Certificate) {
                    this.store.addCertificate(StoreContext.ensureAux((X509Certificate)v));
                    ++count;
                    continue;
                }
                if (!(v instanceof CRL)) continue;
                this.store.addCRL((CRL)v);
                ++count;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadDefaultJavaCACertsFile() throws IOException, GeneralSecurityException {
        String certsFile = X509Utils.X509_CERT_FILE.replace('/', File.separatorChar);
        FileInputStream fin = new FileInputStream(certsFile);
        int count = 0;
        try {
            KeyStore keystore = SecurityHelper.getKeyStore(KeyStore.getDefaultType());
            keystore.load(fin, null);
            PKIXParameters params2 = new PKIXParameters(keystore);
            for (TrustAnchor trustAnchor : params2.getTrustAnchors()) {
                X509Certificate certificate = trustAnchor.getTrustedCert();
                this.store.addCertificate(certificate);
                ++count;
            }
        }
        finally {
            try {
                fin.close();
            }
            catch (Exception exception) {}
        }
        return count;
    }

    private InputStream wrapJRubyNormalizedInputStream(String file) throws IOException {
        try {
            return JRubyFile.createResource((Ruby)this.runtime, (String)file).inputStream();
        }
        catch (NoSuchMethodError e) {
            try {
                ChannelDescriptor descriptor = ChannelDescriptor.open((String)this.runtime.getCurrentDirectory(), (String)file, (ModeFlags)new ModeFlags((long)ModeFlags.RDONLY));
                return ChannelStream.open((Ruby)this.runtime, (ChannelDescriptor)descriptor).newInputStream();
            }
            catch (NoSuchMethodError nsme) {
                File f = new File(file);
                if (!f.isAbsolute()) {
                    f = new File(this.runtime.getCurrentDirectory(), file);
                }
                return new BufferedInputStream(new FileInputStream(f));
            }
            catch (FileExistsException fee) {
                fee.printStackTrace(System.err);
                throw new IllegalStateException(fee.getMessage(), fee);
            }
            catch (InvalidValueException ive) {
                ive.printStackTrace(System.err);
                throw new IllegalStateException(ive.getMessage(), ive);
            }
        }
    }

    private String envEntry(String key) {
        RubyHash env = (RubyHash)this.runtime.getObject().getConstant("ENV");
        return (String)env.get((Object)this.runtime.newString(key));
    }

    public void free() throws Exception {
        if (this.method != null && this.method.free != null && this.method.free != Function1.EMPTY) {
            this.method.free.call(this);
        }
    }

    public int init() throws Exception {
        if (this.method == null) {
            return 0;
        }
        if (this.method.init != null && this.method.init != Function1.EMPTY) {
            return this.method.init.call(this);
        }
        return 1;
    }

    public int bySubject(int type, Name name2, X509Object[] ret) throws Exception {
        if (this.method == null || this.method.getBySubject == null || this.method.getBySubject == Function4.EMPTY) {
            return 0;
        }
        if (this.skip) {
            return 0;
        }
        return this.method.getBySubject.call(this, type, name2, ret);
    }

    public int byIssuerSerialNumber(int type, Name name2, BigInteger serial2, X509Object[] ret) throws Exception {
        if (this.method == null || this.method.getByIssuerSerialNumber == null || this.method.getByIssuerSerialNumber == Function5.EMPTY) {
            return 0;
        }
        return this.method.getByIssuerSerialNumber.call(this, type, name2, serial2, ret);
    }

    public int byFingerprint(int type, String bytes, X509Object[] ret) throws Exception {
        if (this.method == null || this.method.getByFingerprint == null || this.method.getByFingerprint == Function4.EMPTY) {
            return 0;
        }
        return this.method.getByFingerprint.call(this, type, bytes, ret);
    }

    public int byAlias(int type, String alias, X509Object[] ret) throws Exception {
        if (this.method == null || this.method.getByAlias == null || this.method.getByAlias == Function4.EMPTY) {
            return 0;
        }
        return this.method.getByAlias.call(this, type, alias, ret);
    }

    public int shutdown() throws Exception {
        if (this.method == null) {
            return 0;
        }
        if (this.method.shutdown != null && this.method.shutdown != Function1.EMPTY) {
            return this.method.shutdown.call(this);
        }
        return 1;
    }

    static {
        Lookup.x509FileLookup.name = "Load file into cache";
        Lookup.x509FileLookup.control = new ByFile();
        x509DirectoryLookup = new LookupMethod();
        Lookup.x509DirectoryLookup.name = "Load certs from files in a directory";
        Lookup.x509DirectoryLookup.newItem = new NewLookupDir();
        Lookup.x509DirectoryLookup.free = new FreeLookupDir();
        Lookup.x509DirectoryLookup.control = new LookupDirControl();
        Lookup.x509DirectoryLookup.getBySubject = new GetCertificateBySubject();
    }

    private static class GetCertificateBySubject
    implements LookupMethod.BySubjectFunction {
        private GetCertificateBySubject() {
        }

        @Override
        public int call(Lookup lookup, Integer type, Name name2, X509Object[] ret) throws Exception {
            String postfix;
            if (name2 == null) {
                return 0;
            }
            int ok = 0;
            if (type == 1) {
                postfix = "";
            } else if (type == 2) {
                postfix = "r";
            } else {
                X509Error.addError(112);
                return ok;
            }
            LookupDir context = (LookupDir)lookup.methodData;
            String hash2 = String.format("%08x", name2.hash());
            StringBuilder buffer = new StringBuilder(48);
            Iterator<Integer> iter = context.dirsType.iterator();
            for (String dir : context.dirs) {
                int dirType = iter.next();
                int k = 0;
                while (true) {
                    buffer.setLength(0);
                    buffer.append(dir).append(File.separatorChar);
                    buffer.append(hash2);
                    buffer.append('.').append(postfix).append(k);
                    String path = buffer.toString();
                    if (!new File(path).exists() || (type == 1 ? lookup.loadCertificateFile(path, dirType) == 0 : type == 2 && lookup.loadCRLFile(path, dirType) == 0)) break;
                    ++k;
                }
                X509Object tmp = null;
                for (X509Object obj : lookup.store.getObjects()) {
                    if (obj.type() != type.intValue() || !obj.isName(name2)) continue;
                    tmp = obj;
                    break;
                }
                if (tmp == null) continue;
                ok = 1;
                ret[0] = tmp;
                break;
            }
            return ok;
        }
    }

    private static class LookupDirControl
    implements LookupMethod.ControlFunction {
        private LookupDirControl() {
        }

        @Override
        public int call(Lookup ctx, Integer cmd, String argp, Number argl, String[] retp) {
            int ret = 0;
            LookupDir lookupData = (LookupDir)ctx.methodData;
            switch (cmd) {
                case 2: {
                    if (argl.intValue() == 3) {
                        String certDir = null;
                        try {
                            certDir = LookupDirControl.getDefaultCertificateDirectory(ctx);
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                        ret = certDir != null ? this.addCertificateDirectory(lookupData, certDir, 1) : this.addCertificateDirectory(lookupData, X509Utils.X509_CERT_DIR, 1);
                        if (ret != 0) break;
                        X509Error.addError(103);
                        break;
                    }
                    ret = this.addCertificateDirectory(lookupData, argp, argl.intValue());
                }
            }
            return ret;
        }

        private static String getDefaultCertificateDirectory(Lookup ctx) {
            return ctx.envEntry(X509Utils.getDefaultCertificateDirectoryEnvironment());
        }

        private int addCertificateDirectory(LookupDir ctx, String dir, int type) {
            if (dir == null || dir.isEmpty()) {
                X509Error.addError(113);
                return 0;
            }
            String[] dirs = dir.split(File.pathSeparator);
            for (int i2 = 0; i2 < dirs.length; ++i2) {
                if (dirs[i2].length() == 0 || ctx.dirs.contains(dirs[i2])) continue;
                ctx.dirsType.add(type);
                ctx.dirs.add(dirs[i2]);
            }
            return 1;
        }
    }

    private static class FreeLookupDir
    implements LookupMethod.FreeFunction {
        private FreeLookupDir() {
        }

        @Override
        public int call(Lookup lookup) {
            LookupDir lookupDir = (LookupDir)lookup.methodData;
            lookupDir.dirs = null;
            lookupDir.dirsType = null;
            lookup.methodData = null;
            return -1;
        }
    }

    private static class NewLookupDir
    implements LookupMethod.NewItemFunction {
        private NewLookupDir() {
        }

        @Override
        public int call(Lookup lookup) {
            LookupDir lookupDir = new LookupDir();
            lookupDir.dirs = new ArrayList<String>();
            lookupDir.dirsType = new ArrayList<Integer>();
            lookup.methodData = lookupDir;
            return 1;
        }
    }

    private static class LookupDir {
        Collection<String> dirs;
        Collection<Integer> dirsType;

        private LookupDir() {
        }
    }

    private static class ByFile
    implements LookupMethod.ControlFunction {
        private ByFile() {
        }

        @Override
        public int call(Lookup ctx, Integer cmd, String argp, Number argl, String[] ret) throws Exception {
            int ok = 0;
            String file = null;
            int arglInt = argl.intValue();
            switch (cmd) {
                case 1: {
                    if (arglInt == 3) {
                        try {
                            file = ctx.envEntry(X509Utils.getDefaultCertificateFileEnvironment());
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                        if (file != null) {
                            ok = ctx.loadCertificateOrCRLFile(file, 1) != 0 ? 1 : 0;
                        } else {
                            int n = ok = ctx.loadDefaultJavaCACertsFile() != 0 ? 1 : 0;
                        }
                        if (ok != 0) break;
                        X509Error.addError(104);
                        break;
                    }
                    ok = arglInt == 1 ? (ctx.loadCertificateOrCRLFile(argp, 1) != 0 ? 1 : 0) : (ctx.loadCertificateFile(argp, arglInt) != 0 ? 1 : 0);
                }
            }
            return ok;
        }
    }
}

