/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.SSLContext;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class SSLSocket
extends RubyObject {
    private static final long serialVersionUID = -2084816623554406237L;
    private static ObjectAllocator SSLSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new SSLSocket(runtime, klass);
        }
    };
    private SSLContext sslContext;
    private SSLEngine engine;
    private RubyIO io;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private ByteBuffer netData;
    private ByteBuffer dummy;
    private boolean initialHandshake = false;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private SSLEngineResult.Status status;
    int verifyResult = 0;

    public static void createSSLSocket(Ruby runtime, RubyModule _SSL) {
        ThreadContext context = runtime.getCurrentContext();
        RubyClass _SSLSocket = _SSL.defineClassUnder("SSLSocket", runtime.getObject(), SSLSOCKET_ALLOCATOR);
        _SSLSocket.addReadWriteAttribute(context, "io");
        _SSLSocket.addReadWriteAttribute(context, "context");
        _SSLSocket.addReadWriteAttribute(context, "sync_close");
        _SSLSocket.addReadWriteAttribute(context, "hostname");
        _SSLSocket.defineAlias("to_io", "io");
        _SSLSocket.defineAnnotatedMethods(SSLSocket.class);
    }

    public SSLSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private static RaiseException newSSLError(Ruby runtime, Exception exception) {
        return SSL.newSSLError(runtime, exception);
    }

    private static RaiseException newSSLError(Ruby runtime, String message) {
        return SSL.newSSLError(runtime, message);
    }

    private static RaiseException newSSLErrorFromHandshake(Ruby runtime, SSLHandshakeException exception) {
        Exception cause = exception;
        while (cause.getCause() != null && cause instanceof SSLHandshakeException) {
            cause = (Exception)cause.getCause();
        }
        return SSL.newSSLError(runtime, cause);
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(ThreadContext context, IRubyObject[] args, Block unused) {
        Ruby runtime = context.runtime;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)2) == 1) {
            RubyClass _SSLContext = SSL._SSL(runtime).getClass("SSLContext");
            this.sslContext = (SSLContext)_SSLContext.callMethod(context, "new");
        } else {
            this.sslContext = (SSLContext)args[1];
        }
        if (!(args[0] instanceof RubyIO)) {
            throw runtime.newTypeError("IO expected but got " + args[0].getMetaClass().getName());
        }
        this.io = (RubyIO)args[0];
        this.callMethod(context, "io=", (IRubyObject)this.io);
        this.callMethod(context, "context=", (IRubyObject)this.sslContext);
        this.io.callMethod(context, "sync=", (IRubyObject)runtime.getTrue());
        this.callMethod(context, "sync_close=", (IRubyObject)runtime.getFalse());
        this.sslContext.setup(context);
        return Utils.invokeSuper(context, (IRubyObject)this, args, unused);
    }

    private SSLEngine ossl_ssl_setup(ThreadContext context) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        SSLEngine engine = this.engine;
        if (engine != null) {
            return engine;
        }
        Socket socket = this.getSocketChannel().socket();
        String peerHost = this.callMethod(context, "hostname").toString();
        int peerPort = socket.getPort();
        engine = this.sslContext.createSSLEngine(peerHost, peerPort);
        SSLSession session = engine.getSession();
        this.peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        this.peerAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        this.netData = ByteBuffer.allocate(session.getPacketBufferSize());
        this.peerNetData.limit(0);
        this.peerAppData.limit(0);
        this.netData.limit(0);
        this.dummy = ByteBuffer.allocate(0);
        this.engine = engine;
        return this.engine;
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context) {
        return this.connectCommon(context, true);
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context) {
        return this.connectCommon(context, false);
    }

    private IRubyObject connectCommon(ThreadContext context, boolean blocking) {
        Ruby runtime = context.runtime;
        if (!this.sslContext.isProtocolForClient()) {
            throw SSLSocket.newSSLError(runtime, "called a function you should not call");
        }
        try {
            if (!this.initialHandshake) {
                SSLEngine engine = this.ossl_ssl_setup(context);
                engine.setUseClientMode(true);
                engine.beginHandshake();
                this.handshakeStatus = engine.getHandshakeStatus();
                this.initialHandshake = true;
            }
            this.doHandshake(blocking);
        }
        catch (SSLHandshakeException e) {
            this.forceClose();
            throw SSLSocket.newSSLErrorFromHandshake(runtime, e);
        }
        catch (NoSuchAlgorithmException e) {
            this.forceClose();
            throw SSLSocket.newSSLError(runtime, e);
        }
        catch (KeyManagementException e) {
            this.forceClose();
            throw SSLSocket.newSSLError(runtime, e);
        }
        catch (IOException e) {
            this.forceClose();
            throw SSLSocket.newSSLError(runtime, e);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject accept(ThreadContext context) {
        return this.acceptCommon(context, true);
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context) {
        return this.acceptCommon(context, false);
    }

    public SSLSocket acceptCommon(ThreadContext context, boolean blocking) {
        Ruby runtime = context.runtime;
        if (!this.sslContext.isProtocolForServer()) {
            throw SSLSocket.newSSLError(runtime, "called a function you should not call");
        }
        try {
            if (!this.initialHandshake) {
                IRubyObject verify_mode;
                SSLEngine engine = this.ossl_ssl_setup(context);
                engine.setUseClientMode(false);
                if (!this.sslContext.isNil() && !(verify_mode = this.sslContext.callMethod(context, "verify_mode")).isNil()) {
                    int vfy = RubyNumeric.fix2int((IRubyObject)verify_mode);
                    if (vfy == 0) {
                        engine.setNeedClientAuth(false);
                        engine.setWantClientAuth(false);
                    }
                    if ((vfy & 1) != 0) {
                        engine.setWantClientAuth(true);
                    }
                    if ((vfy & 2) != 0) {
                        engine.setNeedClientAuth(true);
                    }
                }
                engine.beginHandshake();
                this.handshakeStatus = engine.getHandshakeStatus();
                this.initialHandshake = true;
            }
            this.doHandshake(blocking);
        }
        catch (SSLHandshakeException e) {
            throw SSLSocket.newSSLErrorFromHandshake(runtime, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw SSLSocket.newSSLError(runtime, e);
        }
        catch (KeyManagementException e) {
            throw SSLSocket.newSSLError(runtime, e);
        }
        catch (IOException e) {
            throw SSLSocket.newSSLError(runtime, e);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject verify_result(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.engine == null) {
            runtime.getWarnings().warn("SSL session is not started yet.");
            return runtime.getNil();
        }
        return runtime.newFixnum(this.verifyResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitSelect(final int operations, final boolean blocking) throws IOException {
        if (!(this.io.getChannel() instanceof SelectableChannel)) {
            return true;
        }
        final Ruby runtime = this.getRuntime();
        RubyThread thread = runtime.getCurrentContext().getThread();
        SelectableChannel selectable = (SelectableChannel)this.io.getChannel();
        selectable.configureBlocking(false);
        final Selector selector = runtime.getSelectorPool().get();
        final SelectionKey key = selectable.register(selector, operations);
        try {
            Set<SelectionKey> keySet;
            this.io.addBlockingThread(thread);
            final int[] result = new int[1];
            thread.executeBlockingTask(new RubyThread.BlockingTask(){

                public void run() throws InterruptedException {
                    try {
                        if (!blocking) {
                            result[0] = selector.selectNow();
                            if (result[0] == 0) {
                                if ((operations & 1) != 0 && (operations & 4) != 0) {
                                    if (key.isReadable()) {
                                        SSLSocket.writeWouldBlock(runtime);
                                    } else if (key.isWritable()) {
                                        SSLSocket.readWouldBlock(runtime);
                                    } else {
                                        SSLSocket.readWouldBlock(runtime);
                                    }
                                } else if ((operations & 1) != 0) {
                                    SSLSocket.readWouldBlock(runtime);
                                } else if ((operations & 4) != 0) {
                                    SSLSocket.writeWouldBlock(runtime);
                                }
                            }
                        } else {
                            result[0] = selector.select();
                        }
                    }
                    catch (IOException ioe) {
                        throw runtime.newRuntimeError("Error with selector: " + ioe.getMessage());
                    }
                }

                public void wakeup() {
                    selector.wakeup();
                }
            });
            if (result[0] >= 1 && (keySet = selector.selectedKeys()).iterator().next() == key) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (key != null) {
                    key.cancel();
                }
                if (selector != null) {
                    selector.selectNow();
                }
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
            try {
                if (selector != null) {
                    runtime.getSelectorPool().put(selector);
                }
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
            this.io.removeBlockingThread(thread);
            thread.afterBlockingCall();
        }
    }

    private static void readWouldBlock(Ruby runtime) {
        throw SSL.newSSLErrorWaitReadable(runtime, "read would block");
    }

    private static void writeWouldBlock(Ruby runtime) {
        throw SSL.newSSLErrorWaitWritable(runtime, "write would block");
    }

    private void doHandshake(boolean blocking) throws IOException {
        block6: while (true) {
            boolean ready = this.waitSelect(5, blocking);
            if (!blocking && !ready) {
                throw this.getRuntime().newErrnoEAGAINError("Resource temporarily unavailable");
            }
            switch (this.handshakeStatus) {
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    if (this.initialHandshake) {
                        this.finishInitialHandshake();
                    }
                    return;
                }
                case NEED_TASK: {
                    this.doTasks();
                    continue block6;
                }
                case NEED_UNWRAP: {
                    if (this.readAndUnwrap(blocking) == -1 && this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
                        throw new SSLHandshakeException("Socket closed");
                    }
                    if (!this.initialHandshake || this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue block6;
                    this.waitSelect(1, blocking);
                    continue block6;
                }
                case NEED_WRAP: {
                    if (this.netData.hasRemaining()) {
                        while (this.flushData(blocking)) {
                        }
                    }
                    this.netData.clear();
                    SSLEngineResult result = this.engine.wrap(this.dummy, this.netData);
                    this.handshakeStatus = result.getHandshakeStatus();
                    this.netData.flip();
                    this.flushData(blocking);
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException("Unknown handshaking status: " + (Object)((Object)this.handshakeStatus));
    }

    private void doTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            task.run();
        }
        this.handshakeStatus = this.engine.getHandshakeStatus();
        this.verifyResult = this.sslContext.getLastVerifyResult();
    }

    private boolean flushData(boolean blocking) throws IOException {
        try {
            this.writeToChannel(this.netData, blocking);
        }
        catch (IOException ioe) {
            this.netData.position(this.netData.limit());
            throw ioe;
        }
        return this.netData.hasRemaining();
    }

    private int writeToChannel(ByteBuffer buffer, boolean blocking) throws IOException {
        int totalWritten = 0;
        while (buffer.hasRemaining()) {
            totalWritten += this.getSocketChannel().write(buffer);
            if (blocking) continue;
            break;
        }
        return totalWritten;
    }

    private void finishInitialHandshake() {
        this.initialHandshake = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src, boolean blocking) throws SSLException, IOException {
        if (this.initialHandshake) {
            throw new IOException("Writing not possible during handshake");
        }
        SocketChannel selectable = this.getSocketChannel();
        boolean blockingMode = ((SelectableChannel)selectable).isBlocking();
        if (!blocking) {
            ((SelectableChannel)selectable).configureBlocking(false);
        }
        try {
            if (this.netData.hasRemaining()) {
                this.flushData(blocking);
            }
            this.netData.clear();
            SSLEngineResult res = this.engine.wrap(src, this.netData);
            if (res.getStatus() == SSLEngineResult.Status.CLOSED) {
                throw this.getRuntime().newIOError("closed SSL engine");
            }
            this.netData.flip();
            this.flushData(blocking);
            int n = res.bytesConsumed();
            return n;
        }
        finally {
            if (!blocking) {
                ((SelectableChannel)selectable).configureBlocking(blockingMode);
            }
        }
    }

    public int read(ByteBuffer dst, boolean blocking) throws IOException {
        int appBytesProduced;
        if (this.initialHandshake) {
            return 0;
        }
        if (this.engine.isInboundDone()) {
            return -1;
        }
        if (!(this.peerAppData.hasRemaining() || (appBytesProduced = this.readAndUnwrap(blocking)) != -1 && appBytesProduced != 0)) {
            return appBytesProduced;
        }
        int limit = Math.min(this.peerAppData.remaining(), dst.remaining());
        this.peerAppData.get(dst.array(), dst.arrayOffset(), limit);
        dst.position(dst.arrayOffset() + limit);
        return limit;
    }

    private int readAndUnwrap(boolean blocking) throws IOException {
        SSLEngineResult res;
        int bytesRead = this.getSocketChannel().read(this.peerNetData);
        if (!(bytesRead != -1 || this.peerNetData.hasRemaining() && this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
            this.closeInbound();
            return -1;
        }
        this.peerAppData.clear();
        this.peerNetData.flip();
        while ((res = this.engine.unwrap(this.peerNetData, this.peerAppData)).getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && res.bytesProduced() == 0) {
        }
        if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.finishInitialHandshake();
        }
        if (this.peerAppData.position() == 0 && res.getStatus() == SSLEngineResult.Status.OK && this.peerNetData.hasRemaining()) {
            res = this.engine.unwrap(this.peerNetData, this.peerAppData);
        }
        this.status = res.getStatus();
        this.handshakeStatus = res.getHandshakeStatus();
        if (bytesRead == -1 && !this.peerNetData.hasRemaining()) {
            this.closeInbound();
        }
        if (this.status == SSLEngineResult.Status.CLOSED) {
            this.doShutdown();
            return -1;
        }
        this.peerNetData.compact();
        this.peerAppData.flip();
        if (!(this.initialHandshake || this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK && this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP && this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED)) {
            this.doHandshake(blocking);
        }
        return this.peerAppData.remaining();
    }

    private void closeInbound() {
        try {
            this.engine.closeInbound();
        }
        catch (SSLException e) {
            OpenSSL.debug(this.getRuntime(), "SSLSocket.closeInbound", e);
        }
    }

    private void doShutdown() throws IOException {
        if (this.engine.isOutboundDone()) {
            return;
        }
        this.netData.clear();
        try {
            this.engine.wrap(this.dummy, this.netData);
        }
        catch (SSLException e) {
            OpenSSL.debug(this.getRuntime(), "SSLSocket.doShutdown", e);
            return;
        }
        catch (RuntimeException e) {
            OpenSSL.debugStackTrace(this.getRuntime(), e);
            return;
        }
        this.netData.flip();
        this.flushData(true);
    }

    private IRubyObject do_sysread(ThreadContext context, IRubyObject[] args, boolean blocking) {
        Ruby runtime = context.runtime;
        int len = RubyNumeric.fix2int((IRubyObject)args[0]);
        RubyString buff = args.length == 2 && !args[1].isNil() ? args[1].asString() : runtime.newString();
        if (len == 0) {
            buff.clear();
            return buff;
        }
        if (len < 0) {
            throw runtime.newArgumentError("negative string size (or size too big)");
        }
        try {
            if (this.engine == null || !this.peerAppData.hasRemaining() && this.peerNetData.position() <= 0) {
                this.waitSelect(1, blocking);
            }
            ByteBuffer dst = ByteBuffer.allocate(len);
            int rr = -1;
            while (rr <= 0) {
                rr = this.engine == null ? this.getSocketChannel().read(dst) : this.read(dst, blocking);
                if (rr == -1) {
                    throw runtime.newEOFError();
                }
                if (rr != 0 || this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                this.waitSelect(1, blocking);
            }
            byte[] bss = new byte[rr];
            dst.position(dst.position() - rr);
            dst.get(bss);
            buff.setValue(new ByteList(bss, false));
            return buff;
        }
        catch (IOException ioe) {
            throw runtime.newIOError(ioe.getMessage());
        }
    }

    @JRubyMethod(rest=true, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args) {
        return this.do_sysread(context, args, true);
    }

    @JRubyMethod(rest=true, required=1, optional=2)
    public IRubyObject sysread_nonblock(ThreadContext context, IRubyObject[] args) {
        return this.do_sysread(context, args, false);
    }

    private IRubyObject do_syswrite(ThreadContext context, IRubyObject arg, boolean blocking) {
        Ruby runtime = context.runtime;
        try {
            this.checkClosed();
            this.waitSelect(4, blocking);
            ByteList bls = arg.asString().getByteList();
            ByteBuffer b1 = ByteBuffer.wrap(bls.getUnsafeBytes(), bls.getBegin(), bls.getRealSize());
            int written = this.engine == null ? this.writeToChannel(b1, blocking) : this.write(b1, blocking);
            this.callMethod(context, "io").callMethod(context, "flush");
            return runtime.newFixnum(written);
        }
        catch (IOException ioe) {
            throw runtime.newIOError(ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject syswrite(ThreadContext context, IRubyObject arg) {
        return this.do_syswrite(context, arg, true);
    }

    @JRubyMethod
    public IRubyObject syswrite_nonblock(ThreadContext context, IRubyObject arg) {
        return this.do_syswrite(context, arg, false);
    }

    @JRubyMethod
    public IRubyObject syswrite_nonblock(ThreadContext context, IRubyObject arg, IRubyObject options) {
        return this.do_syswrite(context, arg, false);
    }

    private void checkClosed() {
        if (!this.getSocketChannel().isOpen()) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    private void forceClose() {
        this.close(true);
    }

    private void close(boolean force) {
        if (this.engine == null) {
            throw this.getRuntime().newEOFError();
        }
        this.engine.closeOutbound();
        if (!force && this.netData.hasRemaining()) {
            return;
        }
        try {
            this.doShutdown();
        }
        catch (IOException e) {
            OpenSSL.debug(this.getRuntime(), "SSLSocket.close doShutdown failed", e);
        }
    }

    @JRubyMethod
    public IRubyObject sysclose(ThreadContext context) {
        this.close(this.sslContext.isProtocolForClient());
        if (this.callMethod(context, "sync_close").isTrue()) {
            this.callMethod(context, "io").callMethod(context, "close");
        }
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject cert() {
        Ruby runtime = this.getRuntime();
        if (this.engine == null) {
            return runtime.getNil();
        }
        try {
            Certificate[] cert2 = this.engine.getSession().getLocalCertificates();
            if (cert2 != null && cert2.length > 0) {
                return X509Cert.wrap(runtime, cert2[0]);
            }
        }
        catch (java.security.cert.CertificateEncodingException e) {
            throw X509Cert.newCertificateError(runtime, e);
        }
        return runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject peer_cert() {
        Ruby runtime;
        block5: {
            runtime = this.getRuntime();
            if (this.engine == null) {
                return runtime.getNil();
            }
            try {
                Certificate[] cert2 = this.engine.getSession().getPeerCertificates();
                if (cert2.length > 0) {
                    return X509Cert.wrap(runtime, cert2[0]);
                }
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw X509Cert.newCertificateError(runtime, e);
            }
            catch (SSLPeerUnverifiedException e) {
                if (!runtime.isVerbose() && !OpenSSL.isDebug(runtime)) break block5;
                runtime.getWarnings().warning(String.format("%s: %s", e.getClass().getName(), e.getMessage()));
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject peer_cert_chain() {
        Ruby runtime = this.getRuntime();
        if (this.engine == null) {
            return runtime.getNil();
        }
        try {
            X509Certificate[] certs = this.engine.getSession().getPeerCertificateChain();
            RubyArray arr = runtime.newArray(certs.length);
            for (int i2 = 0; i2 < certs.length; ++i2) {
                arr.append(X509Cert.wrap(runtime, certs[i2]));
            }
            return arr;
        }
        catch (CertificateEncodingException e) {
            throw X509Cert.newCertificateError(this.getRuntime(), e);
        }
        catch (SSLPeerUnverifiedException e) {
            if (runtime.isVerbose() || OpenSSL.isDebug(runtime)) {
                runtime.getWarnings().warning(String.format("%s: %s", e.getClass().getName(), e.getMessage()));
            }
            return runtime.getNil();
        }
    }

    @JRubyMethod
    public IRubyObject cipher() {
        if (this.engine == null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newString(this.engine.getSession().getCipherSuite());
    }

    @JRubyMethod
    public IRubyObject state() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: SSLSocket#state");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject pending() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: SSLSocket#pending");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"session_reused?"})
    public IRubyObject session_reused_p() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: SSLSocket#session_reused? is not supported");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"session="})
    public IRubyObject set_session(IRubyObject session) {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: SSLSocket#session= is not supported");
        return this.getRuntime().getNil();
    }

    private SocketChannel getSocketChannel() {
        return (SocketChannel)this.io.getChannel();
    }
}

