/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import org.jruby.truffle.pack.nodes.PackGuards;
import org.jruby.truffle.pack.runtime.PackFrameDescriptor;
import org.jruby.truffle.pack.runtime.exceptions.TooFewArgumentsException;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

@ImportStatic(value={PackGuards.class})
public abstract class PackNode
extends Node {
    private final RubyContext context;
    private final ConditionProfile writeMoreThanZeroBytes = ConditionProfile.createBinaryProfile();

    public PackNode(RubyContext context) {
        this.context = context;
    }

    public abstract Object execute(VirtualFrame var1);

    public int getSourceLength(VirtualFrame frame) {
        try {
            return frame.getInt(PackFrameDescriptor.SOURCE_LENGTH_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected int getSourcePosition(VirtualFrame frame) {
        try {
            return frame.getInt(PackFrameDescriptor.SOURCE_POSITION_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setSourcePosition(VirtualFrame frame, int position) {
        frame.setInt(PackFrameDescriptor.SOURCE_POSITION_SLOT, position);
    }

    protected int advanceSourcePosition(VirtualFrame frame) {
        int sourcePosition = this.getSourcePosition(frame);
        if (sourcePosition == this.getSourceLength(frame)) {
            CompilerDirectives.transferToInterpreter();
            throw new TooFewArgumentsException();
        }
        this.setSourcePosition(frame, sourcePosition + 1);
        return sourcePosition;
    }

    protected byte[] getOutput(VirtualFrame frame) {
        try {
            return (byte[])frame.getObject(PackFrameDescriptor.OUTPUT_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setOutput(VirtualFrame frame, byte[] output) {
        CompilerAsserts.neverPartOfCompilation();
        frame.setObject(PackFrameDescriptor.OUTPUT_SLOT, output);
    }

    protected int getOutputPosition(VirtualFrame frame) {
        try {
            return frame.getInt(PackFrameDescriptor.OUTPUT_POSITION_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setOutputPosition(VirtualFrame frame, int position) {
        frame.setInt(PackFrameDescriptor.OUTPUT_POSITION_SLOT, position);
    }

    protected void setTainted(VirtualFrame frame) {
        frame.setBoolean(PackFrameDescriptor.TAINT_SLOT, true);
    }

    protected void writeByte(VirtualFrame frame, byte value) {
        byte[] output = this.ensureCapacity(frame, 1);
        int outputPosition = this.getOutputPosition(frame);
        output[outputPosition] = value;
        this.setOutputPosition(frame, outputPosition + 1);
    }

    protected void writeBytes(VirtualFrame frame, byte ... values) {
        this.writeBytes(frame, values, 0, values.length);
    }

    protected void writeBytes(VirtualFrame frame, ByteList values) {
        this.writeBytes(frame, values.getUnsafeBytes(), values.begin(), values.length());
    }

    protected void writeBytes(VirtualFrame frame, byte[] values, int valuesStart, int valuesLength) {
        byte[] output = this.ensureCapacity(frame, valuesLength);
        int outputPosition = this.getOutputPosition(frame);
        System.arraycopy(values, valuesStart, output, outputPosition, valuesLength);
        this.setOutputPosition(frame, outputPosition + valuesLength);
    }

    protected void writeNullBytes(VirtualFrame frame, int length) {
        if (this.writeMoreThanZeroBytes.profile(length > 0)) {
            this.ensureCapacity(frame, length);
            int outputPosition = this.getOutputPosition(frame);
            this.setOutputPosition(frame, outputPosition + length);
        }
    }

    private byte[] ensureCapacity(VirtualFrame frame, int length) {
        byte[] output = this.getOutput(frame);
        int outputPosition = this.getOutputPosition(frame);
        if (outputPosition + length > output.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            output = Arrays.copyOf(output, (output.length + length) * 2);
            this.setOutput(frame, output);
        }
        return output;
    }

    protected RubyContext getContext() {
        return this.context;
    }

    protected boolean isNil(Object object) {
        return object == this.context.getCoreLibrary().getNilObject();
    }
}

