/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.methods.CallMethodNode;
import org.jruby.truffle.nodes.methods.CallMethodNodeGen;
import org.jruby.truffle.nodes.supercall.LookupSuperMethodNode;
import org.jruby.truffle.nodes.supercall.LookupSuperMethodNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class GeneralSuperReCallNode
extends RubyNode {
    private final boolean inBlock;
    private final boolean isSplatted;
    @Node.Children
    private final RubyNode[] reloadNodes;
    @Node.Child
    private RubyNode block;
    @Node.Child
    LookupSuperMethodNode lookupSuperMethodNode;
    @Node.Child
    CallMethodNode callMethodNode;

    public GeneralSuperReCallNode(RubyContext context, SourceSection sourceSection, boolean inBlock, boolean isSplatted, RubyNode[] reloadNodes, RubyNode block) {
        super(context, sourceSection);
        this.inBlock = inBlock;
        this.isSplatted = isSplatted;
        this.reloadNodes = reloadNodes;
        this.block = block;
        this.lookupSuperMethodNode = LookupSuperMethodNodeGen.create(context, sourceSection, null);
        this.callMethodNode = CallMethodNodeGen.create(context, sourceSection, null, new RubyNode[0]);
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object blockTempObject;
        CompilerAsserts.compilationConstant(this.reloadNodes.length);
        Object self = RubyArguments.getSelf(frame.getArguments());
        Object[] originalArguments = this.inBlock ? RubyArguments.getDeclarationFrame(frame.getArguments()).getArguments() : frame.getArguments();
        Object[] superArguments = RubyArguments.extractUserArguments(originalArguments);
        if (!this.inBlock) {
            superArguments = new Object[this.reloadNodes.length];
            for (int n = 0; n < superArguments.length; ++n) {
                superArguments[n] = this.reloadNodes[n].execute(frame);
            }
            if (this.isSplatted) {
                CompilerDirectives.transferToInterpreter();
                assert (superArguments.length == 1);
                assert (RubyGuards.isRubyArray(superArguments[0]));
                superArguments = ArrayNodes.slowToArray((RubyBasicObject)superArguments[0]);
            }
        }
        Object blockObject = this.block != null ? ((blockTempObject = this.block.execute(frame)) == this.nil() ? null : (RubyBasicObject)blockTempObject) : RubyArguments.getBlock(originalArguments);
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            CompilerDirectives.transferToInterpreter();
            String name = RubyArguments.getMethod(frame.getArguments()).getSharedMethodInfo().getName();
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(String.format("super: no superclass method `%s'", name), name, this));
        }
        Object[] frameArguments = RubyArguments.pack(superMethod, RubyArguments.getDeclarationFrame(originalArguments), RubyArguments.getSelf(originalArguments), (RubyBasicObject)blockObject, superArguments);
        return this.callMethodNode.executeCallMethod(frame, superMethod, frameArguments);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object self = RubyArguments.getSelf(frame.getArguments());
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            return this.nil();
        }
        return this.createString("super");
    }
}

