/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.core.fixnum.FixnumLowerNodeGen;
import org.jruby.truffle.nodes.objects.SelfNode;
import org.jruby.truffle.nodes.rubinius.CallRubiniusPrimitiveNode;
import org.jruby.truffle.nodes.rubinius.InvokeRubiniusPrimitiveNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveConstructor;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;

public class RubiniusPrimitiveNodeConstructor
implements RubiniusPrimitiveConstructor {
    private final RubiniusPrimitive annotation;
    private final NodeFactory<? extends RubyNode> factory;

    public RubiniusPrimitiveNodeConstructor(RubiniusPrimitive annotation, NodeFactory<? extends RubyNode> factory) {
        this.annotation = annotation;
        this.factory = factory;
    }

    @Override
    public int getPrimitiveArity() {
        return this.factory.getExecutionSignature().size();
    }

    @Override
    public RubyNode createCallPrimitiveNode(RubyContext context, SourceSection sourceSection, long returnID) {
        int argumentsCount = this.getPrimitiveArity();
        ArrayList<RubyNode> arguments = new ArrayList<RubyNode>(argumentsCount);
        if (this.annotation.needsSelf()) {
            arguments.add(new SelfNode(context, sourceSection));
            --argumentsCount;
        }
        for (int n = 0; n < argumentsCount; ++n) {
            ReadPreArgumentNode readArgumentNode = new ReadPreArgumentNode(context, sourceSection, n, MissingArgumentBehaviour.UNDEFINED);
            arguments.add(this.transformArgument(readArgumentNode, n));
        }
        return new CallRubiniusPrimitiveNode(context, sourceSection, this.factory.createNode(context, sourceSection, arguments.toArray(new RubyNode[arguments.size()])), returnID);
    }

    @Override
    public RubyNode createInvokePrimitiveNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
        for (int n = 1; n < arguments.length; ++n) {
            arguments[n] = this.transformArgument(arguments[n], n);
        }
        return new InvokeRubiniusPrimitiveNode(context, sourceSection, this.factory.createNode(context, sourceSection, arguments));
    }

    private RubyNode transformArgument(RubyNode argument, int n) {
        if (ArrayUtils.contains(this.annotation.lowerFixnumParameters(), n)) {
            return FixnumLowerNodeGen.create(argument.getContext(), argument.getSourceSection(), argument);
        }
        return argument;
    }
}

