/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.object.BasicObjectType;

public abstract class PointerNodes {
    public static final Pointer NULL_POINTER = Runtime.getSystemRuntime().getMemoryManager().newOpaquePointer(0L);
    public static final PointerType POINTER_TYPE = new PointerType();
    private static final HiddenKey POINTER_IDENTIFIER = new HiddenKey("pointer");
    private static final Property POINTER_PROPERTY;
    private static final DynamicObjectFactory POINTER_FACTORY;

    public static RubyBasicObject createPointer(RubyClass rubyClass, Pointer pointer) {
        if (pointer == null) {
            pointer = NULL_POINTER;
        }
        return new RubyBasicObject(rubyClass, POINTER_FACTORY.newInstance(pointer));
    }

    public static void setPointer(RubyBasicObject pointer, Pointer newPointer) {
        assert (RubyGuards.isRubyPointer(pointer));
        assert (pointer.getDynamicObject().getShape().hasProperty(POINTER_IDENTIFIER));
        assert (newPointer != null);
        try {
            POINTER_PROPERTY.set(pointer.getDynamicObject(), newPointer, pointer.getDynamicObject().getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static Pointer getPointer(RubyBasicObject pointer) {
        assert (RubyGuards.isRubyPointer(pointer));
        assert (pointer.getDynamicObject().getShape().hasProperty(POINTER_IDENTIFIER));
        return (Pointer)POINTER_PROPERTY.get(pointer.getDynamicObject(), true);
    }

    static {
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        POINTER_PROPERTY = Property.create(POINTER_IDENTIFIER, allocator.locationForType(Pointer.class, EnumSet.of(LocationModifier.NonNull)), 0);
        POINTER_FACTORY = RubyBasicObject.LAYOUT.createShape(POINTER_TYPE).addProperty(POINTER_PROPERTY).createFactory();
    }

    public static class PointerAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return PointerNodes.createPointer(rubyClass, NULL_POINTER);
        }
    }

    public static class PointerType
    extends BasicObjectType {
    }
}

