/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.exceptions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ThreadExitException;
import org.jruby.truffle.runtime.core.RubyException;

public class TopLevelRaiseHandler
extends RubyNode {
    @Node.Child
    private RubyNode body;

    public TopLevelRaiseHandler(RubyContext context, SourceSection sourceSection, RubyNode body) {
        super(context, sourceSection);
        this.body = body;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.body.execute(frame);
        }
        catch (RaiseException e) {
            RubyException rubyException = e.getRubyException();
            for (String line : Backtrace.DISPLAY_FORMATTER.format(this.getContext(), rubyException, rubyException.getBacktrace())) {
                System.err.println(line);
            }
            System.exit(1);
        }
        catch (ThreadExitException threadExitException) {
            // empty catch block
        }
        return this.nil();
    }
}

