/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.fixnum;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.fixnum.FixnumNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=FixnumNodes.class)
public final class FixnumNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(NegNodeFactory.getInstance(), AddNodeFactory.getInstance(), SubNodeFactory.getInstance(), MulNodeFactory.getInstance(), DivNodeFactory.getInstance(), ModNodeFactory.getInstance(), DivModNodeFactory.getInstance(), LessNodeFactory.getInstance(), LessEqualNodeFactory.getInstance(), EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), GreaterEqualNodeFactory.getInstance(), GreaterNodeFactory.getInstance(), ComplementNodeFactory.getInstance(), BitAndNodeFactory.getInstance(), BitOrNodeFactory.getInstance(), BitXOrNodeFactory.getInstance(), LeftShiftNodeFactory.getInstance(), RightShiftNodeFactory.getInstance(), AbsNodeFactory.getInstance(), BitLengthNodeFactory.getInstance(), FloorNodeFactory.getInstance(), InspectNodeFactory.getInstance(), SizeNodeFactory.getInstance(), ToFNodeFactory.getInstance(), ToSNodeFactory.getInstance(), ZeroNodeFactory.getInstance());
    }

    @GeneratedBy(value=FixnumNodes.ZeroNode.class)
    public static final class ZeroNodeFactory
    extends NodeFactoryBase<FixnumNodes.ZeroNode> {
        private static ZeroNodeFactory zeroNodeFactoryInstance;

        private ZeroNodeFactory() {
            super(FixnumNodes.ZeroNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.ZeroNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ZeroNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.ZeroNode> getInstance() {
            if (zeroNodeFactoryInstance == null) {
                zeroNodeFactoryInstance = new ZeroNodeFactory();
            }
            return zeroNodeFactoryInstance;
        }

        public static FixnumNodes.ZeroNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ZeroNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.ZeroNode.class)
        public static final class ZeroNodeGen
        extends FixnumNodes.ZeroNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ZeroNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="zero(long)", value=FixnumNodes.ZeroNode.class)
            private static final class Zero1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Zero1Node_(ZeroNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Zero1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeBoolean_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.zero(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.zero(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ZeroNodeGen root, Object arguments0Value) {
                    return new Zero1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="zero(int)", value=FixnumNodes.ZeroNode.class)
            private static final class Zero0Node_
            extends BaseNode_ {
                Zero0Node_(ZeroNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.zero(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.zero(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ZeroNodeGen root) {
                    return new Zero0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ZeroNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ZeroNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ZeroNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ZeroNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ZeroNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ZeroNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ZeroNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ZeroNodeGen root;

                BaseNode_(ZeroNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        return Zero0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Zero1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<FixnumNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(FixnumNodes.ToSNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static FixnumNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToSNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends FixnumNodes.ToSNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToSNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="toS(long, int)", value=FixnumNodes.ToSNode.class)
            private static final class ToS2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                ToS2Node_(ToSNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((ToS2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.toS(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.toS(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ToSNodeGen root, Object arguments0Value) {
                    return new ToS2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="toS(long, NotProvided)", value=FixnumNodes.ToSNode.class)
            private static final class ToS1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                ToS1Node_(ToSNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((ToS1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.toS(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof NotProvided) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.toS(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ToSNodeGen root, Object arguments0Value) {
                    return new ToS1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="toS(int, NotProvided)", value=FixnumNodes.ToSNode.class)
            private static final class ToS0Node_
            extends BaseNode_ {
                ToS0Node_(ToSNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.toS(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof NotProvided) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.toS(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new ToS0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ToSNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToSNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ToSNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToSNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ToSNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ToSNodeGen root;

                BaseNode_(ToSNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        if (arguments0Value instanceof Integer) {
                            return ToS0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                            return ToS1Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value) && arguments1Value instanceof Integer) {
                        return ToS2Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.ToFNode.class)
    public static final class ToFNodeFactory
    extends NodeFactoryBase<FixnumNodes.ToFNode> {
        private static ToFNodeFactory toFNodeFactoryInstance;

        private ToFNodeFactory() {
            super(FixnumNodes.ToFNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.ToFNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToFNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.ToFNode> getInstance() {
            if (toFNodeFactoryInstance == null) {
                toFNodeFactoryInstance = new ToFNodeFactory();
            }
            return toFNodeFactoryInstance;
        }

        public static FixnumNodes.ToFNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToFNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.ToFNode.class)
        public static final class ToFNodeGen
        extends FixnumNodes.ToFNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToFNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="toF(long)", value=FixnumNodes.ToFNode.class)
            private static final class ToF1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                ToF1Node_(ToFNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((ToF1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.toF(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.toF(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToFNodeGen root, Object arguments0Value) {
                    return new ToF1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="toF(int)", value=FixnumNodes.ToFNode.class)
            private static final class ToF0Node_
            extends BaseNode_ {
                ToF0Node_(ToFNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.toF(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.toF(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToFNodeGen root) {
                    return new ToF0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ToFNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToFNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToFNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ToFNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToFNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ToFNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ToFNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ToFNodeGen root;

                BaseNode_(ToFNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        return ToF0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return ToF1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<FixnumNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(FixnumNodes.SizeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static FixnumNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SizeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends FixnumNodes.SizeNode {
            private SizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.size();
            }

            protected UnsupportedSpecializationException unsupported() {
                return new UnsupportedSpecializationException(this, new Node[0], new Object[0]);
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.InspectNode.class)
    public static final class InspectNodeFactory
    extends NodeFactoryBase<FixnumNodes.InspectNode> {
        private static InspectNodeFactory inspectNodeFactoryInstance;

        private InspectNodeFactory() {
            super(FixnumNodes.InspectNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.InspectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InspectNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.InspectNode> getInstance() {
            if (inspectNodeFactoryInstance == null) {
                inspectNodeFactoryInstance = new InspectNodeFactory();
            }
            return inspectNodeFactoryInstance;
        }

        public static FixnumNodes.InspectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InspectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.InspectNode.class)
        public static final class InspectNodeGen
        extends FixnumNodes.InspectNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private InspectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="inspect(long)", value=FixnumNodes.InspectNode.class)
            private static final class Inspect1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Inspect1Node_(InspectNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Inspect1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.inspect(arguments0Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.inspect(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InspectNodeGen root, Object arguments0Value) {
                    return new Inspect1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="inspect(int)", value=FixnumNodes.InspectNode.class)
            private static final class Inspect0Node_
            extends BaseNode_ {
                Inspect0Node_(InspectNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult());
                    }
                    return this.root.inspect(arguments0Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.inspect(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InspectNodeGen root) {
                    return new Inspect0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.InspectNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InspectNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InspectNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.InspectNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InspectNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(InspectNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.InspectNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InspectNodeGen root;

                BaseNode_(InspectNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        return Inspect0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Inspect1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.FloorNode.class)
    public static final class FloorNodeFactory
    extends NodeFactoryBase<FixnumNodes.FloorNode> {
        private static FloorNodeFactory floorNodeFactoryInstance;

        private FloorNodeFactory() {
            super(FixnumNodes.FloorNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.FloorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FloorNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.FloorNode> getInstance() {
            if (floorNodeFactoryInstance == null) {
                floorNodeFactoryInstance = new FloorNodeFactory();
            }
            return floorNodeFactoryInstance;
        }

        public static FixnumNodes.FloorNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new FloorNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.FloorNode.class)
        public static final class FloorNodeGen
        extends FixnumNodes.FloorNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private FloorNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="floor(long)", value=FixnumNodes.FloorNode.class)
            private static final class Floor1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Floor1Node_(FloorNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Floor1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return FloorNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                        }
                    }
                    return this.root.floor(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.floor(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FloorNodeGen root, Object arguments0Value) {
                    return new Floor1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="floor(int)", value=FixnumNodes.FloorNode.class)
            private static final class Floor0Node_
            extends BaseNode_ {
                Floor0Node_(FloorNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return FloorNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.floor(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.floor(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FloorNodeGen root) {
                    return new Floor0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.FloorNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FloorNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FloorNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.FloorNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FloorNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(FloorNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.FloorNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final FloorNodeGen root;

                BaseNode_(FloorNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return FloorNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return FloorNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        return Floor0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Floor1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
    public static final class BitLengthNodeFactory
    extends NodeFactoryBase<FixnumNodes.BitLengthNode> {
        private static BitLengthNodeFactory bitLengthNodeFactoryInstance;

        private BitLengthNodeFactory() {
            super(FixnumNodes.BitLengthNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.BitLengthNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitLengthNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.BitLengthNode> getInstance() {
            if (bitLengthNodeFactoryInstance == null) {
                bitLengthNodeFactoryInstance = new BitLengthNodeFactory();
            }
            return bitLengthNodeFactoryInstance;
        }

        public static FixnumNodes.BitLengthNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BitLengthNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
        public static final class BitLengthNodeGen
        extends FixnumNodes.BitLengthNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private BitLengthNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="bitLength(long)", value=FixnumNodes.BitLengthNode.class)
            private static final class BitLength1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                BitLength1Node_(BitLengthNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((BitLength1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeInt_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.bitLength(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.bitLength(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BitLengthNodeGen root, Object arguments0Value) {
                    return new BitLength1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="bitLength(int)", value=FixnumNodes.BitLengthNode.class)
            private static final class BitLength0Node_
            extends BaseNode_ {
                BitLength0Node_(BitLengthNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.bitLength(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.bitLength(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BitLengthNodeGen root) {
                    return new BitLength0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BitLengthNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BitLengthNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BitLengthNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(BitLengthNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final BitLengthNodeGen root;

                BaseNode_(BitLengthNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        return BitLength0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return BitLength1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.AbsNode.class)
    public static final class AbsNodeFactory
    extends NodeFactoryBase<FixnumNodes.AbsNode> {
        private static AbsNodeFactory absNodeFactoryInstance;

        private AbsNodeFactory() {
            super(FixnumNodes.AbsNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.AbsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AbsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.AbsNode> getInstance() {
            if (absNodeFactoryInstance == null) {
                absNodeFactoryInstance = new AbsNodeFactory();
            }
            return absNodeFactoryInstance;
        }

        public static FixnumNodes.AbsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AbsNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.AbsNode.class)
        public static final class AbsNodeGen
        extends FixnumNodes.AbsNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeAbsIntInBounds_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeAbsInBounds_;
            @Node.Child
            private BaseNode_ specialization_;

            private AbsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="abs(long)", value=FixnumNodes.AbsNode.class)
            private static final class Abs1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Abs1Node_(AbsNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Abs1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, ex.getResult());
                    }
                    return this.root.abs(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.abs(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbsNodeGen root, Object arguments0Value) {
                    return new Abs1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="absInBounds(long)", value=FixnumNodes.AbsNode.class)
            private static final class AbsInBoundsNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                AbsInBoundsNode_(AbsNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    if (newNode.getClass() == Abs1Node_.class) {
                        this.removeSame("Contained by abs(long)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((AbsInBoundsNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return AbsNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    try {
                        return this.root.absInBounds(arguments0Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeAbsInBounds_ = true;
                        return AbsNodeGen.expectLong(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        try {
                            return this.root.absInBounds(arguments0Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeAbsInBounds_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbsNodeGen root, Object arguments0Value) {
                    return new AbsInBoundsNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="abs(int)", value=FixnumNodes.AbsNode.class)
            private static final class Abs0Node_
            extends BaseNode_ {
                Abs0Node_(AbsNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, ex.getResult());
                    }
                    return this.root.abs(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.abs(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbsNodeGen root) {
                    return new Abs0Node_(root);
                }
            }

            @GeneratedBy(methodName="absIntInBounds(int)", value=FixnumNodes.AbsNode.class)
            private static final class AbsIntInBoundsNode_
            extends BaseNode_ {
                AbsIntInBoundsNode_(AbsNodeGen root) {
                    super(root, 1);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    if (newNode.getClass() == Abs0Node_.class) {
                        this.removeSame("Contained by abs(int)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return AbsNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    try {
                        return this.root.absIntInBounds(arguments0Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeAbsIntInBounds_ = true;
                        return AbsNodeGen.expectInteger(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        try {
                            return this.root.absIntInBounds(arguments0Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeAbsIntInBounds_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbsNodeGen root) {
                    return new AbsIntInBoundsNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.AbsNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AbsNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbsNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.AbsNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AbsNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(AbsNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.AbsNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final AbsNodeGen root;

                BaseNode_(AbsNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return AbsNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return AbsNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        if (!this.root.excludeAbsIntInBounds_) {
                            return AbsIntInBoundsNode_.create(this.root);
                        }
                        this.root.excludeAbsIntInBounds_ = true;
                        return Abs0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (!this.root.excludeAbsInBounds_) {
                            return AbsInBoundsNode_.create(this.root, arguments0Value);
                        }
                        this.root.excludeAbsInBounds_ = true;
                        return Abs1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
    public static final class RightShiftNodeFactory
    extends NodeFactoryBase<FixnumNodes.RightShiftNode> {
        private static RightShiftNodeFactory rightShiftNodeFactoryInstance;

        private RightShiftNodeFactory() {
            super(FixnumNodes.RightShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.RightShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RightShiftNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.RightShiftNode> getInstance() {
            if (rightShiftNodeFactoryInstance == null) {
                rightShiftNodeFactoryInstance = new RightShiftNodeFactory();
            }
            return rightShiftNodeFactoryInstance;
        }

        public static FixnumNodes.RightShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RightShiftNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
        public static final class RightShiftNodeGen
        extends FixnumNodes.RightShiftNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private RightShiftNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            protected Object executeRightShift(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="rightShiftFallback(VirtualFrame, Object, Object)", value=FixnumNodes.RightShiftNode.class)
            private static final class RightShiftFallbackNode_
            extends BaseNode_ {
                RightShiftFallbackNode_(RightShiftNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value)) {
                        return this.root.rightShiftFallback(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RightShiftNodeGen root) {
                    return new RightShiftFallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="rightShift(long, RubyBasicObject)", value=FixnumNodes.RightShiftNode.class)
            private static final class RightShift4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                RightShift4Node_(RightShiftNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((RightShift4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return RightShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return RightShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.rightShift(arguments0Value_, arguments1Value_);
                    }
                    return RightShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.rightShift(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RightShiftNodeGen root, Object arguments0Value) {
                    return new RightShift4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="rightShift(int, RubyBasicObject)", value=FixnumNodes.RightShiftNode.class)
            private static final class RightShift3Node_
            extends BaseNode_ {
                RightShift3Node_(RightShiftNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return RightShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return RightShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.rightShift(arguments0Value_, arguments1Value_);
                    }
                    return RightShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.rightShift(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RightShiftNodeGen root) {
                    return new RightShift3Node_(root);
                }
            }

            @GeneratedBy(methodName="rightShift(VirtualFrame, long, int)", value=FixnumNodes.RightShiftNode.class)
            private static final class RightShift2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                RightShift2Node_(RightShiftNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((RightShift2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute1(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute1(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.rightShift(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.rightShift(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RightShiftNodeGen root, Object arguments0Value) {
                    return new RightShift2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="rightShift(VirtualFrame, int, long)", value=FixnumNodes.RightShiftNode.class)
            private static final class RightShift1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                RightShift1Node_(RightShiftNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((RightShift1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().execute1(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute1(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.rightShift(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.rightShift(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RightShiftNodeGen root, Object arguments1Value) {
                    return new RightShift1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="rightShift(VirtualFrame, int, int)", value=FixnumNodes.RightShiftNode.class)
            private static final class RightShift0Node_
            extends BaseNode_ {
                RightShift0Node_(RightShiftNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute1(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute1(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.rightShift(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.rightShift(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RightShiftNodeGen root) {
                    return new RightShift0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RightShiftNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RightShiftNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RightShiftNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RightShiftNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final RightShiftNodeGen root;

                BaseNode_(RightShiftNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute1((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute1(VirtualFrame var1, Object var2, Object var3);

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute1(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return RightShiftNodeGen.expectInteger(this.execute0(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return RightShift0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return RightShift1Node_.create(this.root, arguments1Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value) && arguments1Value instanceof Integer) {
                        return RightShift2Node_.create(this.root, arguments0Value);
                    }
                    if (arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (arguments0Value instanceof Integer && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return RightShift3Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments0Value) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return RightShift4Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value)) {
                        return RightShiftFallbackNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
    public static final class LeftShiftNodeFactory
    extends NodeFactoryBase<FixnumNodes.LeftShiftNode> {
        private static LeftShiftNodeFactory leftShiftNodeFactoryInstance;

        private LeftShiftNodeFactory() {
            super(FixnumNodes.LeftShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.LeftShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LeftShiftNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.LeftShiftNode> getInstance() {
            if (leftShiftNodeFactoryInstance == null) {
                leftShiftNodeFactoryInstance = new LeftShiftNodeFactory();
            }
            return leftShiftNodeFactoryInstance;
        }

        public static FixnumNodes.LeftShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LeftShiftNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        public static final class LeftShiftNodeGen
        extends FixnumNodes.LeftShiftNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LeftShiftNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="leftShiftFallback(VirtualFrame, Object, Object)", value=FixnumNodes.LeftShiftNode.class)
            private static final class LeftShiftFallbackNode_
            extends BaseNode_ {
                LeftShiftFallbackNode_(LeftShiftNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value)) {
                        return this.root.leftShiftFallback(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LeftShiftNodeGen root) {
                    return new LeftShiftFallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="leftShiftNeg(long, int)", value=FixnumNodes.LeftShiftNode.class)
            private static final class LeftShiftNeg1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                LeftShiftNeg1Node_(LeftShiftNodeGen root, Object arguments0Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((LeftShiftNeg1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LeftShiftNodeGen.expectLong(this.getNext().execute1(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LeftShiftNodeGen.expectLong(this.getNext().execute1(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (FixnumNodes.LeftShiftNode.isStrictlyNegative(arguments1Value_)) {
                        return this.root.leftShiftNeg(arguments0Value_, arguments1Value_);
                    }
                    return LeftShiftNodeGen.expectLong(this.getNext().execute1(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (FixnumNodes.LeftShiftNode.isStrictlyNegative(arguments1Value_)) {
                            return this.root.leftShiftNeg(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LeftShiftNodeGen root, Object arguments0Value) {
                    return new LeftShiftNeg1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="leftShiftWithOverflow(long, int)", value=FixnumNodes.LeftShiftNode.class)
            private static final class LeftShiftWithOverflowNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                LeftShiftWithOverflowNode_(LeftShiftNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((LeftShiftWithOverflowNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute1(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute1(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (FixnumNodes.LeftShiftNode.isPositive(arguments1Value_)) {
                        return this.root.leftShiftWithOverflow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1Value_)) {
                            return this.root.leftShiftWithOverflow(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LeftShiftNodeGen root, Object arguments0Value) {
                    return new LeftShiftWithOverflowNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="leftShiftToLong(long, int)", value=FixnumNodes.LeftShiftNode.class)
            private static final class LeftShiftToLongNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                LeftShiftToLongNode_(LeftShiftNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((LeftShiftToLongNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LeftShiftNodeGen.expectLong(this.getNext().execute1(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LeftShiftNodeGen.expectLong(this.getNext().execute1(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (FixnumNodes.LeftShiftNode.isPositive(arguments1Value_) && FixnumNodes.LeftShiftNode.canShiftIntoLong(arguments0Value_, arguments1Value_)) {
                        return this.root.leftShiftToLong(arguments0Value_, arguments1Value_);
                    }
                    return LeftShiftNodeGen.expectLong(this.getNext().execute1(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1Value_) && FixnumNodes.LeftShiftNode.canShiftIntoLong(arguments0Value_, arguments1Value_)) {
                            return this.root.leftShiftToLong(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LeftShiftNodeGen root, Object arguments0Value) {
                    return new LeftShiftToLongNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="leftShiftNeg(int, int)", value=FixnumNodes.LeftShiftNode.class)
            private static final class LeftShiftNeg0Node_
            extends BaseNode_ {
                LeftShiftNeg0Node_(LeftShiftNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LeftShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LeftShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (FixnumNodes.LeftShiftNode.isStrictlyNegative(arguments1Value_)) {
                        return this.root.leftShiftNeg(arguments0Value_, arguments1Value_);
                    }
                    return LeftShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (FixnumNodes.LeftShiftNode.isStrictlyNegative(arguments1Value_)) {
                            return this.root.leftShiftNeg(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LeftShiftNodeGen root) {
                    return new LeftShiftNeg0Node_(root);
                }
            }

            @GeneratedBy(methodName="leftShift(int, long)", value=FixnumNodes.LeftShiftNode.class)
            private static final class LeftShift1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                LeftShift1Node_(LeftShiftNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((LeftShift1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    int arguments0Value_;
                    block7: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return LeftShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block7;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block7;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return LeftShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    if (FixnumNodes.LeftShiftNode.isPositive(arguments1Value_) && FixnumNodes.LeftShiftNode.canShiftIntoInt(arguments0Value_, arguments1Value_)) {
                        return this.root.leftShift(arguments0Value_, arguments1Value_);
                    }
                    return LeftShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1Value_) && FixnumNodes.LeftShiftNode.canShiftIntoInt(arguments0Value_, arguments1Value_)) {
                            return this.root.leftShift(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LeftShiftNodeGen root, Object arguments1Value) {
                    return new LeftShift1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="leftShift(int, int)", value=FixnumNodes.LeftShiftNode.class)
            private static final class LeftShift0Node_
            extends BaseNode_ {
                LeftShift0Node_(LeftShiftNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LeftShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LeftShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (FixnumNodes.LeftShiftNode.isPositive(arguments1Value_) && FixnumNodes.LeftShiftNode.canShiftIntoInt(arguments0Value_, arguments1Value_)) {
                        return this.root.leftShift(arguments0Value_, arguments1Value_);
                    }
                    return LeftShiftNodeGen.expectInteger(this.getNext().execute1(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1Value_) && FixnumNodes.LeftShiftNode.canShiftIntoInt(arguments0Value_, arguments1Value_)) {
                            return this.root.leftShift(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LeftShiftNodeGen root) {
                    return new LeftShift0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LeftShiftNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LeftShiftNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LeftShiftNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LeftShiftNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LeftShiftNodeGen root;

                BaseNode_(LeftShiftNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute1((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute1(VirtualFrame var1, Object var2, Object var3);

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute1(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return LeftShiftNodeGen.expectInteger(this.execute0(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return LeftShiftNodeGen.expectLong(this.execute0(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments1Value_;
                        int arguments0Value_ = (Integer)arguments0Value;
                        if (arguments1Value instanceof Integer && FixnumNodes.LeftShiftNode.isPositive(arguments1Value_ = ((Integer)arguments1Value).intValue()) && FixnumNodes.LeftShiftNode.canShiftIntoInt(arguments0Value_, arguments1Value_)) {
                            return LeftShift0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && FixnumNodes.LeftShiftNode.isPositive(arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value)) && FixnumNodes.LeftShiftNode.canShiftIntoInt(arguments0Value_, arguments1Value_)) {
                            return LeftShift1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Integer && FixnumNodes.LeftShiftNode.isStrictlyNegative(arguments1Value_ = ((Integer)arguments1Value).intValue())) {
                            return LeftShiftNeg0Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1Value_) && FixnumNodes.LeftShiftNode.canShiftIntoLong(arguments0Value_, arguments1Value_)) {
                            return LeftShiftToLongNode_.create(this.root, arguments0Value);
                        }
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1Value_)) {
                            return LeftShiftWithOverflowNode_.create(this.root, arguments0Value);
                        }
                        if (FixnumNodes.LeftShiftNode.isStrictlyNegative(arguments1Value_)) {
                            return LeftShiftNeg1Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value)) {
                        return LeftShiftFallbackNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
    public static final class BitXOrNodeFactory
    extends NodeFactoryBase<FixnumNodes.BitXOrNode> {
        private static BitXOrNodeFactory bitXOrNodeFactoryInstance;

        private BitXOrNodeFactory() {
            super(FixnumNodes.BitXOrNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.BitXOrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitXOrNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.BitXOrNode> getInstance() {
            if (bitXOrNodeFactoryInstance == null) {
                bitXOrNodeFactoryInstance = new BitXOrNodeFactory();
            }
            return bitXOrNodeFactoryInstance;
        }

        public static FixnumNodes.BitXOrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BitXOrNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
        public static final class BitXOrNodeGen
        extends FixnumNodes.BitXOrNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private BitXOrNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="bitXOr(VirtualFrame, Object, RubyBasicObject)", value=FixnumNodes.BitXOrNode.class)
            private static final class BitXOr3Node_
            extends BaseNode_ {
                BitXOr3Node_(BitXOrNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments1Value instanceof RubyBasicObject && !RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                        return this.root.bitXOr(frameValue, arguments0Value, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitXOrNodeGen root) {
                    return new BitXOr3Node_(root);
                }
            }

            @GeneratedBy(methodName="bitXOr(long, RubyBasicObject)", value=FixnumNodes.BitXOrNode.class)
            private static final class BitXOr2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                BitXOr2Node_(BitXOrNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((BitXOr2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.bitXOr(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.bitXOr(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitXOrNodeGen root, Object arguments0Value) {
                    return new BitXOr2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="bitXOr(long, long)", value=FixnumNodes.BitXOrNode.class)
            private static final class BitXOr1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                BitXOr1Node_(BitXOrNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((BitXOr1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((BitXOr1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return BitXOrNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return BitXOrNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.bitXOr(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.bitXOr(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitXOrNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new BitXOr1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="bitXOr(int, int)", value=FixnumNodes.BitXOrNode.class)
            private static final class BitXOr0Node_
            extends BaseNode_ {
                BitXOr0Node_(BitXOrNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return BitXOrNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return BitXOrNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.bitXOr(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.bitXOr(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitXOrNodeGen root) {
                    return new BitXOr0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BitXOrNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitXOrNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BitXOrNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitXOrNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final BitXOrNodeGen root;

                BaseNode_(BitXOrNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return BitXOrNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return BitXOrNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        return BitXOr0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return BitXOr1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return BitXOr2Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (arguments1Value instanceof RubyBasicObject && !RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                        return BitXOr3Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.BitOrNode.class)
    public static final class BitOrNodeFactory
    extends NodeFactoryBase<FixnumNodes.BitOrNode> {
        private static BitOrNodeFactory bitOrNodeFactoryInstance;

        private BitOrNodeFactory() {
            super(FixnumNodes.BitOrNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.BitOrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitOrNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.BitOrNode> getInstance() {
            if (bitOrNodeFactoryInstance == null) {
                bitOrNodeFactoryInstance = new BitOrNodeFactory();
            }
            return bitOrNodeFactoryInstance;
        }

        public static FixnumNodes.BitOrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BitOrNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.BitOrNode.class)
        public static final class BitOrNodeGen
        extends FixnumNodes.BitOrNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private BitOrNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="bitOr(long, RubyBasicObject)", value=FixnumNodes.BitOrNode.class)
            private static final class BitOr2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                BitOr2Node_(BitOrNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((BitOr2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.bitOr(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.bitOr(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitOrNodeGen root, Object arguments0Value) {
                    return new BitOr2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="bitOr(long, long)", value=FixnumNodes.BitOrNode.class)
            private static final class BitOr1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                BitOr1Node_(BitOrNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((BitOr1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((BitOr1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return BitOrNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return BitOrNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.bitOr(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.bitOr(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitOrNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new BitOr1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="bitOr(int, int)", value=FixnumNodes.BitOrNode.class)
            private static final class BitOr0Node_
            extends BaseNode_ {
                BitOr0Node_(BitOrNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return BitOrNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return BitOrNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.bitOr(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.bitOr(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitOrNodeGen root) {
                    return new BitOr0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitOrNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BitOrNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitOrNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitOrNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BitOrNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitOrNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitOrNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final BitOrNodeGen root;

                BaseNode_(BitOrNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return BitOrNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return BitOrNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        return BitOr0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return BitOr1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return BitOr2Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.BitAndNode.class)
    public static final class BitAndNodeFactory
    extends NodeFactoryBase<FixnumNodes.BitAndNode> {
        private static BitAndNodeFactory bitAndNodeFactoryInstance;

        private BitAndNodeFactory() {
            super(FixnumNodes.BitAndNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.BitAndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitAndNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.BitAndNode> getInstance() {
            if (bitAndNodeFactoryInstance == null) {
                bitAndNodeFactoryInstance = new BitAndNodeFactory();
            }
            return bitAndNodeFactoryInstance;
        }

        public static FixnumNodes.BitAndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BitAndNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.BitAndNode.class)
        public static final class BitAndNodeGen
        extends FixnumNodes.BitAndNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private BitAndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="bitAnd(long, RubyBasicObject)", value=FixnumNodes.BitAndNode.class)
            private static final class BitAnd2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                BitAnd2Node_(BitAndNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((BitAnd2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.bitAnd(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.bitAnd(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitAndNodeGen root, Object arguments0Value) {
                    return new BitAnd2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="bitAnd(long, long)", value=FixnumNodes.BitAndNode.class)
            private static final class BitAnd1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                BitAnd1Node_(BitAndNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((BitAnd1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((BitAnd1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return BitAndNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return BitAndNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.bitAnd(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.bitAnd(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitAndNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new BitAnd1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="bitAnd(int, int)", value=FixnumNodes.BitAndNode.class)
            private static final class BitAnd0Node_
            extends BaseNode_ {
                BitAnd0Node_(BitAndNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return BitAndNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return BitAndNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.bitAnd(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.bitAnd(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitAndNodeGen root) {
                    return new BitAnd0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitAndNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BitAndNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitAndNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitAndNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BitAndNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BitAndNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.BitAndNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final BitAndNodeGen root;

                BaseNode_(BitAndNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return BitAndNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return BitAndNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        return BitAnd0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return BitAnd1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return BitAnd2Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.ComplementNode.class)
    public static final class ComplementNodeFactory
    extends NodeFactoryBase<FixnumNodes.ComplementNode> {
        private static ComplementNodeFactory complementNodeFactoryInstance;

        private ComplementNodeFactory() {
            super(FixnumNodes.ComplementNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.ComplementNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ComplementNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.ComplementNode> getInstance() {
            if (complementNodeFactoryInstance == null) {
                complementNodeFactoryInstance = new ComplementNodeFactory();
            }
            return complementNodeFactoryInstance;
        }

        public static FixnumNodes.ComplementNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ComplementNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.ComplementNode.class)
        public static final class ComplementNodeGen
        extends FixnumNodes.ComplementNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ComplementNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="complement(long)", value=FixnumNodes.ComplementNode.class)
            private static final class Complement1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Complement1Node_(ComplementNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Complement1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return ComplementNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                        }
                    }
                    return this.root.complement(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.complement(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ComplementNodeGen root, Object arguments0Value) {
                    return new Complement1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="complement(int)", value=FixnumNodes.ComplementNode.class)
            private static final class Complement0Node_
            extends BaseNode_ {
                Complement0Node_(ComplementNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ComplementNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.complement(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.complement(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ComplementNodeGen root) {
                    return new Complement0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ComplementNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ComplementNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ComplementNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ComplementNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ComplementNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ComplementNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ComplementNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ComplementNodeGen root;

                BaseNode_(ComplementNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ComplementNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ComplementNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        return Complement0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Complement1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.GreaterNode.class)
    public static final class GreaterNodeFactory
    extends NodeFactoryBase<FixnumNodes.GreaterNode> {
        private static GreaterNodeFactory greaterNodeFactoryInstance;

        private GreaterNodeFactory() {
            super(FixnumNodes.GreaterNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.GreaterNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GreaterNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.GreaterNode> getInstance() {
            if (greaterNodeFactoryInstance == null) {
                greaterNodeFactoryInstance = new GreaterNodeFactory();
            }
            return greaterNodeFactoryInstance;
        }

        public static FixnumNodes.GreaterNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GreaterNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        public static final class GreaterNodeGen
        extends FixnumNodes.GreaterNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GreaterNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="greaterCoerced(VirtualFrame, long, Object)", value=FixnumNodes.GreaterNode.class)
            private static final class GreaterCoercedNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                GreaterCoercedNode_(GreaterNodeGen root, Object arguments0Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((GreaterCoercedNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    if (!(RubyGuards.isRubyBignum(arguments1Value_) || RubyGuards.isInteger(arguments1Value_) || RubyGuards.isLong(arguments1Value_) || RubyGuards.isDouble(arguments1Value_))) {
                        return this.root.greaterCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return this.root.greaterCoerced(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root, Object arguments0Value) {
                    return new GreaterCoercedNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="greater(long, RubyBasicObject)", value=FixnumNodes.GreaterNode.class)
            private static final class Greater4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Greater4Node_(GreaterNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Greater4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.greater(arguments0Value_, arguments1Value_);
                    }
                    return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.greater(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root, Object arguments0Value) {
                    return new Greater4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="greater(long, double)", value=FixnumNodes.GreaterNode.class)
            private static final class Greater3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Greater3Node_(GreaterNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Greater3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.greater(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.greater(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root, Object arguments0Value) {
                    return new Greater3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="greater(long, long)", value=FixnumNodes.GreaterNode.class)
            private static final class Greater2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Greater2Node_(GreaterNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Greater2Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Greater2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.greater(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.greater(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Greater2Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="greater(int, RubyBasicObject)", value=FixnumNodes.GreaterNode.class)
            private static final class Greater1Node_
            extends BaseNode_ {
                Greater1Node_(GreaterNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.greater(arguments0Value_, arguments1Value_);
                    }
                    return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.greater(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root) {
                    return new Greater1Node_(root);
                }
            }

            @GeneratedBy(methodName="greater(int, int)", value=FixnumNodes.GreaterNode.class)
            private static final class Greater0Node_
            extends BaseNode_ {
                Greater0Node_(GreaterNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.greater(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.greater(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root) {
                    return new Greater0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.GreaterNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GreaterNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.GreaterNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GreaterNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.GreaterNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final GreaterNodeGen root;

                BaseNode_(GreaterNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return GreaterNodeGen.expectBoolean(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return Greater0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Greater1Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Greater2Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Greater3Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Greater4Node_.create(this.root, arguments0Value);
                        }
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return GreaterCoercedNode_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
    public static final class GreaterEqualNodeFactory
    extends NodeFactoryBase<FixnumNodes.GreaterEqualNode> {
        private static GreaterEqualNodeFactory greaterEqualNodeFactoryInstance;

        private GreaterEqualNodeFactory() {
            super(FixnumNodes.GreaterEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.GreaterEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GreaterEqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.GreaterEqualNode> getInstance() {
            if (greaterEqualNodeFactoryInstance == null) {
                greaterEqualNodeFactoryInstance = new GreaterEqualNodeFactory();
            }
            return greaterEqualNodeFactoryInstance;
        }

        public static FixnumNodes.GreaterEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GreaterEqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        public static final class GreaterEqualNodeGen
        extends FixnumNodes.GreaterEqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GreaterEqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="greaterEqualCoerced(VirtualFrame, long, Object)", value=FixnumNodes.GreaterEqualNode.class)
            private static final class GreaterEqualCoercedNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                GreaterEqualCoercedNode_(GreaterEqualNodeGen root, Object arguments0Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((GreaterEqualCoercedNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    if (!(RubyGuards.isRubyBignum(arguments1Value_) || RubyGuards.isInteger(arguments1Value_) || RubyGuards.isLong(arguments1Value_) || RubyGuards.isDouble(arguments1Value_))) {
                        return this.root.greaterEqualCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return this.root.greaterEqualCoerced(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root, Object arguments0Value) {
                    return new GreaterEqualCoercedNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="greaterEqual(long, RubyBasicObject)", value=FixnumNodes.GreaterEqualNode.class)
            private static final class GreaterEqual4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                GreaterEqual4Node_(GreaterEqualNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((GreaterEqual4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                    }
                    return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root, Object arguments0Value) {
                    return new GreaterEqual4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="greaterEqual(long, double)", value=FixnumNodes.GreaterEqualNode.class)
            private static final class GreaterEqual3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                GreaterEqual3Node_(GreaterEqualNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((GreaterEqual3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root, Object arguments0Value) {
                    return new GreaterEqual3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="greaterEqual(long, long)", value=FixnumNodes.GreaterEqualNode.class)
            private static final class GreaterEqual2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                GreaterEqual2Node_(GreaterEqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((GreaterEqual2Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((GreaterEqual2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new GreaterEqual2Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="greaterEqual(int, RubyBasicObject)", value=FixnumNodes.GreaterEqualNode.class)
            private static final class GreaterEqual1Node_
            extends BaseNode_ {
                GreaterEqual1Node_(GreaterEqualNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                    }
                    return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root) {
                    return new GreaterEqual1Node_(root);
                }
            }

            @GeneratedBy(methodName="greaterEqual(int, int)", value=FixnumNodes.GreaterEqualNode.class)
            private static final class GreaterEqual0Node_
            extends BaseNode_ {
                GreaterEqual0Node_(GreaterEqualNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return GreaterEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.greaterEqual(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root) {
                    return new GreaterEqual0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GreaterEqualNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GreaterEqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GreaterEqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final GreaterEqualNodeGen root;

                BaseNode_(GreaterEqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return GreaterEqualNodeGen.expectBoolean(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return GreaterEqual0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return GreaterEqual1Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return GreaterEqual2Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return GreaterEqual3Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return GreaterEqual4Node_.create(this.root, arguments0Value);
                        }
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return GreaterEqualCoercedNode_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<FixnumNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(FixnumNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        public static FixnumNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompareNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        public static final class CompareNodeGen
        extends FixnumNodes.CompareNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompareNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="compare(VirtualFrame, Object, Object)", value=FixnumNodes.CompareNode.class)
            private static final class Compare5Node_
            extends BaseNode_ {
                Compare5Node_(CompareNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (!(RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value) || RubyGuards.isRubyBignum(arguments1Value))) {
                        return this.root.compare(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare5Node_(root);
                }
            }

            @GeneratedBy(methodName="compare(long, RubyBasicObject)", value=FixnumNodes.CompareNode.class)
            private static final class Compare4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Compare4Node_(CompareNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Compare4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.compare(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root, Object arguments0Value) {
                    return new Compare4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="compare(long, double)", value=FixnumNodes.CompareNode.class)
            private static final class Compare3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Compare3Node_(CompareNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Compare3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.compare(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root, Object arguments0Value) {
                    return new Compare3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="compare(long, long)", value=FixnumNodes.CompareNode.class)
            private static final class Compare2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Compare2Node_(CompareNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Compare2Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Compare2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.compare(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Compare2Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="compare(int, RubyBasicObject)", value=FixnumNodes.CompareNode.class)
            private static final class Compare1Node_
            extends BaseNode_ {
                Compare1Node_(CompareNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.compare(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare1Node_(root);
                }
            }

            @GeneratedBy(methodName="compare(int, int)", value=FixnumNodes.CompareNode.class)
            private static final class Compare0Node_
            extends BaseNode_ {
                Compare0Node_(CompareNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.compare(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.CompareNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompareNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.CompareNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompareNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.CompareNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CompareNodeGen root;

                BaseNode_(CompareNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return CompareNodeGen.expectInteger(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return Compare0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Compare1Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Compare2Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Compare3Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Compare4Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (!(RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value) || RubyGuards.isRubyBignum(arguments1Value))) {
                        return Compare5Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<FixnumNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(FixnumNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        public static FixnumNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        public static final class EqualNodeGen
        extends FixnumNodes.EqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private EqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="equal(VirtualFrame, Object, Object)", value=FixnumNodes.EqualNode.class)
            private static final class Equal5Node_
            extends BaseNode_ {
                Equal5Node_(EqualNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (!(RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isRubyBignum(arguments1Value))) {
                        return this.root.equal(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal5Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(long, RubyBasicObject)", value=FixnumNodes.EqualNode.class)
            private static final class Equal4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Equal4Node_(EqualNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Equal4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.equal(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root, Object arguments0Value) {
                    return new Equal4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="equal(long, double)", value=FixnumNodes.EqualNode.class)
            private static final class Equal3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Equal3Node_(EqualNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Equal3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root, Object arguments0Value) {
                    return new Equal3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="equal(long, long)", value=FixnumNodes.EqualNode.class)
            private static final class Equal2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Equal2Node_(EqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Equal2Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Equal2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Equal2Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="equal(int, RubyBasicObject)", value=FixnumNodes.EqualNode.class)
            private static final class Equal1Node_
            extends BaseNode_ {
                Equal1Node_(EqualNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.equal(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal1Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(int, int)", value=FixnumNodes.EqualNode.class)
            private static final class Equal0Node_
            extends BaseNode_ {
                Equal0Node_(EqualNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return EqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.EqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EqualNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.EqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.EqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EqualNodeGen root;

                BaseNode_(EqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return EqualNodeGen.expectBoolean(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return Equal0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Equal1Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Equal2Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Equal3Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Equal4Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (!(RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isRubyBignum(arguments1Value))) {
                        return Equal5Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
    public static final class LessEqualNodeFactory
    extends NodeFactoryBase<FixnumNodes.LessEqualNode> {
        private static LessEqualNodeFactory lessEqualNodeFactoryInstance;

        private LessEqualNodeFactory() {
            super(FixnumNodes.LessEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.LessEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LessEqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.LessEqualNode> getInstance() {
            if (lessEqualNodeFactoryInstance == null) {
                lessEqualNodeFactoryInstance = new LessEqualNodeFactory();
            }
            return lessEqualNodeFactoryInstance;
        }

        public static FixnumNodes.LessEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LessEqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        public static final class LessEqualNodeGen
        extends FixnumNodes.LessEqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LessEqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="lessEqualCoerced(VirtualFrame, long, Object)", value=FixnumNodes.LessEqualNode.class)
            private static final class LessEqualCoercedNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                LessEqualCoercedNode_(LessEqualNodeGen root, Object arguments0Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((LessEqualCoercedNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    if (!(RubyGuards.isRubyBignum(arguments1Value_) || RubyGuards.isInteger(arguments1Value_) || RubyGuards.isLong(arguments1Value_) || RubyGuards.isDouble(arguments1Value_))) {
                        return this.root.lessEqualCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return this.root.lessEqualCoerced(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root, Object arguments0Value) {
                    return new LessEqualCoercedNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="lessEqual(long, RubyBasicObject)", value=FixnumNodes.LessEqualNode.class)
            private static final class LessEqual4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                LessEqual4Node_(LessEqualNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((LessEqual4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.lessEqual(arguments0Value_, arguments1Value_);
                    }
                    return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.lessEqual(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root, Object arguments0Value) {
                    return new LessEqual4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="lessEqual(long, double)", value=FixnumNodes.LessEqualNode.class)
            private static final class LessEqual3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                LessEqual3Node_(LessEqualNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((LessEqual3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.lessEqual(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.lessEqual(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root, Object arguments0Value) {
                    return new LessEqual3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="lessEqual(long, long)", value=FixnumNodes.LessEqualNode.class)
            private static final class LessEqual2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                LessEqual2Node_(LessEqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((LessEqual2Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((LessEqual2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.lessEqual(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.lessEqual(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new LessEqual2Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="lessEqual(int, RubyBasicObject)", value=FixnumNodes.LessEqualNode.class)
            private static final class LessEqual1Node_
            extends BaseNode_ {
                LessEqual1Node_(LessEqualNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.lessEqual(arguments0Value_, arguments1Value_);
                    }
                    return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.lessEqual(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root) {
                    return new LessEqual1Node_(root);
                }
            }

            @GeneratedBy(methodName="lessEqual(int, int)", value=FixnumNodes.LessEqualNode.class)
            private static final class LessEqual0Node_
            extends BaseNode_ {
                LessEqual0Node_(LessEqualNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessEqualNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.lessEqual(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.lessEqual(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root) {
                    return new LessEqual0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LessEqualNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LessEqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessEqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LessEqualNodeGen root;

                BaseNode_(LessEqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return LessEqualNodeGen.expectBoolean(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return LessEqual0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return LessEqual1Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return LessEqual2Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return LessEqual3Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return LessEqual4Node_.create(this.root, arguments0Value);
                        }
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return LessEqualCoercedNode_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.LessNode.class)
    public static final class LessNodeFactory
    extends NodeFactoryBase<FixnumNodes.LessNode> {
        private static LessNodeFactory lessNodeFactoryInstance;

        private LessNodeFactory() {
            super(FixnumNodes.LessNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.LessNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LessNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.LessNode> getInstance() {
            if (lessNodeFactoryInstance == null) {
                lessNodeFactoryInstance = new LessNodeFactory();
            }
            return lessNodeFactoryInstance;
        }

        public static FixnumNodes.LessNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LessNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        public static final class LessNodeGen
        extends FixnumNodes.LessNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LessNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="lessCoerced(VirtualFrame, long, Object)", value=FixnumNodes.LessNode.class)
            private static final class LessCoercedNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                LessCoercedNode_(LessNodeGen root, Object arguments0Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((LessCoercedNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    if (!(RubyGuards.isRubyBignum(arguments1Value_) || RubyGuards.isInteger(arguments1Value_) || RubyGuards.isLong(arguments1Value_) || RubyGuards.isDouble(arguments1Value_))) {
                        return this.root.lessCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return this.root.lessCoerced(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root, Object arguments0Value) {
                    return new LessCoercedNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="less(long, RubyBasicObject)", value=FixnumNodes.LessNode.class)
            private static final class Less4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Less4Node_(LessNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Less4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.less(arguments0Value_, arguments1Value_);
                    }
                    return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.less(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root, Object arguments0Value) {
                    return new Less4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="less(long, double)", value=FixnumNodes.LessNode.class)
            private static final class Less3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Less3Node_(LessNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Less3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.less(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.less(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root, Object arguments0Value) {
                    return new Less3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="less(long, long)", value=FixnumNodes.LessNode.class)
            private static final class Less2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Less2Node_(LessNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Less2Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Less2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.less(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.less(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Less2Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="less(int, RubyBasicObject)", value=FixnumNodes.LessNode.class)
            private static final class Less1Node_
            extends BaseNode_ {
                Less1Node_(LessNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.less(arguments0Value_, arguments1Value_);
                    }
                    return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.less(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root) {
                    return new Less1Node_(root);
                }
            }

            @GeneratedBy(methodName="less(int, int)", value=FixnumNodes.LessNode.class)
            private static final class Less0Node_
            extends BaseNode_ {
                Less0Node_(LessNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return LessNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.less(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.less(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root) {
                    return new Less0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.LessNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LessNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.LessNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LessNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LessNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.LessNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LessNodeGen root;

                BaseNode_(LessNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return LessNodeGen.expectBoolean(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return Less0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Less1Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Less2Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Less3Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Less4Node_.create(this.root, arguments0Value);
                        }
                        if (!(RubyGuards.isRubyBignum(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || RubyGuards.isDouble(arguments1Value))) {
                            return LessCoercedNode_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.DivModNode.class)
    public static final class DivModNodeFactory
    extends NodeFactoryBase<FixnumNodes.DivModNode> {
        private static DivModNodeFactory divModNodeFactoryInstance;

        private DivModNodeFactory() {
            super(FixnumNodes.DivModNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.DivModNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DivModNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.DivModNode> getInstance() {
            if (divModNodeFactoryInstance == null) {
                divModNodeFactoryInstance = new DivModNodeFactory();
            }
            return divModNodeFactoryInstance;
        }

        public static FixnumNodes.DivModNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DivModNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        public static final class DivModNodeGen
        extends FixnumNodes.DivModNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private DivModNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="divMod(long, double)", value=FixnumNodes.DivModNode.class)
            private static final class DivMod2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                DivMod2Node_(DivModNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((DivMod2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.divMod(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.divMod(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivModNodeGen root, Object arguments0Value) {
                    return new DivMod2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="divMod(long, RubyBasicObject)", value=FixnumNodes.DivModNode.class)
            private static final class DivMod1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                DivMod1Node_(DivModNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((DivMod1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.divMod(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.divMod(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivModNodeGen root, Object arguments0Value) {
                    return new DivMod1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="divMod(long, long)", value=FixnumNodes.DivModNode.class)
            private static final class DivMod0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                DivMod0Node_(DivModNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((DivMod0Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((DivMod0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.divMod(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.divMod(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivModNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new DivMod0Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(value=FixnumNodes.DivModNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DivModNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.DivModNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DivModNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.DivModNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DivModNodeGen root;

                BaseNode_(DivModNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        RubyBasicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return DivMod0Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return DivMod1Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return DivMod2Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.ModNode.class)
    public static final class ModNodeFactory
    extends NodeFactoryBase<FixnumNodes.ModNode> {
        private static ModNodeFactory modNodeFactoryInstance;

        private ModNodeFactory() {
            super(FixnumNodes.ModNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.ModNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ModNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.ModNode> getInstance() {
            if (modNodeFactoryInstance == null) {
                modNodeFactoryInstance = new ModNodeFactory();
            }
            return modNodeFactoryInstance;
        }

        public static FixnumNodes.ModNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ModNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        public static final class ModNodeGen
        extends FixnumNodes.ModNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ModNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="mod(long, RubyBasicObject)", value=FixnumNodes.ModNode.class)
            private static final class Mod3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Mod3Node_(ModNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Mod3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.mod(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.mod(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root, Object arguments0Value) {
                    return new Mod3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="mod(long, long)", value=FixnumNodes.ModNode.class)
            private static final class Mod2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Mod2Node_(ModNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Mod2Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Mod2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_(frameValue);
                            return ModNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return ModNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                        }
                    }
                    return this.root.mod(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.mod(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Mod2Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="mod(long, double)", value=FixnumNodes.ModNode.class)
            private static final class Mod1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Mod1Node_(ModNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Mod1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return ModNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ModNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.mod(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.mod(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root, Object arguments0Value) {
                    return new Mod1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="mod(int, int)", value=FixnumNodes.ModNode.class)
            private static final class Mod0Node_
            extends BaseNode_ {
                Mod0Node_(ModNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return ModNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ModNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.mod(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.mod(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root) {
                    return new Mod0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ModNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ModNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ModNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ModNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ModNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.ModNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ModNodeGen root;

                BaseNode_(ModNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ModNodeGen.expectDouble(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ModNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ModNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        return Mod0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        RubyBasicObject arguments1Value_;
                        if (arguments1Value instanceof Double) {
                            return Mod1Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Mod2Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Mod3Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.DivNode.class)
    public static final class DivNodeFactory
    extends NodeFactoryBase<FixnumNodes.DivNode> {
        private static DivNodeFactory divNodeFactoryInstance;

        private DivNodeFactory() {
            super(FixnumNodes.DivNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.DivNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DivNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.DivNode> getInstance() {
            if (divNodeFactoryInstance == null) {
                divNodeFactoryInstance = new DivNodeFactory();
            }
            return divNodeFactoryInstance;
        }

        public static FixnumNodes.DivNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DivNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        public static final class DivNodeGen
        extends FixnumNodes.DivNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeDiv0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeDiv1_;
            @Node.Child
            private BaseNode_ specialization_;

            private DivNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="divCoerced(VirtualFrame, long, RubyBasicObject)", value=FixnumNodes.DivNode.class)
            private static final class DivCoerced1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                DivCoerced1Node_(DivNodeGen root, Object arguments0Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((DivCoerced1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.divCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.divCoerced(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root, Object arguments0Value) {
                    return new DivCoerced1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="div(long, RubyBasicObject)", value=FixnumNodes.DivNode.class)
            private static final class Div3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Div3Node_(DivNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Div3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return DivNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return DivNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.div(arguments0Value_, arguments1Value_);
                    }
                    return DivNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.div(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root, Object arguments0Value) {
                    return new Div3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="div(long, double)", value=FixnumNodes.DivNode.class)
            private static final class Div2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Div2Node_(DivNodeGen root, Object arguments0Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Div2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return DivNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return DivNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.div(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.div(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root, Object arguments0Value) {
                    return new Div2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="divEdgeCase(long, long)", value=FixnumNodes.DivNode.class)
            private static final class DivEdgeCase1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                DivEdgeCase1Node_(DivNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((DivEdgeCase1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((DivEdgeCase1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_(frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.divEdgeCase(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.divEdgeCase(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new DivEdgeCase1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="div(long, long)", value=FixnumNodes.DivNode.class)
            private static final class Div1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Div1Node_(DivNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Div1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Div1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return DivNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_(frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return DivNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    try {
                        return this.root.div(arguments0Value_, arguments1Value_);
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.excludeDiv1_ = true;
                        return DivNodeGen.expectLong(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        try {
                            return this.root.div(arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeDiv1_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Div1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="divCoerced(VirtualFrame, int, RubyBasicObject)", value=FixnumNodes.DivNode.class)
            private static final class DivCoerced0Node_
            extends BaseNode_ {
                DivCoerced0Node_(DivNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.divCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.divCoerced(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new DivCoerced0Node_(root);
                }
            }

            @GeneratedBy(methodName="divEdgeCase(int, int)", value=FixnumNodes.DivNode.class)
            private static final class DivEdgeCase0Node_
            extends BaseNode_ {
                DivEdgeCase0Node_(DivNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.divEdgeCase(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.divEdgeCase(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new DivEdgeCase0Node_(root);
                }
            }

            @GeneratedBy(methodName="div(int, int)", value=FixnumNodes.DivNode.class)
            private static final class Div0Node_
            extends BaseNode_ {
                Div0Node_(DivNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return DivNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return DivNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    try {
                        return this.root.div(arguments0Value_, arguments1Value_);
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.excludeDiv0_ = true;
                        return DivNodeGen.expectInteger(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        try {
                            return this.root.div(arguments0Value_, arguments1Value_);
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.excludeDiv0_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new Div0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.DivNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DivNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.DivNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DivNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.DivNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DivNodeGen root;

                BaseNode_(DivNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return DivNodeGen.expectDouble(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return DivNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return DivNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            if (!this.root.excludeDiv0_) {
                                return Div0Node_.create(this.root);
                            }
                            return DivEdgeCase0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && !RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return DivCoerced0Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            if (!this.root.excludeDiv1_) {
                                return Div1Node_.create(this.root, arguments0Value, arguments1Value);
                            }
                            return DivEdgeCase1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Div2Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments1Value_)) {
                                return Div3Node_.create(this.root, arguments0Value);
                            }
                            return DivCoerced1Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<FixnumNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(FixnumNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        public static FixnumNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MulNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        public static final class MulNodeGen
        extends FixnumNodes.MulNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeMul0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeMul1_;
            @Node.Child
            private BaseNode_ specialization_;

            private MulNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="mulCoerced(VirtualFrame, long, RubyBasicObject)", value=FixnumNodes.MulNode.class)
            private static final class MulCoerced1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                MulCoerced1Node_(MulNodeGen root, Object arguments0Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((MulCoerced1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.mulCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.mulCoerced(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, Object arguments0Value) {
                    return new MulCoerced1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="mul(long, RubyBasicObject)", value=FixnumNodes.MulNode.class)
            private static final class Mul3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Mul3Node_(MulNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Mul3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.mul(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.mul(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, Object arguments0Value) {
                    return new Mul3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="mul(long, double)", value=FixnumNodes.MulNode.class)
            private static final class Mul2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Mul2Node_(MulNodeGen root, Object arguments0Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Mul2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return MulNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.mul(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.mul(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, Object arguments0Value) {
                    return new Mul2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="mulWithOverflow(long, long)", value=FixnumNodes.MulNode.class)
            private static final class MulWithOverflow1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                MulWithOverflow1Node_(MulNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((MulWithOverflow1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((MulWithOverflow1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_(frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.mulWithOverflow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.mulWithOverflow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new MulWithOverflow1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="mul(long, long)", value=FixnumNodes.MulNode.class)
            private static final class Mul1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Mul1Node_(MulNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Mul1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Mul1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return MulNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_(frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    try {
                        return this.root.mul(arguments0Value_, arguments1Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeMul1_ = true;
                        return MulNodeGen.expectLong(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        try {
                            return this.root.mul(arguments0Value_, arguments1Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeMul1_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Mul1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="mulCoerced(VirtualFrame, int, RubyBasicObject)", value=FixnumNodes.MulNode.class)
            private static final class MulCoerced0Node_
            extends BaseNode_ {
                MulCoerced0Node_(MulNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.mulCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.mulCoerced(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new MulCoerced0Node_(root);
                }
            }

            @GeneratedBy(methodName="mulWithOverflow(int, int)", value=FixnumNodes.MulNode.class)
            private static final class MulWithOverflow0Node_
            extends BaseNode_ {
                MulWithOverflow0Node_(MulNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return MulNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.mulWithOverflow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.mulWithOverflow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new MulWithOverflow0Node_(root);
                }
            }

            @GeneratedBy(methodName="mul(int, int)", value=FixnumNodes.MulNode.class)
            private static final class Mul0Node_
            extends BaseNode_ {
                Mul0Node_(MulNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return MulNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    try {
                        return this.root.mul(arguments0Value_, arguments1Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeMul0_ = true;
                        return MulNodeGen.expectInteger(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        try {
                            return this.root.mul(arguments0Value_, arguments1Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeMul0_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new Mul0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.MulNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MulNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.MulNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MulNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.MulNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MulNodeGen root;

                BaseNode_(MulNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return MulNodeGen.expectDouble(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return MulNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return MulNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            if (!this.root.excludeMul0_) {
                                return Mul0Node_.create(this.root);
                            }
                            return MulWithOverflow0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && !RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return MulCoerced0Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            if (!this.root.excludeMul1_) {
                                return Mul1Node_.create(this.root, arguments0Value, arguments1Value);
                            }
                            return MulWithOverflow1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Mul2Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments1Value_)) {
                                return Mul3Node_.create(this.root, arguments0Value);
                            }
                            return MulCoerced1Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.SubNode.class)
    public static final class SubNodeFactory
    extends NodeFactoryBase<FixnumNodes.SubNode> {
        private static SubNodeFactory subNodeFactoryInstance;

        private SubNodeFactory() {
            super(FixnumNodes.SubNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.SubNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SubNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.SubNode> getInstance() {
            if (subNodeFactoryInstance == null) {
                subNodeFactoryInstance = new SubNodeFactory();
            }
            return subNodeFactoryInstance;
        }

        public static FixnumNodes.SubNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SubNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        public static final class SubNodeGen
        extends FixnumNodes.SubNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeSub0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeSub1_;
            @Node.Child
            private BaseNode_ specialization_;

            private SubNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="subCoerced(VirtualFrame, long, RubyBasicObject)", value=FixnumNodes.SubNode.class)
            private static final class SubCoerced1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                SubCoerced1Node_(SubNodeGen root, Object arguments0Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((SubCoerced1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.subCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.subCoerced(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root, Object arguments0Value) {
                    return new SubCoerced1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="sub(long, RubyBasicObject)", value=FixnumNodes.SubNode.class)
            private static final class Sub3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Sub3Node_(SubNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Sub3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.sub(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.sub(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root, Object arguments0Value) {
                    return new Sub3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="sub(long, double)", value=FixnumNodes.SubNode.class)
            private static final class Sub2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Sub2Node_(SubNodeGen root, Object arguments0Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Sub2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return SubNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return SubNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.sub(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.sub(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root, Object arguments0Value) {
                    return new Sub2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="subWithOverflow(long, long)", value=FixnumNodes.SubNode.class)
            private static final class SubWithOverflow1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                SubWithOverflow1Node_(SubNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((SubWithOverflow1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((SubWithOverflow1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_(frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.subWithOverflow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.subWithOverflow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new SubWithOverflow1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="sub(long, long)", value=FixnumNodes.SubNode.class)
            private static final class Sub1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Sub1Node_(SubNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Sub1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Sub1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return SubNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_(frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return SubNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    try {
                        return this.root.sub(arguments0Value_, arguments1Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeSub1_ = true;
                        return SubNodeGen.expectLong(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        try {
                            return this.root.sub(arguments0Value_, arguments1Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeSub1_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Sub1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="subCoerced(VirtualFrame, int, RubyBasicObject)", value=FixnumNodes.SubNode.class)
            private static final class SubCoerced0Node_
            extends BaseNode_ {
                SubCoerced0Node_(SubNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.subCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.subCoerced(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new SubCoerced0Node_(root);
                }
            }

            @GeneratedBy(methodName="subWithOverflow(int, int)", value=FixnumNodes.SubNode.class)
            private static final class SubWithOverflow0Node_
            extends BaseNode_ {
                SubWithOverflow0Node_(SubNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return SubNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return SubNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.subWithOverflow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.subWithOverflow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new SubWithOverflow0Node_(root);
                }
            }

            @GeneratedBy(methodName="sub(int, int)", value=FixnumNodes.SubNode.class)
            private static final class Sub0Node_
            extends BaseNode_ {
                Sub0Node_(SubNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return SubNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return SubNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    try {
                        return this.root.sub(arguments0Value_, arguments1Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeSub0_ = true;
                        return SubNodeGen.expectInteger(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        try {
                            return this.root.sub(arguments0Value_, arguments1Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeSub0_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new Sub0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.SubNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SubNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.SubNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SubNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.SubNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SubNodeGen root;

                BaseNode_(SubNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return SubNodeGen.expectDouble(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return SubNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return SubNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            if (!this.root.excludeSub0_) {
                                return Sub0Node_.create(this.root);
                            }
                            return SubWithOverflow0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && !RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return SubCoerced0Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            if (!this.root.excludeSub1_) {
                                return Sub1Node_.create(this.root, arguments0Value, arguments1Value);
                            }
                            return SubWithOverflow1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Sub2Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments1Value_)) {
                                return Sub3Node_.create(this.root, arguments0Value);
                            }
                            return SubCoerced1Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<FixnumNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(FixnumNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AddNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        public static FixnumNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AddNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        public static final class AddNodeGen
        extends FixnumNodes.AddNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeAdd0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeAdd1_;
            @Node.Child
            private BaseNode_ specialization_;

            private AddNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="addCoerced(VirtualFrame, long, RubyBasicObject)", value=FixnumNodes.AddNode.class)
            private static final class AddCoerced1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                AddCoerced1Node_(AddNodeGen root, Object arguments0Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((AddCoerced1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.addCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.addCoerced(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root, Object arguments0Value) {
                    return new AddCoerced1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="add(long, RubyBasicObject)", value=FixnumNodes.AddNode.class)
            private static final class Add3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Add3Node_(AddNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Add3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.add(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.add(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root, Object arguments0Value) {
                    return new Add3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="add(long, double)", value=FixnumNodes.AddNode.class)
            private static final class Add2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Add2Node_(AddNodeGen root, Object arguments0Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Add2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return AddNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return AddNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.add(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.add(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root, Object arguments0Value) {
                    return new Add2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="addWithOverflow(long, long)", value=FixnumNodes.AddNode.class)
            private static final class AddWithOverflow1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                AddWithOverflow1Node_(AddNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((AddWithOverflow1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((AddWithOverflow1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_(frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.addWithOverflow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.addWithOverflow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new AddWithOverflow1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="add(long, long)", value=FixnumNodes.AddNode.class)
            private static final class Add1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Add1Node_(AddNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Add1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Add1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return AddNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_(frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return AddNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    try {
                        return this.root.add(arguments0Value_, arguments1Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeAdd1_ = true;
                        return AddNodeGen.expectLong(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        try {
                            return this.root.add(arguments0Value_, arguments1Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeAdd1_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Add1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="addCoerced(VirtualFrame, int, RubyBasicObject)", value=FixnumNodes.AddNode.class)
            private static final class AddCoerced0Node_
            extends BaseNode_ {
                AddCoerced0Node_(AddNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.addCoerced(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.addCoerced(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddCoerced0Node_(root);
                }
            }

            @GeneratedBy(methodName="addWithOverflow(int, int)", value=FixnumNodes.AddNode.class)
            private static final class AddWithOverflow0Node_
            extends BaseNode_ {
                AddWithOverflow0Node_(AddNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return AddNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return AddNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.addWithOverflow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.addWithOverflow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddWithOverflow0Node_(root);
                }
            }

            @GeneratedBy(methodName="add(int, int)", value=FixnumNodes.AddNode.class)
            private static final class Add0Node_
            extends BaseNode_ {
                Add0Node_(AddNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return AddNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return AddNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    try {
                        return this.root.add(arguments0Value_, arguments1Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeAdd0_ = true;
                        return AddNodeGen.expectInteger(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        try {
                            return this.root.add(arguments0Value_, arguments1Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeAdd0_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_, (Object)arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new Add0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.AddNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AddNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.AddNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AddNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.AddNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final AddNodeGen root;

                BaseNode_(AddNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return AddNodeGen.expectDouble(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return AddNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return AddNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            if (!this.root.excludeAdd0_) {
                                return Add0Node_.create(this.root);
                            }
                            return AddWithOverflow0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && !RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return AddCoerced0Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            if (!this.root.excludeAdd1_) {
                                return Add1Node_.create(this.root, arguments0Value, arguments1Value);
                            }
                            return AddWithOverflow1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Add2Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments1Value_)) {
                                return Add3Node_.create(this.root, arguments0Value);
                            }
                            return AddCoerced1Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.NegNode.class)
    public static final class NegNodeFactory
    extends NodeFactoryBase<FixnumNodes.NegNode> {
        private static NegNodeFactory negNodeFactoryInstance;

        private NegNodeFactory() {
            super(FixnumNodes.NegNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public FixnumNodes.NegNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NegNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumNodes.NegNode> getInstance() {
            if (negNodeFactoryInstance == null) {
                negNodeFactoryInstance = new NegNodeFactory();
            }
            return negNodeFactoryInstance;
        }

        public static FixnumNodes.NegNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NegNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumNodes.NegNode.class)
        public static final class NegNodeGen
        extends FixnumNodes.NegNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeNeg0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeNeg1_;
            @Node.Child
            private BaseNode_ specialization_;

            private NegNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="negWithOverflow(long)", value=FixnumNodes.NegNode.class)
            private static final class NegWithOverflow1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                NegWithOverflow1Node_(NegNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((NegWithOverflow1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, ex.getResult());
                    }
                    return this.root.negWithOverflow(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.negWithOverflow(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root, Object arguments0Value) {
                    return new NegWithOverflow1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="neg(long)", value=FixnumNodes.NegNode.class)
            private static final class Neg1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Neg1Node_(NegNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Neg1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return NegNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    try {
                        return this.root.neg(arguments0Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeNeg1_ = true;
                        return NegNodeGen.expectLong(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        try {
                            return this.root.neg(arguments0Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeNeg1_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root, Object arguments0Value) {
                    return new Neg1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="negWithOverflow(int)", value=FixnumNodes.NegNode.class)
            private static final class NegWithOverflow0Node_
            extends BaseNode_ {
                NegWithOverflow0Node_(NegNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, ex.getResult());
                    }
                    return this.root.negWithOverflow(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.negWithOverflow(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root) {
                    return new NegWithOverflow0Node_(root);
                }
            }

            @GeneratedBy(methodName="neg(int)", value=FixnumNodes.NegNode.class)
            private static final class Neg0Node_
            extends BaseNode_ {
                Neg0Node_(NegNodeGen root) {
                    super(root, 1);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    if (newNode.getClass() == NegWithOverflow0Node_.class) {
                        this.removeSame("Contained by negWithOverflow(int)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return NegNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    try {
                        return this.root.neg(arguments0Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeNeg0_ = true;
                        return NegNodeGen.expectInteger(this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_));
                    }
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        try {
                            return this.root.neg(arguments0Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeNeg0_ = true;
                            return this.remove("threw rewrite exception", (Frame)frameValue, (Object)arguments0Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root) {
                    return new Neg0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.NegNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(NegNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.NegNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NegNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumNodes.NegNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final NegNodeGen root;

                BaseNode_(NegNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return NegNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return NegNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        if (!this.root.excludeNeg0_) {
                            return Neg0Node_.create(this.root);
                        }
                        this.root.excludeNeg0_ = true;
                        return NegWithOverflow0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (!this.root.excludeNeg1_) {
                            return Neg1Node_.create(this.root, arguments0Value);
                        }
                        return NegWithOverflow1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }
            }
        }
    }
}

